<?php
/**
 * The Template for displaying filter selected terms.
 *
 * This template can be overridden by copying it to yourtheme/filters/chips.php.
 *
 * $chips - array, with the SFS Set parameters
 *
 * @see https://www.searchfiltersort.com/
 */

if ( ! defined('ABSPATH') ) {
    exit;
}
global $sfs_chips_count;
// Iterate global chips widget count
$selected_and_above_status = (isset($filter['selected_and_above']) && $filter['selected_and_above'] === 'yes') ? true : false;
$sfs_chips_count++;
?>
<ul class="sfswp-filter-chips-list sfswp-filter-chips-<?php echo esc_attr( $setid .'-' .$sfs_chips_count ); ?> sfswp-filter-chips-<?php echo esc_attr( $setid ); ?><?php if( ! $chips ){echo ' sfswp-empty-chips-container';} ?>" data-set="<?php echo esc_attr( $setid ); ?>" data-setcount="<?php echo $setid .'-' .$sfs_chips_count ; ?>">
    <?php if( $chips ) : ?>
        <?php foreach( $chips as $chip ): ?>
            <li class="sfswp-filter-chip <?php echo esc_attr( $chip['class'] ); ?>"><a href="<?php echo esc_url( $chip['link'] ); ?>" title="<?php if( $chip['name'] !== esc_html__('Reset all', 'searchfiltersort') ){
                    if ( $chip['class'] === 'sfswp-chip-search' ) {
                        echo esc_attr( sprintf( __('Remove %s from results', 'searchfiltersort'), '&laquo;'.$chip['label'].'&raquo;' ) );
                    } else {
                        echo esc_attr( sprintf( __('Remove %s from results', 'searchfiltersort'), '&laquo;'.$chip['label'] .': '.$chip['name'].'&raquo;' ) );
                    }
                } ?>"><span class="sfswp-chip-content"><?php if(isset($chip['rating'])) : ?><span class="sfswp-chip-stars"><?php
                            for ($i = 1; $i <=  $chip['rating']; $i++){
                                echo '<span>' . sfs_rating_star() . '</span>';
                            }
                            ?></span><?php
                        else :
                            ?><span class="sfswp-filter-chip-name"><?php echo esc_html( $chip['name'] ); ?></span><?php
                        endif;
                        ?><span class="sfswp-chip-remove-icon">&#215;</span></a></span></li>
        <?php endforeach; ?>
    <?php endif; ?>
</ul>