<?php
/**
 * The Template for displaying filter checkboxes.
 *
 * This template can be overridden by copying it to yourtheme/filters/checkboxes.php.
 *
 * $set - array, with the SFS Set parameters
 * $filter - array, with the Filter parameters
 * $url_manager - object, of the UrlManager PHP class
 * $terms - array, with objects of all filter terms except excluded
 *
 * @see https://www.searchfiltersort.com/
 */

if ( ! defined('ABSPATH') ) {
    exit;
}

$args = [
    'hide' => $view_args['ask_to_select_parent']
];

?>
<div class="<?php echo sfs_filter_class( $filter, [], $terms, $args ); // Already escaped ?>" data-fid="<?php echo esc_attr( $filter['ID'] ); ?>">
    <?php sfs_filter_header( $filter, $terms ); // Safe, escaped ?>
    <div class="<?php echo esc_attr( sfs_filter_content_class( $filter ) ); ?>">
        <?php sfs_filter_search_field( $filter, $view_args, $terms ); ?>
        <ul class="sfswp-filters-ul-list sfswp-filters-checkboxes sfswp-filters-list-<?php echo esc_attr( $filter['ID'] ); ?>"><?php

            if( ! empty( $terms ) || $view_args['ask_to_select_parent'] ):

                 if( $view_args['ask_to_select_parent'] !== false ) { ?>
                     <li><?php echo esc_html( $view_args['ask_to_select_parent'] ); ?></li>
                <?php } else {

                     $args = array(
                         'url_manager'  => $url_manager,
                         'filter'       => $filter,
                         'show_count'   => $set['show_count']['value'],
                         'set'          => $set
                     );

                     echo sfs_filter_walk_terms_tree( $terms, $args );
                 }
            else:
                sfs_filter_no_terms_message();
            endif;

?>      </ul>
        <?php sfs_filter_more_less( $filter ); ?>
    </div>
</div>