<?php
/**
 * The Template for displaying Filters widget bottom controls.
 *
 * This template can be overridden by copying it to yourtheme/filters/bottom-controls.php.
 *
 * $action_url - string, URL to the page with filtering results
 * $found_posts - int|NULL, found posts number
 *
 * @see https://www.searchfiltersort.com/
 */

if ( ! defined('ABSPATH') ) {
    exit;
}

?>
<div class="sfswp-filters-widget-controls-item sfswp-filters-widget-controls-one">
    <a class="sfswp-filters-apply-button sfswp-posts-loaded" href="<?php echo esc_url($action_url); ?>"><?php
        echo wp_kses(
            sprintf( __('Show %s', 'searchfiltersort'),
            '<span class="sfswp-filters-found-posts-wrapper">(<span class="sfswp-filters-found-posts">'.esc_html($found_posts).'</span>)</span>'),
        array( 'span' => array('class'=>true) )
        );
  ?></a>
</div>
<div class="sfswp-filters-widget-controls-item sfswp-filters-widget-controls-two">
    <a class="sfswp-filters-close-button" href="<?php echo esc_url($action_url); ?>"><?php
        echo esc_html__('Cancel', 'searchfiltersort');
        ?>
    </a>
</div>