<?php

if ( ! defined('ABSPATH') ) {
    exit;
}
$css_class    = 'sfswp-filter-item sfswp-filter-not-listed sfswp-filter-item-sort-field sfswp-filter-' . $sort_field_order['value'];
$css_class    .= ( isset( $use_sort_option['value'] ) && $use_sort_option['value'] === 'yes' ) ? ' sfswp-opened' : '';

$sort_label = ( isset( $sort_field_label['value'] ) ) ? $sort_field_label['value'] : esc_html__('Sort', 'sortfiltersort' );

?>
<div id="sfswp-filter-id-sort-field" class="<?php echo esc_attr( $css_class ); ?>" data-fid="sort-field">
    <div class="sfswp-filter-head">
        <div class="sfswp-filter-title ui-sortable-handle">
            <ul class="sfswp-custom-row sfswp-filter-item-labels">
                <li class="sfswp-filter-order" title="<?php echo $sort_field_order['value']; ?>"><span class="sfswp-filter-sortable-handle dashicons dashicons-menu"></span></li>
                <li class="sfswp-filter-label"><?php echo $sort_label; ?></li>
                <li class="sfswp-filter-entity"><select class="sortingdash" disabled><option selected="selected" ><?php echo 'Default Sorting' ?></option></select></li>
                <li class="sfswp-filter-view">&nbsp;</li>
                <li class="sfswp-filter-slug">&nbsp;</li>
            </ul>
        </div>
    </div>
    <div class="sfswp-filter-body">
        <div class="sfswp-filter-main-fields">
            <table class="sfswp-form-fields-table sfswp-filter-sort-field">
                <tr class="sfswp-filter-tr">
                    <td colspan="2">
                        <?php echo sfs_render_input( $sort_field_order ); ?>
                    </td>
                </tr>
            </table>
        </div>
    </div>
</div>