<?php

if ( ! defined('ABSPATH') ) {
    exit;
}

    $set_id    = $post->ID;
    $filters    = sfs_get_configured_filters( $set_id );

    $filterSet  = \SearchFilterSort\Filter\Container::instance()->getSFSSetService();
    $the_set    = $filterSet->getSet( $set_id );
    $order = 1;

    $base = count($filters) + 1;

    $search_field_order   = ( isset( $the_set['search_field_menu_order']['value'] ) && $the_set['search_field_menu_order']['value'] > -1 ) ? (int)$the_set['search_field_menu_order']['value'] : $base;
    $sort_field_order   = ( isset( $the_set['sort_field_menu_order']['value'] ) && $the_set['sort_field_menu_order']['value'] > -1 ) ? (int)$the_set['sort_field_menu_order']['value'] : ($base + 1);

    // To avoid equal order for both elements
    $apply_button_order = ( isset( $the_set['apply_button_menu_order']['value'] ) && $the_set['apply_button_menu_order']['value'] > -1 ) ? (int)$the_set['apply_button_menu_order']['value'] : ($base + 2);

    if ( $apply_button_order === $search_field_order ) {
        $apply_button_order++;
    }
    if ( $apply_button_order === $sort_field_order ) {
        $apply_button_order++;
    }

    $apply_btn_displayed  = false;
    $search_fld_displayed = false;
    $sort_fld_displayed = false;
    if ( isset( $the_set['use_search_field']['value'] ) && $the_set['use_search_field']['value'] === 'yes' ) {
        $search_fld_displayed = true;
    }
    if ( isset( $the_set['use_sort_option']['value'] ) && $the_set['use_sort_option']['value'] === 'yes' ) {
        $sort_fld_displayed = true;
    }

?>
<div class="sfswp-sfs-set-wrapper sfsfilter">
    <div class="sfswp-sfs-set-hidden-fields">
        <input type="hidden" id="sfswp_set_nonce" name="_sfs_nonce" value="<?php echo esc_attr( sfs_create_filters_nonce() ); ?>" />
    </div>
    <div class="sfswp-column-labels-wrapper">
        <table class="sfswp-form-fields-table">
            <?php

            $attributes['post_type'] = $the_set['post_type'];
            $post_type  = ( isset( $the_set['post_type']['value'] ) && $the_set['post_type']['value'] ) ? $the_set['post_type']['value'] : $the_set['post_type']['default'];

            sfs_include_admin_view('sfs-field', array(
                    'field_key'  => key($attributes),
                    'attributes' =>  reset($attributes)
                )
            );

            ?>
        </table>
    </div>
    <div class="sfswp-column-labels-wrapper">
        <div class="sfswp-column-labels widget-title">
            <ul class="sfswp-custom-row">
                <li class="sfswp-filter-order">&nbsp;</li>
                <li class="sfswp-filter-label"><?php esc_html_e('Title', 'searchfiltersort' ); ?></li>
                <li class="sfswp-filter-entity"><?php esc_html_e('Filter by', 'searchfiltersort' ); ?></li>
                <li class="sfswp-filter-view"><?php esc_html_e('View', 'searchfiltersort' ); ?></li>
                <li class="sfswp-filter-slug"><?php esc_html_e('URL Prefix', 'searchfiltersort' ); ?></li>
            </ul>
        </div>
    </div>
    <div class="sfswp-no-filters"<?php if( ! $filters && ! $search_fld_displayed ){ echo ' style="display: block;"'; }?>>
        <?php
            echo wp_kses(
                    __('There are no filters yet. Click the <strong>Add Filter</strong> button to create your first one.', 'searchfiltersort' ),
                    array( 'strong' => array() )
                );
            ?>
    </div>
    <div id="sfswp-filters-list" class="sfswp-filters-list" data-posttype="<?php echo $post_type; ?>">

        <?php
                $filters_and_fields = [];
                $filters            = array_reverse( $filters, true );
                //$to                 = count( $filters ) + 2;
                $to                 = count( $filters ) + 3;

                for ( $i = 1; $i <= $to; $i++ ) {
                    if ( $apply_button_order === $i ) {
                        $filters_and_fields[-1] = array();
                    } else if ( $search_field_order === $i ) {
                        $filters_and_fields[-2] = array();
                    } else if ( $sort_field_order === $i ) {
                        $filters_and_fields[-3] = array();
                    } else {
                        // To avoid "empty" filter
                        if ( ! empty( $filters ) ) {
                            $key    = array_key_last( $filters );
                            $value  = array_pop( $filters );
                            $filters_and_fields[$key] = $value;
                        }
                    }
                }

                if( $filters_and_fields ):

                foreach( $filters_and_fields as $filter_id => $filter ):

                    if ( $filter_id >= 0 ) {
                        sfs_include_admin_view( 'sfs-row', array( 'filter' => $filter ) );
                    } else {
                        if ( $search_field_order == $order ) {
                            sfs_include_admin_view( 'sfs-search-field', array(
                                    'search_field_order'        => $the_set['search_field_menu_order'],
                                    'use_search_field'          => $the_set['use_search_field'],
                                    'search_field_placeholder'  => $the_set['search_field_placeholder'],
                                    'search_field_label'        => $the_set['search_field_label'],
                                    'post_type_args'            => $the_set['post_type'],
                                )
                            );
                        }

                        if ( $apply_button_order == $order ) {
                            sfs_include_admin_view( 'sfs-apply-button', array(
                                    'apply_button'          => $the_set['apply_button_menu_order'],
                                    'use_apply_button'      => $the_set['use_apply_button'],
                                    'apply_button_text'     => $the_set['apply_button_text'],
                                    'reset_button_text'     => $the_set['reset_button_text'],
                                    'apply_button_order'    => $apply_button_order
                                )
                            );
                        }
                        if ( $sort_field_order == $order ) {
                            sfs_include_admin_view( 'sfs-sort-field', array(
                                    'sort_field_order'        => $the_set['sort_field_menu_order'],
                                    'use_sort_option'         => $the_set['use_sort_option'],
                                    'post_type_args'          => $the_set['post_type'],
                                )
                            );
                            
                        }
                    }

                    $order++;
                endforeach;

         endif; ?>
    </div>

    <div class="sfswp-add-filter-wrapper">
        <div class="sfswp-add-filter-div">
            <a href="javascript:void(0);" class="button button-primary button-large sfswp-add-filter"><?php esc_html_e('Add Filter','searchfiltersort' ); ?></a>
        </div>
    </div>

    <script type="text/html" id="sfswp-new-filter">
        <?php
            sfs_include_admin_view( 'sfs-row', array( 'filter' => sfs_get_empty_filter( $set_id ) ) );
        ?>
    </script>
</div>