<?php

if ( ! defined('ABSPATH') ) {
    exit;
} 

?>
<div class="sfswp-sfs-set-settings-wrapper">
    <table class="sfswp-form-fields-table">
        <?php
            $set_sort_fields = sfs_get_set_sort_fields( $post->ID );
            foreach ( $set_sort_fields as $key => $attributes ) {

                if( isset( $attributes['skip_view'] ) && $attributes['skip_view'] ){
                    do_action_ref_array( 'sfswp_cycle_filter_set_settings_fields', array( &$set_sort_fields ) );
                }else{
                    sfs_include_admin_view('sfs-field', array(
                            'field_key'  => $key,
                            'attributes' => $attributes
                        )
                    );
                }
            }
        ?>
    </table>
</div>
<?php
    $set_id    = $post->ID;
    //$filters    = sfs_get_configured_filters( $set_id );
    $postdata = maybe_unserialize( $post->post_content );
    $values = isset($postdata['sfswp_sorting_widget'])
        ? wp_unslash($postdata['sfswp_sorting_widget'])
        : [];

    $filterSet  = \SearchFilterSort\Filter\Container::instance()->getSFSSetService();
    $the_set    = $filterSet->getSet( $set_id );

    $post_type  = ( isset( $the_set['post_type']['value'] ) && $the_set['post_type']['value'] ) ? $the_set['post_type']['value'] : $the_set['post_type']['default'];

    $sort_fld_displayed = false;
    if ( isset( $the_set['use_sort_option']['value'] ) && $the_set['use_sort_option']['value'] === 'yes' ) {
        $sort_fld_displayed = true;
    }

?>
<div class="sfswp-sfs-set-sorting-options-settings-wrapper" <?php if(false == $sort_fld_displayed) { echo "style='display:none;'"; } ?> >
    <br>
    <label for="sfswp_set_fields-sorting_options" class="sfswp-filter-label">
        <span class="sfswp-label-text">Sorting Options</span>
    </label>
    
    <div id="sfswp-sorting-list" class="sfswp-sorting-list" data-posttype="<?php echo $post_type; ?>">
        <?php 
        $sorting = new \SearchFilterSort\Filter\Sorting();

        $defaults  = $sorting->getSortingDefaults();

        $titles    = $values['title']    ?? $defaults['titles'];
        $orderbies = $values['orderbies'] ?? $defaults['orderbies'];
        $meta_keys = $values['meta_keys'] ?? $defaults['meta_keys'];
        $orders    = $values['orders']    ?? $defaults['orders'];
        $i = 1;
        
        foreach ( $orderbies as $k => $orderby ){

            $orderbiesConfig = array(
                'class'   => 'widefat sfswp-orderby-select',
                'name'    => 'widget-sfswp_sorting_widget[orderbies]['.$i.']',
                'id'      => 'sfswp_sorting_widget-'.$i.'-orderbies',
                // Todo add new options via filter
                // First should be popular sorting criteria
                // Then common like tax or meta key
                'options' => $sorting->getSortingOptions(),
                'value'   => $orderby
            );

            $ordersConfig = array(
                'class'   => 'widefat',
                'name'    => 'widget-sfswp_sorting_widget[orders]['.$i.']',
                'id'      => 'sfswp_sorting_widget-'.$i.'-orders',
                'options' => array( 'asc' => esc_html_x('ASC', 'sorting', 'searchfiltersort'), 'desc' => esc_html_x('DESC', 'sorting', 'searchfiltersort') ),
                'value'   => $orders[$k]
            );

            $orderbiesSelect = new \SearchFilterSort\Filter\Select($orderbiesConfig);
            $ordersSelect    = new \SearchFilterSort\Filter\Select($ordersConfig);

            $templateArgs = array(
                'widget'          => array(),
                'i'               => $i,
                'title'           => $titles[$k],
                'metaKey'         => $meta_keys[$k],
                'orderbiesSelect' => $orderbiesSelect,
                'ordersSelect'    => $ordersSelect,
                'post'            => $post
            );
            sfs_include_admin_view('sorting-admin', $templateArgs );
            $i++;
        }
        ?>

    </div>
    <div class="sfswp-add-sorting-item-wrapper">
        <div class="sfswp-add-sorting-item-div">
            <a href="javascript:void(0);" class="button button-primary button-medium sfswp-add-sorting-item"><?php esc_html_e( '+ Add sorting option', 'searchfiltersort' ); ?></a>
        </div>
    </div>

    <input type="text" class="sfswp-ballast" id="widget-sfswp_sorting_widget-<?php echo $i; ?>-ballast" name="widget-sfswp_sorting_widget[<?php echo $i; ?>][ballast]" value="" style="display:none;">

    <script type="text/html" class="sfswp-new-sorting-item">
        <?php

        $i = 'sfswp_new_id';

        $orderbiesConfig = array(
            'class'   => 'widefat sfswp-orderby-select',
            'name'    => 'widget-sfswp_sorting_widget[orderbies]['.$i.']',
            'id'      => 'sfswp_sorting_widget-'.$i.'-orderbies',
            'options' => $sorting->getSortingOptions()
        );

        $ordersConfig = array(
            'class'   => 'widefat',
            'name'    => 'widget-sfswp_sorting_widget[orders]['.$i.']',
            'id'      => 'sfswp_sorting_widget-'.$i.'-orders',
            'options' => array( 'asc' => esc_html_x('ASC', 'sorting', 'searchfiltersort'), 'desc' => esc_html_x('DESC', 'sorting', 'searchfiltersort') )
        );

        $orderbiesSelect = new \SearchFilterSort\Filter\Select($orderbiesConfig);
        $ordersSelect    = new \SearchFilterSort\Filter\Select($ordersConfig);

        $templateArgs = array(
            'widget'          => array(),
            'i'               => $i,
            'title'           => '',
            'metaKey'         => '',
            'orderbiesSelect' => $orderbiesSelect,
            'ordersSelect'    => $ordersSelect,
            'post'            => $post
        );

        sfs_include_admin_view('sorting-admin', $templateArgs );

        ?>
    </script>
</div>