<?php

if ( ! defined('ABSPATH') ) {
    exit;
}

?>
<div class="sfswp-sfs-set-advices">
    <ul class="sfswp-advices">
        <li>
            <div class="sfswp-advice-head">
                <span class="sfswp-advice-title">Display filters</span>
                <button type="button" class="sfswp-action sfswp-advice-toggle widget-action hide-if-no-js" aria-expanded="false">
                    <span class="toggle-indicator" aria-hidden="true"></span>
                </button>
            </div>
            <div class="sfswp-advice-body">
                <p>Easily add powerful filtering to your site by placing the <strong>SearchFilterSort — Filters</strong> widget in any widget area or sidebar.<br /> Prefer more flexibility? Simply use the <code>[searchfiltersort]</code> shortcode to display filters anywhere on your site.
                <p><blockquote>
                    <strong>Good to know:</strong> The Filters widget appears only when an SFS Set is configured for the page being viewed. <?php
                    if ( ! defined( 'SFS_FILTERS_PRO' ) ) :
                        ?> With the <a href="<?php echo SFS_BUY_PRO_VERSION_URL; ?>" target="_blank" class="sfswp-external-link">PRO version</a>, you can choose the exact page using the <strong>Where to filter?</strong> option. In the Free version, filters are available exclusively on post type archive pages.
                <?php
                    endif; ?>.</blockquote></p>
                <?php if ( defined( 'SFS_FILTERS_PRO' ) && SFS_FILTERS_PRO ) : ?>
                <ol class="sfswp-display-widgets">
                    <li>
                        <div class="sfswp-advice-head">
                            <span class="sfswp-advice-title"><strong>Multiple Filters widget on a page</strong></span>
                            <button type="button" class="sfswp-action sfswp-advice-toggle widget-action hide-if-no-js" aria-expanded="false">
                                <span class="toggle-indicator" aria-hidden="true"></span>
                            </button>
                        </div>
                        <div class="sfswp-advice-body">
                            <p>To display several Filter widgets on a page, you need:<br />
                                - create several SFS Sets and to direct them to the desired page<br />
                                - insert several Filter Widgets or their shortcodes on this page. One widget per SFS Set.</p>
                            <p>You can change the display order of SFS Sets using the Priority field.</p>
                        </div>
                    </li>
                </ol>
                <?php endif; ?>
            </div>
        </li>
        <li>
            <div class="sfswp-advice-head">
                <span class="sfswp-advice-title">How to use Meta keys</span>
                <button type="button" class="sfswp-action sfswp-advice-toggle widget-action hide-if-no-js" aria-expanded="false">
                    <span class="toggle-indicator" aria-hidden="true"></span>
                </button>
            </div>
            <div class="sfswp-advice-body">
                <ul>
                    <li><h4><?php esc_html_e( 'WooCommerce', 'searchfiltersort' ); ?>:</h4></li>
                    <?php
                    printf( '<li><code>_price</code> - %s</li>', esc_html__( 'filter by Product price (Custom Field Numeric)', 'searchfiltersort' ) );
                    printf( '<li><code>_stock_status</code> - %s</li>', esc_html__( 'filter by Product Stock status (Custom Field)', 'searchfiltersort' ) );
                    printf( '<li><code>_sale_price</code> - %s</li>', esc_html__( 'by Sale Price (Custom Field Numeric) or on Sale Status (Custom Field Exists)', 'searchfiltersort' ) );
                    printf( '<li><code>total_sales</code> - %s</li>', esc_html__( 'by Sales Count', 'searchfiltersort' ) );
                    printf( '<li><code>_backorders</code> - %s</li>', esc_html__( 'by Backorders Status (Custom Field)', 'searchfiltersort' ) );
                    printf( '<li><code>_downloadable</code> - %s</li>', esc_html__( 'by Downloadable Status (Custom Field)', 'searchfiltersort' ) );
                    printf( '<li><code>_sold_individually</code> - %s</li>', esc_html__( 'by Sold Individually status (Custom Field)', 'searchfiltersort' ) );
                    printf( '<li><code>_stock</code> - %s</li>', esc_html__( 'by Stock Quantity (Custom Field Numeric)', 'searchfiltersort' ) );
                    printf( '<li><code>_virtual</code> - %s</li>', esc_html__( 'by Product Virtual status (Custom Field)', 'searchfiltersort' ) );
                    printf( '<li><code>_length</code> - %s</li>', esc_html__( 'by product Length', 'searchfiltersort' ) );
                    printf( '<li><code>_width</code> - %s</li>', esc_html__( 'by product Width', 'searchfiltersort' ) );
                    printf( '<li><code>_height</code> - %s</li>', esc_html__( 'by product Height', 'searchfiltersort' ) );
                    printf( '<li><code>_weight</code> - %s</li>', esc_html__( 'by product Weight', 'searchfiltersort' ) );
                    ?>
                    <li><h4><?php esc_html_e( 'WordPress', 'searchfiltersort' ); ?>:</h4></li>
                    <?php
                    printf( '<li><code>_thumbnail_id</code> - %s</li>', esc_html__( 'filter by Featured Image (Custom Field Exists)', 'searchfiltersort' ) );
                    ?>
                </ul>
            </div>
        </li>
    </ul>
</div>