<?php

if ( ! defined('ABSPATH') ) {
    exit;
}

    $fields     = sfs_get_seo_rules_fields( $post->ID );
    $post_type  = sfs_extract_vars($fields, array('rule_post_type') );
    $postType   = reset( $post_type );
    $seo_fields = sfs_extract_vars( $fields, array( 'rule_seo_title', 'rule_meta_desc', 'rule_h1', 'rule_description') );
?>

<div class="sfswp-filters-seo-rules-wrapper">
    <div class="sfswp-sfs-set-hidden-fields">
        <input type="hidden" id="sfswp_seo_rule_nonce" name="_sfs_nonce" value="<?php echo esc_attr( sfs_create_seo_rules_nonce() ); ?>" />
    </div>
    <div class="sfswp-column-labels-wrapper">
        <table class="sfswp-form-fields-table">
            <tr id="sfswp-rule-post-type">
                <td class="sfswp-filter-label-td">
                    <label for="<?php echo esc_attr( $postType['id'] ); ?>" class="sfswp-filter-label">
                        <?php esc_html_e('Post Type', 'searchfiltersort'); ?>
                    </label>
                    <p class="sfswp-field-description"><?php esc_html_e('Select Post Type for SEO Rule', 'searchfiltersort'); ?></p>
                </td>
                <td class="sfswp-sfs-field-td">
                    <?php echo sfs_render_input( $postType ); //Safe, escaped inside ?>
                </td>
            </tr>
            <tr class="sfswp-filter-intersection-tr">
                <td class="sfswp-filter-label-td">
                    <label class="sfswp-filter-label">
                        <?php esc_html_e('Filters Combination', 'searchfiltersort'); ?>
                    </label>
                    <p class="sfswp-field-description"><?php esc_html_e('Specify the filter or filters combination for which you need to set SEO data', 'searchfiltersort'); ?></p>
                    <?php echo sfs_help_tip(
                            wp_kses(
                                    __('For example, you need to set SEO data for the page with URL path:<br />/color-blue/size-large/<br />For this purpose, you have to select filters «Color» and «Size» only.<br />If you want to create a common template for all color and size values, please choose <br />«Any Color» and «Any Size». If you need to set SEO data for specific Color and Size, please choose specific values like «Blue» and «Large».', 'searchfiltersort'),
                                    array('br' => array() )
                            ), true ); ?>
                </td>
                <td class="sfswp-sfs-field-td">
                    <div class="sfswp-intersection-fields-wrapper" id="sfswp-intersection-fields-container">
                        <span class="spinner"></span>
                        <?php
                            sfs_include_admin_view('filters-intersections', array(
                                    'fields'  => $fields
                                )
                            );
                        ?>
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <hr />
                </td>
            </tr>
            <?php foreach ( $seo_fields as $key => $attributes ): ?>
                <tr class="sfswp-filter-tr <?php echo esc_attr( $attributes['class'] ); ?>-tr">
                    <td class="sfswp-filter-label-td">
                        <label for="<?php echo esc_attr( $attributes['id'] ); ?>" class="sfswp-filter-label">
                            <?php echo esc_html( $attributes['label'] ); ?>
                        </label>
                        <?php echo sfs_field_instructions($attributes); // Already escaped in function ?>
                        <?php echo sfs_tooltip($attributes); ?>
                    </td>
                    <td class="sfswp-sfs-field-td">
                        <div class="sfswp-field-wrap <?php echo esc_attr( $attributes['id'] ); ?>-wrap">
                            <?php echo sfs_render_input( $attributes ); ?>
                        </div>
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>
    </div>
</div>