<?php

if ( ! defined('ABSPATH') ) {
    exit;
}

$css_class    = 'sfswp-filter-item sfswp-filter-not-listed sfswp-filter-item-search-field sfswp-filter-' . $search_field_order['value'];
$css_class    .= ( isset( $use_search_field['value'] ) && $use_search_field['value'] === 'yes' ) ? ' sfswp-opened' : '';
$search_text  = ( isset( $search_field_placeholder['value'] ) ) ? $search_field_placeholder['value'] : esc_html__('Search ...', 'searchfiltersort' );
$search_label = ( isset( $search_field_label['value'] ) ) ? $search_field_label['value'] : esc_html__('Search', 'searchfiltersort' );

?>
<div id="sfswp-filter-id-search-field" class="<?php echo esc_attr( $css_class ); ?>" data-fid="search-field">
    <div class="sfswp-filter-head">
        <div class="sfswp-filter-title ui-sortable-handle">
            <ul class="sfswp-custom-row sfswp-filter-item-labels">
                <li class="sfswp-filter-order" title="<?php echo $search_field_order['value']; ?>"><span class="sfswp-filter-sortable-handle dashicons dashicons-menu"></span></li>
                <li class="sfswp-filter-label"><?php echo $search_label; ?></li>
                <li class="sfswp-filter-entity"><input type="text" class="sfswp-text-input-style sfswp-text-input-search" placeholder="<?php echo $search_text; ?>" readonly="readonly" /></li>
                <li class="sfswp-filter-view">&nbsp;</li>
                <li class="sfswp-filter-slug">&nbsp;</li>
            </ul>
        </div>
    </div>
    <div class="sfswp-filter-body">
        <div class="sfswp-filter-main-fields">
            <table class="sfswp-form-fields-table sfswp-filter-search-field">
                <tr class="sfswp-filter-tr">
                    <td colspan="2">
                        <?php echo sfs_render_input( $search_field_order ); ?>
                    </td>
                </tr>
            </table>
        </div>
    </div>
</div>