<?php

if ( ! defined('ABSPATH') ) {
    exit;
}

$filterID           = isset( $filter['ID']['value'] ) ? $filter['ID']['value'] : 0;
$belongs_class      = ( $filter['entity']['entity_belongs'] ) ? 'sfswp-belongs ' : 'sfswp-belongs-not ';
$short_entity       = $filter['entity']['short_entity'];
$rowClass           = ( $filterID === \SearchFilterSort\Filter\SFSFields::SFS_NEW_FILTER_ID ) ? 'sfswp-filter-item sfswp-new-filter-item' : 'sfswp-filter-item';
?>
<div id="<?php echo esc_attr('sfswp-filter-id-' . $filterID); ?>" class="sfswp-filter-<?php echo esc_attr($filter['menu_order']['value']); ?> <?php echo esc_attr($belongs_class); ?><?php echo esc_attr($rowClass); ?>" data-fid="<?php echo esc_attr($filterID); ?>">
    <div class="sfswp-filter-head">
        <div class="sfswp-title-action widget-title-action">
            <button type="button" class="sfswp-action widget-action hide-if-no-js" aria-expanded="false">
                <span class="toggle-indicator" aria-hidden="true"></span>
            </button>
        </div>
        <div class="sfswp-filter-title ui-sortable-handle">
            <ul class="sfswp-custom-row sfswp-filter-item-labels">
                <li class="sfswp-filter-order" title="<?php echo $filter['menu_order']['value']; ?>"><span class="sfswp-filter-sortable-handle dashicons dashicons-menu"></span></li>
                <li class="sfswp-filter-label"><?php echo esc_html($filter['label']['value']); ?></li>
                <li class="sfswp-filter-entity"><?php
                    echo sfs_get_filter_entity_name( $filter['entity']['value'] ); // Already escaped in function
                    if( ! $filter['entity']['entity_belongs'] && ! in_array( $filter['entity']['value'], [ 'tax_numeric', 'post_meta_exists' ] ) ){
                        echo ' ' . sfs_help_tip( esc_html__('This filter is inactive because it is not related to the selected post type.', 'searchfiltersort'), $allow_html = false );
                    }
                    ?></li>
                <li class="sfswp-filter-view"><?php echo sfs_get_filter_view_name( $filter['view']['value'] ); // Already escaped in function ?></li>
                <li class="sfswp-filter-slug"><?php echo esc_html( $filter['slug']['value'] ); ?></li>
            </ul>
        </div>
    </div>
    <div class="sfswp-filter-body">
        <div class="sfswp-additional-fields-selector"><a href="javascript:void(0);" class="sfswp-more-options-toggle button"><?php esc_html_e('More options', 'searchfiltersort'); ?></a></div>
        <div class="sfswp-filter-main-fields">
            <table class="sfswp-form-fields-table sfswp-filter-<?php echo esc_attr($short_entity); ?>">
                <tr class="sfswp-filter-tr">
                    <td colspan="2">
                        <?php
                            $meta = sfs_extract_vars( $filter, array( 'ID', 'parent', 'menu_order' ) );
                            $_meta = $meta;
                            foreach ( $meta as $field_attributes ) {
                                echo sfs_render_input( $field_attributes ); // Safe, escaped
                            }
                        ?>
                    </td>
                </tr>
                <?php

                    $first_filters = sfs_extract_vars($filter, array( 'entity', 'instead-entity', 'e_name', 'label', 'slug', 'view', 'date_type', 'show_term_names', 'selected_and_above' ) );

                    foreach( $first_filters as $field_key => $field_attributes ){

                        if( isset( $field_attributes['skip_view'] ) && $field_attributes['skip_view'] ){
                            do_action_ref_array( 'sfswp_cycle_filter_fields', array( &$first_filters, $field_key ) );
                        } else {
                            sfs_include_admin_view('sfs-field', array(
                                    'field_key' => $field_key,
                                    'attributes' => $field_attributes
                                )
                            );
                        }
                    }
                ?>
            </table>
            </div>

            <div class="sfswp-filter-additional-fields">
                <table class="sfswp-form-fields-table sfswp-filter-<?php echo esc_attr($short_entity); ?>">
                <?php

                    foreach( $filter as $field_key => $field_attributes ) {

                        if( isset( $field_attributes['skip_view'] ) && $field_attributes['skip_view'] ) {
                            do_action_ref_array( 'sfswp_cycle_filter_fields', array( &$filter, $field_key ) );
                        } else {
                            sfs_include_admin_view('sfs-field', array(
                                    'field_key' => $field_key,
                                    'attributes' => $field_attributes
                                )
                            );
                        }
                    }

                ?>
                </table>
            </div>
        <div class="sfswp-remove-filter-wrapper">
            <table class="sfswp-form-fields-table">
                <tr class="sfswp-filter-tr">
                    <td class="sfswp-filter-label-td sfswp-filter-delete-controls-td">
                        <div class="alignleft">
                            <span class="widget-control-close-wrapper"><button type="button" class="button-link sfswp-done-action"><?php esc_html_e('Close', 'searchfiltersort'); ?></button> |
                                <button type="button" class="button-link button-link-delete sfswp-button-link-delete"><?php esc_html_e('Delete', 'searchfiltersort'); ?></button>
                            </span>
                        </div>
                        <br class="clear" />
                    </td>
                    <td class="sfswp-sfs-field-td sfswp-filter-delete-td">
                        <div class="alignright sfswp-filter-delete-wrapper" id="sfswp-filter-delete-wrapper-<?php echo esc_attr( $_meta['ID']['value'] ); ?>">
                            <span class="spinner"></span>
                            <input type="button" class="button sfswp-filter-delete" data-fid="<?php echo esc_attr( $_meta['ID']['value'] ); ?>" value="<?php echo esc_attr( __('Delete, I\'m sure', 'searchfiltersort') ); ?>">
                            <input type="button" class="button right sfswp-filter-delete-cancel" value="<?php echo esc_attr( __('Cancel', 'searchfiltersort') ); ?>">
                        </div>
                        <br class="clear" />
                    </td>
                </tr>
            </table>
        </div>
    </div>
</div>