<?php

if ( ! defined('ABSPATH') ) {
    exit;
}

$active_tab = '';

$page = 'edit.php?post_type=' . SFS_FILTERS_SET_POST_TYPE;

if ( isset($_GET['page']) && $_GET['page'] === 'sfs-settings' ) {
    // Settings page: edit.php?post_type=sfs-set&page=sfs-settings.
    $active_tab = 'sfs-settings';
} elseif ( isset($_GET['page']) && $_GET['page'] === 'sfs-dashboard' ) {
    // Dashboard page: edit.php?post_type=sfs-set&page=sfs-dashboard.
    $active_tab = 'sfs-dashboard';
} elseif ( isset($_GET['page']) && $_GET['page'] === 'sfs-freevspro' ) {
    // Dashboard page: edit.php?post_type=sfs-set&page=sfs-dashboard.
    $active_tab = 'sfs-freevspro';
} else{
    $active_tab = 'sfs-set';
}

/**
 * Get changelog.
 *
 * @param string $plugin_path plugin path.
 */
function sfs_get_plugin_changelog( $plugin_path ) {
    // Path to the readme.txt file.
    $readme_file = $plugin_path . '/readme.txt';

    // Check if the file exists.
    if ( ! file_exists( $readme_file ) ) {
        return '';
    }

    // phpcs:ignore
    $content = file_get_contents ( $readme_file ); // Read the file content.

    if ( ! $content || is_wp_error( $content ) ) {
        return '';
    }

    // Regular expression to extract the Changelog section.
    $pattern = '/==\s*Changelog\s*==\s*(.*?)(==|$)/is';

    // Match the pattern.
    if ( preg_match( $pattern, $content, $matches ) ) {
        // Extracted Changelog section.
        $changelog_content = trim( $matches[1] );

        // Regular expression to parse individual versions.
        $version_pattern = '/=+\s*(\d+\.\d+(\.\d+)?\s*(\(.+?\))?)\s*=+\s*(.*?)(?==+\s*\d+\.\d+(\.\d+)?\s*(\(.+?\))?\s*=+|$)/is';
        preg_match_all( $version_pattern, $changelog_content, $version_matches, PREG_SET_ORDER );

        $html_output = '';

        foreach ( $version_matches as $version_match ) {
            $version = $version_match[1];
            $changes = trim( $version_match[4] );

            // Convert changes to list items.
            $change_items = preg_split( '/\r\n|\r|\n/', $changes );
            $change_items = array_filter( array_map( 'trim', $change_items ) );

            $html_output .= "<h5><strong>Version $version</strong></h5>\n<ol>\n";

            foreach ( $change_items as $item ) {
                // Remove leading '*' and trim the item.
                $item = ltrim( $item, '* ' );
                if ( ! empty( $item ) ) {
                    $html_output .= '<li>' . htmlspecialchars( $item ) . "</li>\n";
                }
            }

            $html_output .= "</ol>\n<hr class=\"wp-block-separator has-css-opacity\">\n";
        }
        // Remove any unintended <br> tags.
        return str_replace( array( '<br>', '<br/>', '<br />' ), '', $html_output );
    } else {
        return '';
    }
}

/**
 * Check the install and activation status of a plugin in WordPress.
 *
 * @param string $plugin_slug Folder name of the plugin.
 * @param string $plugin_file Full plugin path relative to plugins directory, e.g., 'folder/plugin-file.php'.
 * @return array Returns an associative array with keys:
 *               - 'installed' => bool
 *               - 'active' => bool
 *               - 'network_active' => bool
**/
function check_plugin_install_and_activation_status($plugin_slug, $plugin_file) {
    // Ensure required plugin functions are available
    if ( ! function_exists( 'is_plugin_active' ) ) {
        include_once ABSPATH . 'wp-admin/includes/plugin.php';
    }

    // Full plugin path: e.g., wp-content/plugins/plugin-folder/plugin-file.php
    $plugin_path = WP_PLUGIN_DIR . '/' . $plugin_file;
    
    // Check if plugin file exists (i.e., plugin is installed)
    $is_installed = file_exists($plugin_path);

    // Check if plugin is active on the current site
    $is_active = is_plugin_active($plugin_file);

    // Check if plugin is network activated (in multisite)
    $is_network_active = is_multisite() && is_plugin_active_for_network($plugin_file);

    return [
        'installed'        => $is_installed,
        'active'           => $is_active,
        'network_active'   => $is_network_active,
    ];
}
?>
<div class="sfs-main-wrap">
    <div class="sfs-header-main">
        <div class="sfs_top_header"> <!-- ONLY this will be hidden -->
                <div class="wpssw_top_header_content_wrapper">
                    <p class="sfs_top_header_text">
                        You're using our free version. To unlock more features,
                        <a href="<?php echo SFS_BUY_PRO_VERSION_URL;  ?>" target="_blank">upgrade to pro →</a>
                    </p>
                </div>
                <button class="sfs_close_btn" onclick="wc_closeTopHeader()">×</button>
            </div>
        <div class="container">
            <div class="sfs-header-section">
                <div class="sfs-header-left">
                    <div class="sfs-logo-section">
                        <img src="<?php echo esc_url( SFS_PLUGIN_DIR_URL . 'assets/img/sfs-logo.png?ver=' ); ?><?php echo esc_attr( SFS_PLUGIN_VER ); ?>">
                    </div>
                    <div class="sfs-nav-top">
                        <ul>
                            <li>
                                <a class="navtablinks sfs-nav-dashboard <?php if('sfs-dashboard' === $active_tab){ echo 'active'; } ?>" data-href="<?php echo $page; ?>&page=sfs-dashboard" href="javascript:void(0)" onclick="sfsNavTab(event, 'sfs-nav-dashboard')">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="19" viewBox="0 0 21 19" fill="none">
                                        <path d="M21.3316 11.8281L10.6923 3.5701L0.0529785 11.8281V8.46321L10.6923 0.203247L21.3316 8.46128V11.8281ZM18.6717 11.5283V19.5087H13.3521V14.1891H8.03245V19.5087H2.7128V11.5293L10.6923 5.54514L18.6717 11.5283Z" fill="#64748B"/>
                                    </svg>
                                    Dashboard 
                                </a>
                            </li>
                            <li>
                                <a class="navtablinks sfs-nav-sets <?php if('sfs-set' === $active_tab){ echo 'active'; } ?>" href="<?php echo $page; ?>">
                                    <svg width="26" height="22" viewBox="0 0 36 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M17.6827 0L0 18.1599L9.06548 26.9862L17.9317 17.9148L26.9972 26.7701L35.8425 17.6867L17.6827 0Z" fill="#64748B"/>
                                        <path d="M8.88525 9.03445L17.9727 17.8688" stroke="white"/>
                                        <path d="M17.8967 17.8552L26.7171 8.79671" stroke="white"/>
                                    </svg>

                                    SFS Sets
                                </a>
                            </li>
                            <li>
                                <a class="navtablinks sfs-nav-setting <?php if('sfs-settings' === $active_tab){ echo 'active'; } ?>" href="<?php echo $page; ?>&page=sfs-settings">
                                    <svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M7.46797 20L7.06797 16.8C6.8513 16.7167 6.64714 16.6167 6.45547 16.5C6.2638 16.3833 6.0763 16.2583 5.89297 16.125L2.91797 17.375L0.167969 12.625L2.74297 10.675C2.7263 10.5583 2.71797 10.4458 2.71797 10.3375V9.6625C2.71797 9.55417 2.7263 9.44167 2.74297 9.325L0.167969 7.375L2.91797 2.625L5.89297 3.875C6.0763 3.74167 6.26797 3.61667 6.46797 3.5C6.66797 3.38333 6.86797 3.28333 7.06797 3.2L7.46797 0H12.968L13.368 3.2C13.5846 3.28333 13.7888 3.38333 13.9805 3.5C14.1721 3.61667 14.3596 3.74167 14.543 3.875L17.518 2.625L20.268 7.375L17.693 9.325C17.7096 9.44167 17.718 9.55417 17.718 9.6625V10.3375C17.718 10.4458 17.7013 10.5583 17.668 10.675L20.243 12.625L17.493 17.375L14.543 16.125C14.3596 16.2583 14.168 16.3833 13.968 16.5C13.768 16.6167 13.568 16.7167 13.368 16.8L12.968 20H7.46797ZM10.268 13.5C11.2346 13.5 12.0596 13.1583 12.743 12.475C13.4263 11.7917 13.768 10.9667 13.768 10C13.768 9.03333 13.4263 8.20833 12.743 7.525C12.0596 6.84167 11.2346 6.5 10.268 6.5C9.28464 6.5 8.45547 6.84167 7.78047 7.525C7.10547 8.20833 6.76797 9.03333 6.76797 10C6.76797 10.9667 7.10547 11.7917 7.78047 12.475C8.45547 13.1583 9.28464 13.5 10.268 13.5Z" fill="#64748B"/>
                                    </svg>
                                    Settings
                                </a>
                            </li>
                            <li>
                                <a class="navtablinks sfs-nav-freevspro <?php if('sfs-freevspro' === $active_tab){ echo 'active'; } ?>" data-href="<?php echo $page; ?>&page=sfs-settings" href="javascript:void(0)" onclick="sfsNavTab(event, 'sfs-nav-freevspro')">
                                    <svg width="21" height="21" viewBox="0 0 24 24" fill="none" class="w-5 h-5">
                                        <path d="M3 16C3 14.8954 3.89543 14 5 14H8C9.10457 14 10 14.8954 10 16V19C10 20.1046 9.10457 21 8 21H5C3.89543 21 3 20.1046 3 19V16Z" stroke="#1e293b" stroke-width="1.4"></path><path d="M14 16C14 14.8954 14.8954 14 16 14H19C20.1046 14 21 14.8954 21 16V19C21 20.1046 20.1046 21 19 21H16C14.8954 21 14 20.1046 14 19V16Z" stroke="#1e293b" stroke-width="1.4"></path><path d="M3 5C3 3.89543 3.89543 3 5 3H8C9.10457 3 10 3.89543 10 5V8C10 9.10457 9.10457 10 8 10H5C3.89543 10 3 9.10457 3 8V5Z" stroke="#1e293b" stroke-width="1.4"></path><path d="M14 5C14 3.89543 14.8954 3 16 3H19C20.1046 3 21 3.89543 21 5V8C21 9.10457 20.1046 10 19 10H16C14.8954 10 14 9.10457 14 8V5Z" stroke="#1e293b" stroke-width="1.4"></path>
                                    </svg>
                                    Free vs Pro
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="sfs-header-right">
                    <ul class="sfs-header-links">
                        <li class="version"><span>V<?php echo esc_html( SFS_PLUGIN_VER ); ?></span></li>
                        <li id="sfsBtn">
                            <a target="_blank" href="https://searchfiltersort.com/blog">
                                <svg width="16" height="20" viewBox="0 0 15 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M4.61806 7.6H5.54167C5.78662 7.6 6.02155 7.49991 6.19476 7.32175C6.36797 7.14359 6.46528 6.90196 6.46528 6.65C6.46528 6.39804 6.36797 6.15641 6.19476 5.97825C6.02155 5.80009 5.78662 5.7 5.54167 5.7H4.61806C4.3731 5.7 4.13817 5.80009 3.96496 5.97825C3.79175 6.15641 3.69444 6.39804 3.69444 6.65C3.69444 6.90196 3.79175 7.14359 3.96496 7.32175C4.13817 7.49991 4.3731 7.6 4.61806 7.6ZM4.61806 9.5C4.3731 9.5 4.13817 9.60009 3.96496 9.77825C3.79175 9.95641 3.69444 10.198 3.69444 10.45C3.69444 10.702 3.79175 10.9436 3.96496 11.1218C4.13817 11.2999 4.3731 11.4 4.61806 11.4H10.1597C10.4047 11.4 10.6396 11.2999 10.8128 11.1218C10.986 10.9436 11.0833 10.702 11.0833 10.45C11.0833 10.198 10.986 9.95641 10.8128 9.77825C10.6396 9.60009 10.4047 9.5 10.1597 9.5H4.61806ZM14.7778 6.593C14.7682 6.50573 14.7496 6.41975 14.7224 6.3365V6.251C14.678 6.15332 14.6187 6.06353 14.5469 5.985L9.00521 0.285C8.92886 0.211105 8.84156 0.150177 8.7466 0.1045C8.71903 0.100472 8.69104 0.100472 8.66347 0.1045C8.56965 0.0491542 8.46603 0.013627 8.35868 0H2.77083C2.03596 0 1.33119 0.300267 0.811558 0.834746C0.291926 1.36922 0 2.09413 0 2.85V16.15C0 16.9059 0.291926 17.6308 0.811558 18.1653C1.33119 18.6997 2.03596 19 2.77083 19H12.0069C12.7418 19 13.4466 18.6997 13.9662 18.1653C14.4859 17.6308 14.7778 16.9059 14.7778 16.15V6.65C14.7778 6.65 14.7778 6.65 14.7778 6.593ZM9.23611 3.2395L11.6283 5.7H10.1597C9.91477 5.7 9.67984 5.59991 9.50663 5.42175C9.33342 5.24359 9.23611 5.00196 9.23611 4.75V3.2395ZM12.9306 16.15C12.9306 16.402 12.8332 16.6436 12.66 16.8218C12.4868 16.9999 12.2519 17.1 12.0069 17.1H2.77083C2.52588 17.1 2.29095 16.9999 2.11774 16.8218C1.94453 16.6436 1.84722 16.402 1.84722 16.15V2.85C1.84722 2.59804 1.94453 2.35641 2.11774 2.17825C2.29095 2.00009 2.52588 1.9 2.77083 1.9H7.38889V4.75C7.38889 5.50587 7.68081 6.23078 8.20045 6.76525C8.72008 7.29973 9.42485 7.6 10.1597 7.6H12.9306V16.15ZM10.1597 13.3H4.61806C4.3731 13.3 4.13817 13.4001 3.96496 13.5782C3.79175 13.7564 3.69444 13.998 3.69444 14.25C3.69444 14.502 3.79175 14.7436 3.96496 14.9218C4.13817 15.0999 4.3731 15.2 4.61806 15.2H10.1597C10.4047 15.2 10.6396 15.0999 10.8128 14.9218C10.986 14.7436 11.0833 14.502 11.0833 14.25C11.0833 13.998 10.986 13.7564 10.8128 13.5782C10.6396 13.4001 10.4047 13.3 10.1597 13.3Z" fill="#464D58"/>
                                </svg>
                                <span class="tooltip-text">Documentation</span>
                            </a>
                        </li>
                        <li>
                            <a target="_blank" href="https://searchfiltersort.com/blog">
                                <svg width="20" height="20" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M13.2708 2.87C13.5005 3.00037 13.7724 3.03464 14.0273 2.96532C14.2821 2.896 14.4992 2.72873 14.6311 2.5C14.7403 2.30736 14.9104 2.15639 15.1146 2.07078C15.3188 1.98517 15.5457 1.96975 15.7597 2.02694C15.9736 2.08414 16.1626 2.21071 16.2968 2.38681C16.4311 2.56291 16.5031 2.77858 16.5015 3C16.5015 3.26522 16.3961 3.51957 16.2086 3.70711C16.021 3.89464 15.7666 4 15.5013 4C15.236 4 14.9816 4.10536 14.794 4.29289C14.6065 4.48043 14.5011 4.73478 14.5011 5C14.5011 5.26522 14.6065 5.51957 14.794 5.70711C14.9816 5.89464 15.236 6 15.5013 6C16.0279 5.99966 16.5452 5.86075 17.0011 5.59723C17.4571 5.33371 17.8356 4.95486 18.0987 4.49875C18.3618 4.04264 18.5002 3.52533 18.5 2.9988C18.4998 2.47227 18.361 1.95507 18.0975 1.49917C17.834 1.04326 17.4552 0.664718 16.9991 0.401563C16.5429 0.138409 16.0255 -8.42941e-05 15.4989 3.84915e-08C14.9723 8.43711e-05 14.4549 0.138743 13.9989 0.402044C13.5428 0.665344 13.1641 1.04401 12.9008 1.5C12.8346 1.61413 12.7917 1.74022 12.7745 1.871C12.7574 2.00178 12.7662 2.13466 12.8006 2.262C12.835 2.38934 12.8943 2.50862 12.975 2.61297C13.0557 2.71732 13.1562 2.80467 13.2708 2.87ZM17.5717 10C17.3092 9.96593 17.0438 10.0373 16.8338 10.1985C16.6239 10.3597 16.4864 10.5976 16.4515 10.86C16.2416 12.5552 15.419 14.1151 14.1386 15.246C12.8583 16.3769 11.2085 17.0007 9.50006 17H3.90889L4.55903 16.35C4.74532 16.1626 4.84988 15.9092 4.84988 15.645C4.84988 15.3808 4.74532 15.1274 4.55903 14.94C3.58378 13.9611 2.92007 12.7156 2.65153 11.3603C2.38298 10.005 2.52159 8.60052 3.04992 7.32383C3.57824 6.04714 4.47263 4.95532 5.62044 4.18589C6.76825 3.41646 8.11813 3.00384 9.50006 3C9.76533 3 10.0197 2.89464 10.2073 2.70711C10.3949 2.51957 10.5003 2.26522 10.5003 2C10.5003 1.73478 10.3949 1.48043 10.2073 1.29289C10.0197 1.10536 9.76533 0.999999 9.50006 0.999999C7.80894 1.00705 6.15401 1.49024 4.72486 2.39419C3.29571 3.29815 2.15016 4.58632 1.41944 6.11112C0.688721 7.63592 0.40239 9.33568 0.593251 11.0157C0.784113 12.6956 1.44445 14.2879 2.4986 15.61L0.788246 17.29C0.64946 17.4306 0.555444 17.6092 0.518062 17.8032C0.48068 17.9972 0.501607 18.1979 0.578203 18.38C0.653238 18.5626 0.780663 18.7189 0.944417 18.8293C1.10817 18.9396 1.30093 18.999 1.49839 19H9.50006C11.692 19.0003 13.8087 18.201 15.4531 16.7521C17.0975 15.3031 18.1567 13.3041 18.4319 11.13C18.4502 10.9993 18.4424 10.8662 18.409 10.7385C18.3756 10.6107 18.3172 10.4909 18.2373 10.3858C18.1573 10.2808 18.0573 10.1926 17.9431 10.1264C17.8289 10.0602 17.7026 10.0172 17.5717 10ZM15.8814 7.07C15.6993 6.98945 15.4973 6.96508 15.3013 7L15.1212 7.06L14.9412 7.15L14.7912 7.28C14.7012 7.37215 14.6299 7.48081 14.5811 7.6C14.522 7.72473 14.4945 7.86212 14.5011 8C14.4982 8.13337 14.522 8.26597 14.5711 8.39C14.6228 8.51002 14.6976 8.61873 14.7912 8.71C14.8846 8.80268 14.9955 8.87601 15.1173 8.92577C15.2392 8.97553 15.3697 9.00076 15.5013 9C15.7666 9 16.021 8.89464 16.2086 8.70711C16.3961 8.51957 16.5015 8.26522 16.5015 8C16.5049 7.86882 16.4775 7.73868 16.4215 7.62C16.314 7.37971 16.1217 7.18745 15.8814 7.08V7.07Z" fill="#464D58"/>
                                </svg>
                                <span class="tooltip-text">Support</span>
                            </a>
                        </li>
                        <li>
                            <a class="whatsNew-toggle" href="#">
                                <svg width="17" height="18" viewBox="0 0 17 18" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M15.6111 1.5157e-07C15.4944 -6.7285e-05 15.3787 0.0231658 15.2709 0.0683712C15.163 0.113577 15.065 0.179867 14.9824 0.263454C14.8999 0.34704 14.8344 0.446282 14.7897 0.555505C14.7451 0.664729 14.7222 0.781791 14.7222 0.9V1.47305C13.9725 2.41418 13.025 3.17422 11.9487 3.69785C10.8723 4.22147 9.69415 4.4955 8.5 4.5H3.16667C2.45966 4.50078 1.78183 4.7855 1.2819 5.29167C0.781971 5.79785 0.500772 6.48415 0.5 7.2V9C0.500772 9.71584 0.781971 10.4021 1.2819 10.9083C1.78183 11.4145 2.45966 11.6992 3.16667 11.7H3.5967L1.46094 16.7458C1.4029 16.8826 1.37934 17.0319 1.39237 17.1803C1.40539 17.3286 1.45461 17.4714 1.53558 17.5957C1.61656 17.7201 1.72677 17.8221 1.85631 17.8927C1.98585 17.9632 2.13068 18.0001 2.27778 18H5.83333C6.00734 18.0001 6.17753 17.9484 6.32276 17.8514C6.46799 17.7543 6.58185 17.6162 6.65018 17.4542L9.07129 11.7342C10.1652 11.8155 11.231 12.123 12.203 12.6377C13.1749 13.1524 14.0323 13.8634 14.7222 14.7268V15.3C14.7222 15.5387 14.8159 15.7676 14.9826 15.9364C15.1493 16.1052 15.3754 16.2 15.6111 16.2C15.8469 16.2 16.073 16.1052 16.2396 15.9364C16.4063 15.7676 16.5 15.5387 16.5 15.3V0.9C16.5001 0.781791 16.4771 0.664728 16.4325 0.555504C16.3878 0.44628 16.3224 0.347037 16.2398 0.263451C16.1572 0.179865 16.0592 0.113574 15.9514 0.0683688C15.8435 0.0231639 15.7279 -6.84694e-05 15.6111 1.5157e-07ZM3.16667 9.9C2.93097 9.89984 2.70497 9.80497 2.5383 9.63622C2.37164 9.46747 2.27794 9.23864 2.27778 9V7.2C2.27794 6.96135 2.37164 6.73253 2.5383 6.56378C2.70497 6.39504 2.93097 6.30016 3.16667 6.3H4.05556V9.9H3.16667ZM5.2474 16.2H3.62587L5.53038 11.7H7.15191L5.2474 16.2ZM14.7222 12.1696C12.9696 10.7077 10.7708 9.90565 8.5 9.89995H5.83333V6.29995H8.5C10.7709 6.29408 12.9696 5.4919 14.7222 4.02985V12.1696Z" fill="#464D58"/>
                                </svg>
                                <span class="tooltip-text">Change Log</span>
                            </a>
                        </li>
                    </ul>
                    <div class="whatsNew-block">
                        <div class="block-header">
                            <h3>Change Log</h3>
                            <button type="button" class="close-block">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" aria-hidden="true" class="h-6 w-6"><path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"></path></svg>
                            </button>
                        </div>  
                        <div class="sfs-block-content changeLog-conntent">
                            <?php
                                    $changelog = sfs_get_plugin_changelog( SFS_PLUGIN_DIR_PATH );
                                    // phpcs:ignore
                                    echo nl2br( $changelog );

                                    ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="sfs-tabs-main" >

    <!-- DashBoard html start   -->
    <div id="sfs-nav-dashboard" class="navtabcontent vertical-tabs">
        <div class="sfs-navtabcontent-dashboard">
            <div class="sfs-dashboard-container sfs-dashboard-top-container">

                <!-- Welcome html start -->
                <div class="sfs-dashboard-left-content">
                    <div class="sfs-dashboard-navtabcontent">
                        <!-- Header Section -->
                        <div class="welcome-searchfiltersort-section">
                            <div class="welcome-data">
                                <div class="welcome-title">
                                    <span>Welcome To SearchFilterSort</span>
                                </div>
                                <p>
                                    Find Anything in Seconds — With Search, Filter, and Sort That Just Works. Give your users a faster, smarter way to explore your WordPress or WooCommerce site. Create intuitive product filters, keyword search, and fully AJAX-powered sorting to help shoppers find the right products in seconds.
                                </p>
                            </div>
                            <div class="unlock-pro-button-section">
                                <a class="underline" href="edit.php?post_type=sfs-set">
                                    Let's Start
                                </a>
                            </div>  
                        </div>
                    </div>
                </div>

                <!-- Import Export plugin -->
                <div class="sfs-dashboard-right-content">
                    <div class="sfs-setup-guide-navtabcontent">
                        <!-- Header Section -->
                        <div class="setup-guide-section">
                            <div class="setup-guide-data">
                                <div class="setup-guide-title">
                                    <span>Set up Guide</span>
                                </div>
                                <p>
                                    Use SearchFilterSort to add powerful filtering and sorting to posts, products, listings, or any custom content—helping users find what they need faster.
                                </p>
                            </div>
                            <div class="setup-content-data">
                                <div class="setup-row">
                                    <div class="google-api-setting-guide">
                                        <h1>Getting Started</h1>
                                        <ul>
                                            <li><a href="https://www.searchfiltersort.com/how-to-add-a-search-filter-to-your-wordpress-site/" target="_blank">How to Add a Search Filter to Your WordPress Site?</a></li>
                                            <li><a href="https://www.searchfiltersort.com/how-to-use-filters-to-organize-your-blog-posts/" target="_blank">How to Use Filters to Organize Your Blog Posts?</a></li>
                                            <li><a href="https://www.searchfiltersort.com/optimize-woocommerce-store-with-advanced-search-filters/" target="_blank">How to Optimize Your WooCommerce Store with Advanced Search and Filters?</a></li>
                                            <li><a href="https://www.searchfiltersort.com/how-to-sort-woocommerce-products-by-price-or-rating/" target="_blank">How to Sort WooCommerce Products by Price or Rating?</a></li>
                                        </ul>
                                    </div>  
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="sfs-dashboard-container sfs-dashboard-bottom-container">
                <div class="sfs-dashboard-related-plugins">
                    <div class="sfs-import-export-plugins">
                        <h1 class="import-export-title">Check out our other WordPress plugins you might find useful.
</h1>
                        <div class="sfs-import-export-plugin-sections-div">
                            <!-- WooCommerce -->
                            <div class="import-export-plugin-section">
                                
                                <div class="import-export-plugin-info">
                                        <div class="import-export-feature-img">
                                            <img src="<?php echo esc_url( SFS_PLUGIN_DIR_URL . 'assets/img/woocommerce-icon.svg' ); ?>">
                                        </div>
                                        <div class="import-export-box-border">
                                            <div class="import-export-pro-content">
                                                <h1>WPSyncSheets For WooCommerce</h1>
                                            </div>
                                                <p class="text">Sync WooCommerce submissions with Google Sheets. Automate data management through real-time imports and exports.</p>
                                    
                                            <div class="import-export-button-section">                          
                                                <?php 
                                                $wpssw_plugin_slug = 'wpsyncsheets-woocommerce'; 
                                                $wpssw_plugin_file = 'wpsyncsheets-woocommerce/wpsyncsheets-lite-woocommerce.php';
                                                $wpssw_status = check_plugin_install_and_activation_status($wpssw_plugin_slug, $wpssw_plugin_file);
                                                ?>
                                                <?php wp_nonce_field( 'install_active', 'wpssw_api_dashboard' ); ?>
                                                <?php 
                                                if ( $wpssw_status['active'] || $wpssw_status['network_active'] ) {
                                                ?>
                                                <a class="activated" href="javascript:void(0)">
                                                    Activated
                                                </a>
                                                <?php } else if(! $wpssw_status['installed']) { ?>
                                                <a class="underline" href="javascript:void(0)" id="wpsswinstallactivebtn">
                                                    Install
                                                </a>
                                                <?php } else { ?>
                                                <a class="underline" href="javascript:void(0)" id="wpsswactivebtn">
                                                    Activate
                                                </a>
                                                <?php } ?>   
                                            </div>
                                        </div>
                                </div>
                            </div>

                            <!-- Elementor -->
                            <div class="import-export-plugin-section">
                                
                                <div class="import-export-plugin-info">
                                        <div class="import-export-box-border">
                                            <div class="import-export-pro-content">
                                                <h1>WPSyncSheets For Elementor</h1>
                                            </div>
                                                <p class="text">Sync Elementor Form submissions with Google Sheets. Automate data management through real-time exports.</p>
                                    
                                                            <div class="import-export-button-section">                          
                                                <?php 
                                                $wpsse_plugin_slug = 'wpsyncsheets-elementor'; 
                                                $wpsse_plugin_file = 'wpsyncsheets-elementor/wpsyncsheets-lite-elementor.php';
                                                $wpsse_status = check_plugin_install_and_activation_status($wpsse_plugin_slug, $wpsse_plugin_file);
                                                ?>
                                                <?php wp_nonce_field( 'install_active', 'wpsse_api_dashboard' ); ?>
                                                <?php 
                                                if ( $wpsse_status['active'] || $wpsse_status['network_active'] ) {
                                                ?>
                                                <a class="activated" href="javascript:void(0)">
                                                    Activated
                                                </a>
                                                <?php } else if(! $wpsse_status['installed']) { ?>
                                                <a class="underline" href="javascript:void(0)" id="wpsseinstallactivebtn">
                                                    Install
                                                </a>
                                                <?php } else { ?>
                                                <a class="underline" href="javascript:void(0)" id="wpsseactivebtn">
                                                    Activate
                                                </a>
                                                <?php } ?>   
                                            </div>
                                        </div>
                                        <div class="import-export-feature-img">
                                            <img src="<?php echo esc_url( SFS_PLUGIN_DIR_URL . 'assets/img/Elementor-icon.svg' ); ?>">
                                        </div>
                                </div>
                            </div>

                            <!-- Contact Form -->
                            <div class="import-export-plugin-section">
                                
                                <div class="import-export-plugin-info">
                                        <div class="import-export-feature-img">
                                            <img src="<?php echo esc_url( SFS_PLUGIN_DIR_URL . 'assets/img/ContactForm-icon.svg' ); ?>">
                                        </div>
                                        <div class="import-export-box-border">
                                            <div class="import-export-pro-content">
                                                <h1>WPSyncSheets For Contact Form 7</h1>
                                            </div>
                                                <p class="text">Sync Contact Form 7 submissions with Google Sheets. Automate data management through real-time exports.</p>
                                    
                                            <div class="import-export-button-section">                          
                                                <?php 
                                                $wpssc_plugin_slug = 'contactsheets-lite'; 
                                                $wpssc_plugin_file = 'contactsheets-lite/wpsyncsheets-lite-contact-form-7.php';
                                                $wpssc_status = check_plugin_install_and_activation_status($wpssc_plugin_slug, $wpssc_plugin_file);
                                                ?>
                                                <?php wp_nonce_field( 'install_active', 'wpssc_api_dashboard' ); ?>
                                                <?php 
                                                if ( $wpssc_status['active'] || $wpssc_status['network_active'] ) {
                                                ?>
                                                <a class="activated" href="javascript:void(0)">
                                                    Activated
                                                </a>
                                                <?php } else if(! $wpssc_status['installed']) { ?>
                                                <a class="underline" href="javascript:void(0)" id="wpsscinstallactivebtn">
                                                    Install
                                                </a>
                                                <?php } else { ?>
                                                <a class="underline" href="javascript:void(0)" id="wpsscactivebtn">
                                                    Activate
                                                </a>
                                                <?php } ?>   
                                            </div>
                                        </div>
                                </div>
                            </div>

                            <!-- Gravity Form -->   
                            <div class="import-export-plugin-section">      
                                <div class="import-export-plugin-info">    
                                        <div class="import-export-box-border">
                                            <div class="import-export-pro-content">
                                                <h1>WPSyncSheets For Gravity Forms</h1>
                                            </div>
                                                <p class="text">Sync Gravity Forms submissions with Google Sheets. Automate data management through real-time exports.</p>
                                    
                                            <div class="import-export-button-section">        
                                                <?php 
                                                $wpssg_plugin_slug = 'wpsyncsheets-gravity-forms'; 
                                                $wpssg_plugin_file = 'wpsyncsheets-gravity-forms/wpsyncsheets-lite-gravity-forms.php';
                                                $wpssg_status = check_plugin_install_and_activation_status($wpssg_plugin_slug, $wpssg_plugin_file);
                                                ?>
                                                <?php wp_nonce_field( 'install_active', 'wpssg_api_dashboard' ); ?>
                                                <?php 
                                                if ( $wpssg_status['active'] || $wpssg_status['network_active'] ) {
                                                ?>
                                                <a class="activated" href="javascript:void(0)">
                                                    Activated
                                                </a>
                                                <?php } else if(! $wpssg_status['installed']) { ?>
                                                <a class="underline" href="javascript:void(0)" id="wpssginstallactivebtn">
                                                    Install
                                                </a>
                                                <?php } else { ?>
                                                <a class="underline" href="javascript:void(0)" id="wpssgactivebtn">
                                                    Activate
                                                </a>
                                                <?php } ?> 
                                            </div>
                                        </div>
                                        <div class="import-export-feature-img">
                                            <img src="<?php echo esc_url( SFS_PLUGIN_DIR_URL . 'assets/img/GravityForms-icon.svg' ); ?>">
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Free Vs Pro html start   -->
    <div id="sfs-nav-freevspro" class="navtabcontent vertical-tabs">
        <div class="sfs-navtabcontent">
                <!-- Header Section -->
                <div class="free-pro-header">
                    <div class="free-pro-data">
                        <div class="free-pro-title">
                            <span>Free vs Pro</span>
                        </div>
                        <p>
                            Compare the features to find the best option for your website.
                        </p>
                    </div>
                    <div class="unlock-pro-button-section">
                        <a class="underline" href="<?php echo SFS_BUY_PRO_VERSION_URL;  ?>" target="_blank" rel="noreferrer">
                            Upgrade Now
                        </a>
                    </div>
                </div>

                <!-- General Settings -->
                <div class="pro-free-features">
                        <!-- Table Header Row -->
                        <div class="dynamic-content">
                            <p>General Features</p>
                            <div class="free-title">
                                <p>Free</p>
                                <p>Pro</p>
                            </div>
                        </div>

                        <!-- Feature: Automatically Create New Google Spreadsheet -->
                        <div class="feature-data">
                            <p>Filters any Post Type (posts, products, etc.)</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Automatcailly Create New Google Sheets based on the Order Status(s) -->
                        <div class="feature-data">
                            <p>Filtering by Taxonomies, Custom Fields, Post Author  </p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Download Excel & CSV -->
                        <div class="feature-data">
                            <p>Custom URL prefixes for filters      
</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Automatically Clear Google Spreadsheet -->
                        <div class="feature-data">
                            <p>Supports AJAX</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Freeze Headers (First Row of the Google Spreadsheet) -->
                        <div class="feature-data">
                            <p>Count, dynamic recount in terms</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: HPOS Compatibility -->
                        <div class="feature-data">
                            <p>Sorting widget</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>


                        <!-- Feature: Reorder Sheet Headers (Spreadsheet Columns) -->
                        <div class="feature-data">
                            <p>Color swatches and Brand logos</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Update Sheet Headers Name (Spreadsheet Columns) -->
                        <div class="feature-data">
                            <p>Search by keyword</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Schedule Auto Sync (Export) -->
                        <div class="feature-data">
                            <p>Vertical and Horizontal layouts</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Schedule Auto Import -->
                        <div class="feature-data">
                            <p>«Auto-submission» and «Apply button» modes</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <div class="feature-data">
                            <p>Step-by-Step filtering</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Graph Generation & Formatting -->
                        <div class="feature-data">
                            <p>Filtering Custom WP Queries</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Third‑Party & Multisite Compatibility -->
                        <div class="feature-data">
                            <p>Compatibility with Page builders</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <div class="feature-data">
                            <p>Clean URLs and Permalinks</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <div class="feature-data">
                            <p>Smart filtering by Woo product variations</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <div class="feature-data">
                            <p>SEO Rules, indexing filtering result pages by Search Engines</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <div class="feature-data">
                            <p>Individual Filter Sets for any pages and archives</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Add Custom Static Headers -->
                        <div class="feature-data">
                            <p>Special Pop-up Filters widget for Mobile Devices</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Row Background Color -->
                        <div class="feature-data">
                            <p>Individual AJAX containers for Filter Sets</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Row Input Format Option -->
                        <div class="feature-data">
                            <p>Hide filter if all terms are empty</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <!-- Feature: Date/Time Format Option -->
                        <div class="feature-data">
                            <p>Stars for Product rating filter</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>

                        <div class="feature-data">
                            <p>Premium support</p>
                                <div class="feature-icon">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#DC2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-x">
                                    <path d="M18 6 6 18"></path>
                                    <path d="m6 6 12 12"></path>
                                    </svg>

                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#16A34A" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check">
                                    <path d="M20 6 9 17l-5-5"></path>
                                    </svg>
                                </div>
                        </div>
                </div>
        </div>
    </div>

    <!-- Unlock Pro Features -->
    <div class="sfs-tabs-main sfs-pro-main">
        <div class="upgrade-pro-navtabcontent">
            <div class="sfs-navtabcontent">
                <div class="generalSetting-section">
                    <div class="box-border">
                        <div class="unlock-pro-content">
                            <div class="unlock-pro-title">
                                <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32" fill="none">
                                    <g clip-path="url(#clip0_1813_15)">
                                    <path d="M15.6678 5L1 20.0636L8.51983 27.3851L15.8744 19.8603L23.3942 27.2058L30.7314 19.6711L15.6678 5Z" fill="url(#paint0_linear_1813_15)"/>
                                    <path d="M8.37027 12.4941L15.9083 19.8222" stroke="#B1E6FF" stroke-width="0.0818091"/>
                                    <path d="M15.8455 19.8109L23.162 12.2969" stroke="#B1E6FF" stroke-width="0.0818091"/>
                                    <path d="M15.2579 14.8965C15.2128 14.8943 15.1703 14.8746 15.1394 14.8416C15.1085 14.8086 15.0918 14.7648 15.0927 14.7196L15.1307 13.062L13.5722 11.2663C13.512 11.1959 13.4728 11.11 13.459 11.0184C13.4463 10.9256 13.461 10.8311 13.5011 10.7465C13.5398 10.66 13.6033 10.5869 13.6837 10.5366C13.7636 10.4873 13.856 10.462 13.9498 10.4639L17.6378 10.5515C17.7314 10.5539 17.8222 10.5834 17.8993 10.6363C17.9765 10.6893 18.0366 10.7634 18.0725 10.8498C18.1086 10.9363 18.1187 11.0315 18.1016 11.1237C18.0844 11.2159 18.0407 11.3011 17.9758 11.3688L16.3363 13.0901L16.3132 14.0585C16.3123 14.0844 16.3058 14.1098 16.2942 14.1329C16.2827 14.156 16.266 14.1761 16.2454 14.1916L15.367 14.8609C15.3358 14.8849 15.2973 14.8974 15.2579 14.8965ZM13.9416 10.811C13.9147 10.8101 13.8883 10.8173 13.8655 10.8316C13.8426 10.8457 13.8243 10.8661 13.8126 10.8903C13.801 10.9144 13.797 10.9415 13.8011 10.968C13.8045 10.9946 13.8157 11.0196 13.8333 11.0399L15.4331 12.8893C15.4605 12.9209 15.4755 12.9614 15.4753 13.0033L15.443 14.3693L15.9703 13.9643L15.9926 13.0157C15.9935 12.9727 16.0106 12.9317 16.0405 12.9008L17.7263 11.1291C17.7435 11.1094 17.7552 11.0854 17.7601 11.0597C17.7646 11.0338 17.7615 11.0072 17.7512 10.9831C17.7409 10.9589 17.724 10.9382 17.7023 10.9234C17.6809 10.9083 17.6557 10.8997 17.6296 10.8986L13.9416 10.811Z" fill="white"/>
                                    <path d="M10.018 18.1391C10.0372 18.1205 10.0599 18.1059 10.0848 18.0961C10.1097 18.0863 10.1363 18.0815 10.163 18.0821C10.1898 18.0826 10.2161 18.0884 10.2406 18.0992C10.2651 18.11 10.2872 18.1255 10.3056 18.1449C10.4491 18.2944 10.5574 18.4741 10.6225 18.6708C10.6877 18.8675 10.7082 19.0763 10.6824 19.282C10.6765 19.332 10.6521 19.3781 10.6141 19.4113C10.5761 19.4444 10.5271 19.4622 10.4767 19.4613H10.456C10.4023 19.4549 10.3534 19.4274 10.3199 19.385C10.2865 19.3425 10.2712 19.2885 10.2775 19.2349C10.296 19.0893 10.2818 18.9414 10.2359 18.802C10.19 18.6627 10.1136 18.5353 10.0123 18.4292C9.99336 18.4099 9.97851 18.387 9.96856 18.3619C9.9586 18.3368 9.95376 18.3099 9.95429 18.2829C9.95483 18.2559 9.96075 18.2293 9.97169 18.2046C9.98264 18.1799 9.99839 18.1576 10.018 18.1391Z" fill="white"/>
                                    <path d="M9.23465 16.8705C9.69586 16.8793 10.1441 17.0246 10.5227 17.2882C10.9013 17.5517 11.1932 17.9216 11.3616 18.3511C11.5299 18.7806 11.5671 19.2503 11.4684 19.7009C11.3697 20.1516 11.1396 20.5628 10.8072 20.8826C10.4748 21.2024 10.055 21.4165 9.60088 21.4977C9.14679 21.5788 8.67882 21.5235 8.25617 21.3387C7.83352 21.1539 7.47516 20.8479 7.22644 20.4595C6.97772 20.071 6.84981 19.6174 6.85888 19.1562C6.87169 18.5384 7.12897 17.9508 7.57432 17.5223C8.01967 17.0939 8.61675 16.8595 9.23465 16.8705ZM9.15201 21.1246C9.53223 21.1319 9.90607 21.0263 10.2263 20.8211C10.5465 20.6159 10.7986 20.3204 10.9509 19.972C11.1032 19.6235 11.1487 19.2377 11.0817 18.8633C11.0147 18.489 10.8382 18.1429 10.5746 17.8689C10.3109 17.5948 9.97193 17.4051 9.60046 17.3237C9.22899 17.2423 8.84172 17.2728 8.48761 17.4115C8.13351 17.5502 7.82848 17.7908 7.61109 18.1028C7.39369 18.4148 7.2737 18.7843 7.26627 19.1645C7.25697 19.6743 7.4503 20.167 7.80382 20.5345C8.15735 20.902 8.64221 21.1142 9.15201 21.1246Z" fill="white"/>
                                    <path d="M6.0077 21.98L7.51744 20.5272C7.53652 20.5075 7.55937 20.4918 7.58464 20.4811C7.60991 20.4704 7.63708 20.4649 7.66452 20.465C7.69196 20.465 7.71911 20.4706 7.74435 20.4814C7.76959 20.4921 7.79239 20.5079 7.81141 20.5277C7.83042 20.5475 7.84524 20.5709 7.855 20.5965C7.86475 20.6222 7.86923 20.6495 7.86817 20.677C7.86711 20.7044 7.86053 20.7313 7.84883 20.7561C7.83713 20.7809 7.82054 20.8031 7.80006 20.8214L6.28866 22.2708C6.26938 22.2895 6.24662 22.3041 6.22166 22.3139C6.19671 22.3237 6.17006 22.3285 6.14325 22.328C6.11645 22.3274 6.09001 22.3216 6.06547 22.3108C6.04093 22.3 6.01877 22.2845 6.00026 22.2651C5.96384 22.2261 5.9442 22.1743 5.9456 22.121C5.94699 22.0676 5.96929 22.017 6.0077 21.98Z" fill="white"/>
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M23.2975 20.9098L24.2644 21.8791C24.2868 21.9015 24.3134 21.9193 24.3427 21.9314C24.3719 21.9436 24.4033 21.9498 24.435 21.9498C24.4667 21.9498 24.4981 21.9436 24.5274 21.9314C24.5566 21.9193 24.5832 21.9015 24.6057 21.8791L25.5725 20.9098C25.6167 20.8637 25.6414 20.8022 25.6414 20.7383C25.6414 20.6744 25.6167 20.613 25.5725 20.5669C25.5501 20.5443 25.5234 20.5264 25.4941 20.5142C25.4647 20.502 25.4332 20.4958 25.4014 20.4958C25.3696 20.4958 25.3382 20.502 25.3088 20.5142C25.2795 20.5264 25.2528 20.5443 25.2304 20.5669L24.6767 21.1222V17.83C24.6786 17.797 24.6738 17.7641 24.6625 17.7331C24.6513 17.7021 24.6338 17.6737 24.6111 17.6497C24.5885 17.6257 24.5612 17.6066 24.5309 17.5935C24.5006 17.5805 24.468 17.5737 24.435 17.5737C24.402 17.5737 24.3694 17.5805 24.3391 17.5935C24.3088 17.6066 24.2815 17.6257 24.2589 17.6497C24.2362 17.6737 24.2188 17.7021 24.2075 17.7331C24.1962 17.7641 24.1914 17.797 24.1933 17.83V21.1222L23.6396 20.5669C23.6172 20.5443 23.5906 20.5264 23.5612 20.5142C23.5319 20.502 23.5004 20.4958 23.4686 20.4958C23.4368 20.4958 23.4053 20.502 23.376 20.5142C23.3466 20.5264 23.32 20.5443 23.2975 20.5669C23.2533 20.613 23.2287 20.6744 23.2287 20.7383C23.2287 20.8022 23.2533 20.8637 23.2975 20.9098Z" fill="white"/>
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M22.0291 17.6581C21.9837 17.6128 21.9222 17.5874 21.8581 17.5874C21.7939 17.5874 21.7324 17.6128 21.687 17.6581L20.7202 18.6275C20.676 18.6736 20.6513 18.735 20.6513 18.7989C20.6513 18.8628 20.676 18.9242 20.7202 18.9704C20.7426 18.9929 20.7692 19.0108 20.7986 19.023C20.828 19.0352 20.8594 19.0415 20.8912 19.0415C20.923 19.0415 20.9545 19.0352 20.9838 19.023C21.0132 19.0108 21.0399 18.9929 21.0623 18.9704L21.6159 18.4151V21.7073C21.614 21.7402 21.6188 21.7732 21.6301 21.8042C21.6414 21.8352 21.6589 21.8635 21.6815 21.8875C21.7041 21.9115 21.7314 21.9307 21.7617 21.9437C21.792 21.9568 21.8247 21.9635 21.8576 21.9635C21.8906 21.9635 21.9233 21.9568 21.9536 21.9437C21.9838 21.9307 22.0111 21.9115 22.0338 21.8875C22.0564 21.8635 22.0739 21.8352 22.0852 21.8042C22.0965 21.7732 22.1013 21.7402 22.0994 21.7073V18.4151L22.6538 18.9704C22.6761 18.993 22.7027 19.011 22.732 19.0232C22.7613 19.0355 22.7927 19.0418 22.8245 19.0418C22.8562 19.0418 22.8877 19.0355 22.917 19.0232C22.9463 19.011 22.9728 18.993 22.9951 18.9704C23.0393 18.9242 23.064 18.8628 23.064 18.7989C23.064 18.735 23.0393 18.6736 22.9951 18.6275L22.0291 17.6581Z" fill="white"/>
                                    </g>
                                    <defs>
                                    <linearGradient id="paint0_linear_1813_15" x1="8.3339" y1="12.5165" x2="23.3678" y2="27.1851" gradientUnits="userSpaceOnUse">
                                    <stop stop-color="#14A9DF"/>
                                    <stop offset="1" stop-color="#13648A"/>
                                    </linearGradient>
                                    <clipPath id="clip0_1813_15">
                                    <rect width="29.7314" height="22.3926" fill="white" transform="translate(1 5)"/>
                                    </clipPath>
                                    </defs>
                                    </svg>
                                <span>Unlock Pro Features</span>
                            </div>
                            <h1>SearchFilterSort for WordPress & WooCommerce</h1>
                        </div>
                            <p class="text">Your All-in-One Solution for Advanced SearchFilterSort</p>
                    
                        <ul class="pro-features-content">
                            <li>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check text-brand-primary-600">
                                <path d="M20 6 9 17l-5-5"></path></svg><span>AJAX-Powered Filtering</span>
                            </li>
                            <li>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check text-brand-primary-600">
                                <path d="M20 6 9 17l-5-5"></path></svg><span>Unlimited Filters</span>
                            </li>
                            <li>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check text-brand-primary-600">
                                <path d="M20 6 9 17l-5-5"></path></svg><span>Native WordPress UI</span>
                            </li>
                            <li>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check text-brand-primary-600">
                                <path d="M20 6 9 17l-5-5"></path></svg><span>Theme-Friendly</span>
                            </li>
                            <li>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check text-brand-primary-600">
                                <path d="M20 6 9 17l-5-5"></path></svg><span>Smart Sorting</span>
                            </li>
                            <li>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check text-brand-primary-600">
                                <path d="M20 6 9 17l-5-5"></path></svg><span>Filter Any Post Type</span>
                            </li>
                            <li>
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="lucide lucide-check text-brand-primary-600">
                                <path d="M20 6 9 17l-5-5"></path></svg><span>And More…</span>
                            </li>
                        </ul>

                        <div class="unlock-pro-button-section">
                            <a class="underline" href="<?php echo SFS_BUY_PRO_VERSION_URL;  ?>" target="_blank" rel="noreferrer">
                                Upgrade Now
                            </a>
                            <a class="no-underline" href="javascript:void(0)" onclick="sfsNavTab(event, 'sfs-nav-freevspro')">
                                Free vs Pro
                            </a>
                        </div>
                    </div>

                    <div class="pro-feature-img">
                        <img src="<?php echo esc_url( SFS_PLUGIN_DIR_URL . 'assets/img/searchfiltersort-pro.png' ); ?>" />
                    </div>
                </div>  
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    function wc_closeTopHeader() {
    const header = document.querySelector('.sfs_top_header');
    if (header) {
        header.style.display = 'none';
    }
}
</script>
