<?php

namespace SearchFilterSort\Filter;

if ( ! defined('ABSPATH') ) {
    exit;
}

class SettingsTab extends BaseSettings
{
    protected $page = 'sfswp-filter-admin-settings';

    protected $group = 'sfs-settings';

    protected $optionName = 'sfswp_filter_settings';

    

    public function init()
    {
        add_action('admin_init', array($this, 'initSettings'));
    }

    public function initSettings()
    {
        register_setting($this->group, $this->optionName);
        /**
         * @see https://developer.wordpress.org/reference/functions/add_settings_field/
        */
        $defaultPostsContainer = sfs_default_posts_container();
        $defaultPrimaryColor   = sfs_default_theme_color();

        $settings = array(
            'mobile_devices' => array(
                'label'  => esc_html__('Mobile Devices', 'searchfiltersort'),
                'fields' => array(
                    'mobile_filter_settings' => array(
                        'type'  => 'select',
                        'title' => esc_html__('Filters widget on mobile should be', 'searchfiltersort'),
                        'options'       => array(
                            'nothing' => esc_html__('The same as on a desktop', 'searchfiltersort'),
                            'show_open_close_button' => esc_html__('Collapsed and expanded', 'searchfiltersort'),
                        ),
                        'default' => 'no',
                        'id'    => 'mobile_filter_settings',
                    ),
                    'try_move_to_top_sidebar' => array(
                        'type'  => 'checkbox',
                        'title' => esc_html__('Sidebar on top', 'searchfiltersort'),
                        'id'    => 'try_move_to_top_sidebar',
                        'label' => esc_html__('Try to move the sidebar to the top on mobile devices', 'searchfiltersort'),
                    )
                )
            ),
            'ajax' => array(
                'label'  => esc_html__('AJAX Settings', 'searchfiltersort'),
                'fields' => array(
                    'enable_ajax'     => array(
                        'type'  => 'checkbox',
                        'title' => esc_html__('AJAX for Filters', 'searchfiltersort'),
                        'id'    => 'enable_ajax',
                        'label' => esc_html__('Try to use AJAX', 'searchfiltersort'),
                        'description' => esc_html__( 'Please enable this option only after you have ensured that the filtering is working correctly', 'searchfiltersort' ),
                    ),
                    'posts_container' => array(
                        'type'      => 'text',
                        'title'     => esc_html__('HTML id or class of the Posts Container', 'searchfiltersort'),
                        'id'        => 'posts_container',
                        'default'   => $defaultPostsContainer,
                        'description' => esc_html__( 'e.g. #primary or .main-content', 'searchfiltersort' ),
                        'label'     => '',
                    )
                )
            ),
            'common_settings' => array(
                'label'  => esc_html__('Other Settings', 'searchfiltersort'),
                'fields' => array(
                    'primary_color' => array(
                        'type'    => 'text',
                        'title'   => esc_html__('Widget Primary Color', 'searchfiltersort'),
                        'id'      => 'sfswp_primary_color',
                        'default' => $defaultPrimaryColor,
                        'label'   => '',
                    ),
                    'container_height' => array(
                        'type'  => 'text',
                        'title' => esc_html__('Filter Container max height, px', 'searchfiltersort'),
                        'id'    => 'container_height',
                        'label' => '',
                    ),
                     'show_terms_in_content' => array(
                        'type'  => 'hidden',
                        'title' => '',
                        'id'    => '',
                        'label' => '',
                        'options' => array(),
                    ),
                    'widget_debug_messages' => array(
                        'type'  => 'checkbox',
                        'title' => esc_html__('Debug mode', 'searchfiltersort'),
                        'id'    => 'widget_debug_messages',
                        'label' => esc_html__('Enable debugging messages to help to configure filters', 'searchfiltersort'),
                    )
                )
            )
        );

        $settings = apply_filters('sfswp_general_filters_settings', $settings);

        $this->registerSettings($settings, $this->page, $this->optionName);
    }

    public function getLabel()
    {
        return esc_html__('General', 'searchfiltersort');
    }

    public function getName()
    {
        return 'settings';
    }

    public function valid()
    {
        return true;
    }
}

