<?php

namespace SearchFilterSort\Filter;

if ( ! defined('ABSPATH') ) {
    exit;
}

class ExperimentalTab extends BaseSettings
{
    protected $page = 'sfswp-filter-experimental-settings';

    protected $group = 'sfs-settings';

    protected $optionName = 'sfswp_filter_experimental';

    



    public function init()
    {
        add_action('admin_init', array($this, 'initSettings'));
    }

    public function initSettings()
    {
        register_setting($this->group, $this->optionName);
        $taxonomies            = EntityManager::getTaxonomies();
        $taxonomiesForSelect   = [];

        foreach( $taxonomies as $taxonomy ) {
            $taxonomiesForSelect[ $taxonomy->name ] = ucwords( sfs_ucfirst( mb_strtolower( $taxonomy->label ) ) );

            if ( $taxonomy->name === 'elementor_library_category' ) {
                $taxonomiesForSelect[ $taxonomy->name ] .= esc_html__( ' (Elementor Library)', 'searchfiltersort' );
            }
        }

        $settings = array(
            'ajax_settings' => array(
                    'label'  => esc_html__('AJAX Settings', 'searchfiltersort'),
                    'fields' => array(
                        'use_loader' => array(
                            'type'  => 'checkbox',
                            'title' => esc_html__('AJAX loading icon (on desktop only)', 'searchfiltersort'),
                            'id'    => 'use_loader',
                            'label' => esc_html__('Show icon', 'searchfiltersort'),
                        ),
                        'use_wait_cursor' => array(
                            'type'  => 'checkbox',
                            'title' => esc_html__('Wait Cursor (on desktop only)', 'searchfiltersort'),
                            'id'    => 'use_wait_cursor',
                            'label' => esc_html__('Use Wait Cursor for AJAX', 'searchfiltersort'),
                        ),
                        'dark_overlay' => array(
                            'type'  => 'checkbox',
                            'title' => esc_html__('Dark Overlay (on desktop only)', 'searchfiltersort'),
                            'id'    => 'dark_overlay',
                            'label' => esc_html__('Use a dark transparent overlay instead of white', 'searchfiltersort'),
                        ),
                        'auto_scroll' => array(
                            'type'  => 'checkbox',
                            'title' => esc_html__('Smart Auto Scroll (on desktop only)', 'searchfiltersort'),
                            'id'    => 'auto_scroll',
                            'label' => esc_html__('Automatically Scroll to the top of the posts grid', 'searchfiltersort'),
                        )
                    )
                ),
                'layout_settings' => array(
                    'label'  => esc_html__('Appearance Settings', 'searchfiltersort'),
                    'fields' => array(
                        'styled_inputs' => array(
                            'type'  => 'checkbox',
                            'title' => esc_html__('Styled checkboxes and radio buttons', 'searchfiltersort'),
                            'id'    => 'styled_inputs',
                            'label' => esc_html__('Enable styling', 'searchfiltersort'),
                        ),
                        'select2_dropdowns' => array(
                            'type'  => 'checkbox',
                            'title' => esc_html__('Improved dropdowns', 'searchfiltersort'),
                            'id'    => 'select2_dropdowns',
                            'label' => esc_html__('Use improved dropdowns instead of regular ones (jQuery plugin Select2)', 'searchfiltersort'),
                        ),
                    )
                )
        );

        if( sfs_is_woocommerce() ){
            $settings['woocommerce_settings'] = array(
                'label'  => esc_html__('WooCommerce', 'searchfiltersort'),
                'fields' => array(
                    'disable_woo_orderby' => array(
                        'type'  => 'checkbox',
                        'title' => esc_html__('Woocommerce Order By dropdown', 'searchfiltersort'),
                        'id'    => 'disable_woo_orderby',
                        'label' => esc_html__('Hide Woocommerce default sorting dropdown', 'searchfiltersort'),
                    ),
                )
            );

            if( defined('SFS_FILTERS_PRO') && SFS_FILTERS_PRO ){
                $settings['woocommerce_settings']['fields']['hide_out_of_stock'] = array(
                    'type'  => 'checkbox',
                    'title' => esc_html__('Out of stock visibility', 'searchfiltersort'),
                    'id'    => 'hide_out_of_stock',
                    'label' => esc_html__('Hide out of stock items from filtering results', 'searchfiltersort'),
                    'description'   => esc_html__( 'It also hides variable products if their variations are out of stock. Please do not use it together with the Filter by the Stock status!', 'searchfiltersort' ),
                );
            }
        }

        $settings['experimental_other'] = array(
            'label'  => esc_html__('Other Settings', 'searchfiltersort'),
            'fields' => array(
                'use_color_swatches' => array(
                    'type'  => 'checkbox',
                    'title' => esc_html__('Color swatches for Filters', 'searchfiltersort'),
                    'id'    => 'use_color_swatches',
                    'label' => esc_html__('Enable Color swatches', 'searchfiltersort'),
                ),
                'color_swatches_taxonomies' => array(
                    'type'  => 'select',
                    'class' => 'sfswp-color-swatches-taxonomies',
                    'title' => esc_html__('Taxonomies for Color swatches', 'searchfiltersort'),
                    'id'    => 'color_swatches_taxonomies',
                    'options' => $taxonomiesForSelect,
                    'multiple' => true,
                    'description' => esc_html__( 'Please specify taxonomies whose filters should display color swatches', 'searchfiltersort' )
                ),
                'rounded_swatches' => array(
                    'type'  => 'checkbox',
                    'class' => 'sfswp-color-swatches-taxonomies',
                    'title' => esc_html__('Rounded swatches', 'searchfiltersort'),
                    'id'    => 'rounded_swatches',
                    'label' => esc_html__('Make swatches rounded', 'searchfiltersort'),
                ),
            )
        );

        $settings = apply_filters('sfswp_experimental_filters_settings', $settings);

        $this->registerSettings($settings, $this->page, $this->optionName);
    }

    public function getLabel()
    {
        return esc_html__('Experimental', 'searchfiltersort');
    }

    public function getName()
    {
        return 'experimental';
    }

    public function valid()
    {
        return true;
    }
}