<?php

namespace SearchFilterSort\Filter;

if ( ! defined('ABSPATH') ) {
    exit;
}

class PostTypes
{
    public function __construct()
    {
        add_action( 'init', array( $this, 'registerPostType' ) );
    }

    function registerPostType() {
        // No need to escape
        register_post_type( SFS_FILTERS_SET_POST_TYPE, array(
            'label'    => esc_html__( 'SFS Sets', 'searchfiltersort' ),
            'labels'			=> array(
                'name'					=> esc_html__( 'SFS Sets', 'searchfiltersort' ),
                'singular_name'			=> esc_html__( 'SFS Set', 'searchfiltersort' ),
                'add_new'				=> esc_html__( 'Add SFS Set' , 'searchfiltersort' ),
                'add_new_item'			=> esc_html__( 'Add SFS Set' , 'searchfiltersort' ),
                'edit_item'				=> esc_html__( 'Edit SFS Set' , 'searchfiltersort' ),
                'new_item'				=> esc_html__( 'New SFS Set' , 'searchfiltersort' ),
                'view_item'				=> esc_html__( 'View SFS Set', 'searchfiltersort' ),
                'search_items'			=> esc_html__( 'Search SFS Sets', 'searchfiltersort' ),
                'not_found'				=> esc_html__( 'SFS Sets are Filters grouped together. Create your first SFS Set.', 'searchfiltersort' ),
                'not_found_in_trash'	=> esc_html__( 'No SFS Sets were found in Trash', 'searchfiltersort' ),
            ),
            'has_archive'       => false,
            'public'			=> false,
            'show_ui'			=> true,
            '_builtin'			=> false,
            'capability_type'	=> 'post',
            'hierarchical'		=> true,
            'rewrite'			=> false,
            'query_var'			=> false,
            'supports' 			=> array('title'),
            'show_in_menu'		=> false,
        ) );

        register_post_type(SFS_FILTERS_POST_TYPE, array(
            'labels'			=> array(
                'name'					=> esc_html__( 'SearchFilterSort', 'searchfiltersort' ),
                'singular_name'			=> esc_html__( 'Filter', 'searchfiltersort' ),
                'add_new'				=> esc_html__( 'Add New' , 'searchfiltersort' ),
                'add_new_item'			=> esc_html__( 'Add New Filter' , 'searchfiltersort' ),
                'edit_item'				=> esc_html__( 'Edit Filter' , 'searchfiltersort' ),
                'new_item'				=> esc_html__( 'New Filter' , 'searchfiltersort' ),
                'view_item'				=> esc_html__( 'View Filter', 'searchfiltersort' ),
                'search_items'			=> esc_html__( 'Search Filters', 'searchfiltersort' ),
                'not_found'				=> esc_html__( 'No Filters found', 'searchfiltersort' ),
                'not_found_in_trash'	=> esc_html__( 'No Filters were found in Trash', 'searchfiltersort' ),
            ),
            'public'			=> false,
            'show_ui'			=> false,
            '_builtin'			=> false,
            'capability_type'	=> 'post',
            'hierarchical'		=> true,
            'rewrite'			=> false,
            'query_var'			=> false,
            'supports' 			=> array('title'),
            'show_in_menu'		=> false,
        ) );
    }
}

new PostTypes();