<?php


namespace SearchFilterSort\Filter;

if ( ! defined('ABSPATH') ) {
    exit;
}

class MetaBoxes
{
    public function __construct()
    {
        add_action( 'admin_head', array( $this, 'adminHead' ) );
    }

    public function adminHead()
    {
        add_meta_box(
            'sfs-set-search',
            '<span class="sfs-metabox-title search-metabox-title">
                <svg width="27" height="27" viewBox="0 0 27 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M4.3396 21.0717L7.98809 17.4232C6.88235 15.9757 6.27591 14.22 6.27567 12.3672C6.27567 10.1346 7.14523 8.03534 8.72424 6.4566C10.303 4.87787 12.4019 4.0083 14.6349 4.0083C16.8676 4.0083 18.9668 4.87787 20.5455 6.4566C23.8046 9.71597 23.8046 15.0191 20.5455 18.2779C18.9668 19.8569 16.8676 20.7265 14.6349 20.7265C12.7822 20.7262 11.0264 20.1198 9.57891 19.014L5.93042 22.6625C5.71097 22.8823 5.42285 22.9921 5.13501 22.9921C4.84717 22.9921 4.55905 22.8823 4.3396 22.6625C3.90015 22.2234 3.90015 21.5109 4.3396 21.0717ZM18.9547 16.6871C21.3365 14.3052 21.3363 10.4295 18.9547 8.04742C17.8009 6.89386 16.2666 6.2583 14.6349 6.2583C13.0029 6.2583 11.4689 6.89386 10.3151 8.04742C9.16122 9.20126 8.52567 10.7355 8.52567 12.3672C8.52567 13.9993 9.16122 15.5332 10.3151 16.6871C11.4689 17.8409 13.0029 18.4765 14.6349 18.4765C16.2666 18.4765 17.8009 17.8409 18.9547 16.6871Z" fill="#1E293B"/>
                </svg>
                <span>' . esc_html__( 'Search Settings', 'searchfiltersort' ) . '</span>
            </span>',
            array( $this, 'searchMetabox' ),
            SFS_FILTERS_SET_POST_TYPE,
            'normal',
            'high'
        );

        add_meta_box(
            'sfs-set-items',
            '<span class="sfs-metabox-title filter-metabox-title">
                <svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M15.85 2.1748C16.2111 2.17509 16.565 2.28038 16.8676 2.47754C17.1701 2.67469 17.409 2.95594 17.5551 3.28613C17.701 3.61621 17.7484 3.9816 17.6908 4.33789C17.6332 4.6944 17.4726 5.02651 17.2299 5.29395L11.7777 11.29V14.5469C11.7777 14.6658 11.7511 14.7835 11.6996 14.8906C11.6481 14.9976 11.5735 15.0918 11.4809 15.166L8.51212 17.541C8.37145 17.6539 8.19636 17.7156 8.01602 17.7158C7.80558 17.7158 7.60334 17.6322 7.4545 17.4834C7.30564 17.3345 7.22208 17.1324 7.22208 16.9219V11.29L1.76993 5.29395C1.52724 5.02651 1.36757 4.6944 1.30997 4.33789C1.25239 3.98148 1.29967 3.61631 1.44571 3.28613C1.59182 2.95588 1.83065 2.6747 2.13321 2.47754C2.4357 2.28051 2.7888 2.17509 3.14981 2.1748H15.85ZM8.80899 15.2686L10.1908 14.1543V10.9844C10.1905 10.7865 10.2638 10.5957 10.3969 10.4492L16.0522 4.21777C16.0851 4.17811 16.1065 4.13021 16.1137 4.0791C16.121 4.02725 16.1136 3.97454 16.0922 3.92676C16.0707 3.87891 16.0363 3.83762 15.9926 3.80859C15.9708 3.79412 15.947 3.78318 15.9223 3.77539L15.8451 3.7627H3.15079L3.07169 3.77441C3.04626 3.782 3.02188 3.79299 2.99942 3.80762C2.9545 3.83695 2.91863 3.87869 2.89688 3.92773C2.87514 3.97687 2.86784 4.03191 2.87637 4.08496C2.88492 4.13775 2.90892 4.18685 2.94473 4.22656L8.60294 10.4609L8.68985 10.5752C8.76518 10.6962 8.80636 10.8362 8.80899 10.9805V15.2686Z" fill="#1E293B" stroke="#1E293B" stroke-width="0.4"/>
                </svg>
                <span>' . esc_html__( 'Filter Settings', 'searchfiltersort' ) . '</span>
            </span>',
            array( $this, 'filtersMetabox' ),
            SFS_FILTERS_SET_POST_TYPE,
            'normal',
            'high'
        );

        add_meta_box(
            'sfs-set-sort',
            '<span class="sfs-metabox-title sort-metabox-title">
                <svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M14.5482 18.1187L18.0482 21.6187C18.39 21.9604 18.9439 21.9604 19.2856 21.6187L22.7856 18.1187C23.1273 17.777 23.1273 17.223 22.7856 16.8813C22.4439 16.5396 21.89 16.5396 21.5482 16.8813L19.5419 18.8875V7C19.5419 6.51675 19.1502 6.125 18.6669 6.125C18.1837 6.125 17.7919 6.51675 17.7919 7V18.8875L15.7856 16.8813C15.4439 16.5396 14.89 16.5396 14.5482 16.8813C14.2065 17.223 14.2065 17.777 14.5482 18.1187ZM9.9523 6.38128C9.6106 6.03958 9.05657 6.03958 8.71487 6.38128L5.21487 9.88128C4.87316 10.223 4.87316 10.777 5.21487 11.1187C5.55657 11.4604 6.1106 11.4604 6.4523 11.1187L8.45858 9.11244V21C8.45858 21.4832 8.85034 21.875 9.33358 21.875C9.81683 21.875 10.2086 21.4832 10.2086 21V9.11244L12.2149 11.1187C12.5566 11.4604 13.1106 11.4604 13.4523 11.1187C13.794 10.777 13.794 10.223 13.4523 9.88128L9.9523 6.38128Z" fill="#1E293B"/>
                </svg>
                <span>' . esc_html__( 'Sort Settings', 'searchfiltersort' ) . '</span>
            </span>',
            array( $this, 'sortMetabox' ),
            SFS_FILTERS_SET_POST_TYPE,
            'normal',
            'high'
        );

        add_meta_box(
            'sfs-set-settings',
            '<span class="sfs-metabox-title settings-metabox-title">
                <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <g clip-path="url(#clip0_1849_1294)">
                    <path d="M19.1218 11.5896L18.2898 10.9047C17.7199 10.4355 17.7209 9.56352 18.2898 9.09527L19.1218 8.41035C19.7139 7.92289 19.8653 7.08703 19.4819 6.42277L17.839 3.57723C17.4555 2.91301 16.6557 2.62629 15.9377 2.89527L14.9285 3.27336C14.2373 3.53227 13.4826 3.09559 13.3614 2.36863L13.1843 1.30559C13.0582 0.549102 12.41 0 11.6431 0H8.35733C7.59034 0 6.94214 0.549102 6.81608 1.30562L6.6389 2.36863C6.51753 3.09687 5.76183 3.53184 5.07186 3.2734L4.06268 2.89527C3.3446 2.62629 2.54491 2.91305 2.16136 3.57723L0.518505 6.42273C0.135028 7.08691 0.286434 7.92281 0.878583 8.41031L1.71057 9.09523C2.28057 9.56445 2.27944 10.4364 1.71057 10.9047L0.878544 11.5896C0.286434 12.0771 0.134989 12.913 0.518465 13.5772L2.16136 16.4227C2.54487 17.0869 3.3444 17.3737 4.06268 17.1047L5.07183 16.7266C5.76319 16.4676 6.51772 16.9046 6.63886 17.6313L6.81604 18.6943C6.94214 19.4509 7.59034 20 8.35729 20H11.643C12.41 20 13.0582 19.4509 13.1842 18.6944L13.3614 17.6314C13.4827 16.9034 14.2384 16.4681 14.9285 16.7267L15.9377 17.1047C16.6559 17.3738 17.4555 17.087 17.839 16.4228L19.4819 13.5772C19.8653 12.913 19.7139 12.0771 19.1218 11.5896ZM16.4858 15.6415L15.4767 15.2634C13.8634 14.6591 12.1028 15.6787 11.8202 17.3745L11.6431 18.4375H8.35733L8.18015 17.3745C7.89698 15.6754 6.13382 14.6603 4.5237 15.2634L3.51452 15.6415L1.87167 12.796L2.70366 12.1111C4.0337 11.0161 4.03093 8.9816 2.70366 7.88895L1.87167 7.20402L3.51456 4.35848L4.5237 4.73656C6.13698 5.34086 7.89753 4.32133 8.18015 2.62551L8.35729 1.5625H11.643L11.8202 2.62551C12.1034 4.3248 13.8666 5.33961 15.4766 4.73656L16.4858 4.35848L18.1291 7.20363C18.1291 7.20363 18.1289 7.20375 18.1286 7.20398L17.2967 7.88891C15.9667 8.98375 15.9693 11.0183 17.2966 12.111L18.1287 12.7959L16.4858 15.6415ZM10.0002 6.14582C7.87499 6.14582 6.146 7.8748 6.146 10C6.146 12.1252 7.87499 13.8542 10.0002 13.8542C12.1254 13.8542 13.8544 12.1252 13.8544 10C13.8544 7.8748 12.1254 6.14582 10.0002 6.14582ZM10.0002 12.2917C8.73655 12.2917 7.7085 11.2636 7.7085 10C7.7085 8.73637 8.73655 7.70832 10.0002 7.70832C11.2638 7.70832 12.2919 8.73637 12.2919 10C12.2919 11.2636 11.2638 12.2917 10.0002 12.2917Z" fill="#1E293B"/>
                    </g>
                    <defs>
                    <clipPath id="clip0_1849_1294">
                    <rect width="20" height="20" fill="white"/>
                    </clipPath>
                    </defs>
                </svg>
                <span>' . esc_html__( 'Settings', 'searchfiltersort' ) . '</span>
            </span>',
            array( $this, 'settingsMetabox' ),
            SFS_FILTERS_SET_POST_TYPE,
            'normal',
            'high'
        );

        remove_meta_box(
            'submitdiv',
            array( SFS_FILTERS_SET_POST_TYPE ),
            'side'
        );

        add_meta_box(
            'submitdiv',
            esc_html__( 'Publish', 'searchfiltersort' ),
            [ 'SearchFilterSort\Filter\MetaBoxes', 'commonSideMetaBox' ],
            array( SFS_FILTERS_SET_POST_TYPE ),
            'side'
        );

        add_meta_box(
            'sfs-set-advice',
            esc_html__( 'How to use SFS?', 'searchfiltersort' ),
            [ 'SearchFilterSort\Filter\MetaBoxes', 'adviceMetabox' ],
            array( SFS_FILTERS_SET_POST_TYPE ),
            'side'
        );

    }

    public static function filtersMetabox( $post, $meta )
    {
        $args = array(
            'post'  => $post,
            'meta'  => $meta
        );

        sfs_include_admin_view('sfs-set', $args );

    }
    public static function searchMetabox( $post, $meta )
    {
        $args = array(
            'post'  => $post,
            'meta'  => $meta
        );

        sfs_include_admin_view('sfs-set-search', $args );

    }
    public static function sortMetabox( $post, $meta )
    {
        $args = array(
            'post'  => $post,
            'meta'  => $meta
        );

        sfs_include_admin_view('sfs-set-sort', $args );

    }

    public static function settingsMetabox( $post, $meta ){
        $args = array(
            'post'  => $post,
            'meta'  => $meta
        );

        sfs_include_admin_view('sfs-set-settings', $args );
    }

    public static function adviceMetabox( $post, $meta ){
        $args = array(
            'post'  => $post,
            'meta'  => $meta
        );

        sfs_include_admin_view('sfs-set-advices', $args );
    }

    public static function commonSideMetaBox( $post, $args = array() ) {
        global $action;

        $post_id          = (int) $post->ID;
        $post_type        = $post->post_type;
        $post_type_object = get_post_type_object( $post_type );
        $can_publish      = current_user_can( $post_type_object->cap->publish_posts );
        ?>
    <div class="submitbox" id="submitpost">

        <div id="minor-publishing">

        <?php // Hidden submit button early on so that the browser chooses the right button when form is submitted with Return key. ?>
        <div style="display:none;">
            <?php submit_button( esc_html__( 'Save' ), '', 'save' ); ?>
        </div>

        <div id="minor-publishing-actions">
<?php


    /**
     * Fires before the post time/date setting in the Publish meta box.
     *
     * @since 4.4.0
     *
     * @param WP_Post $post WP_Post object for the current post.
     */
    do_action( 'post_submitbox_minor_actions', $post );
?>
        <div class="clear"></div>
        </div>

        <div id="misc-publishing-actions">
            <div class="misc-pub-section misc-pub-post-status">
                <?php esc_html_e( 'Status:' ); ?>
                <span id="post-status-display">
                    <?php
                    switch ( $post->post_status ) {
                        case 'private':
                            esc_html_e( 'Privately Published' );
                            break;
                        case 'publish':
                            esc_html_e( 'Published' );
                            break;
                        case 'future':
                            esc_html_e( 'Scheduled' );
                            break;
                        case 'pending':
                            esc_html_e( 'Pending Review' );
                            break;
                        case 'draft':
                        case 'auto-draft':
                            esc_html_e( 'Draft' );
                            break;
                    }
                    ?>
                </span>
            </div>

            <?php
            /* translators: Publish box date string. 1: Date, 2: Time. See https://www.php.net/manual/datetime.format.php */
            $date_string = esc_html__( '%1$s at %2$s' );
            /* translators: Publish box date format, see https://www.php.net/manual/datetime.format.php */
            $date_format = _x( 'M j, Y', 'publish box date format' );
            /* translators: Publish box time format, see https://www.php.net/manual/datetime.format.php */
            $time_format = _x( 'H:i', 'publish box time format' );

            if ( 0 !== $post_id ) {
                if ( 'future' === $post->post_status ) { // Scheduled for publishing at a future date.
                    /* translators: Post date information. %s: Date on which the post is currently scheduled to be published. */
                    $stamp = esc_html__( 'Scheduled for: %s' );
                } elseif ( 'publish' === $post->post_status || 'private' === $post->post_status ) { // Already published.
                    /* translators: Post date information. %s: Date on which the post was published. */
                    $stamp = esc_html__( 'Published on: %s' );
                } elseif ( '0000-00-00 00:00:00' === $post->post_date_gmt ) { // Draft, 1 or more saves, no date specified.
                    $stamp = wp_kses( __( 'Publish <b>immediately</b>' ), array( 'b' => array() ) );
                } elseif ( time() < strtotime( $post->post_date_gmt . ' +0000' ) ) { // Draft, 1 or more saves, future date specified.
                    /* translators: Post date information. %s: Date on which the post is to be published. */
                    $stamp = esc_html__( 'Schedule for: %s' );
                } else { // Draft, 1 or more saves, date specified.
                    /* translators: Post date information. %s: Date on which the post is to be published. */
                    $stamp = esc_html__( 'Publish on: %s' );
                }
                $date = sprintf(
                    $date_string,
                    date_i18n( $date_format, strtotime( $post->post_date ) ),
                    date_i18n( $time_format, strtotime( $post->post_date ) )
                );
            } else { // Draft (no saves, and thus no date specified).
                $stamp = wp_kses( __( 'Publish <b>immediately</b>' ), array( 'b' => array() ) );
                $date  = sprintf(
                    $date_string,
                    date_i18n( $date_format, strtotime( current_time( 'mysql' ) ) ),
                    date_i18n( $time_format, strtotime( current_time( 'mysql' ) ) )
                );
            }

            if ( ! empty( $args['args']['revisions_count'] ) ) :
                ?>
                <div class="misc-pub-section misc-pub-revisions">
                    <?php
                    /* translators: Post revisions heading. %s: The number of available revisions. */
                    echo wp_kses(
                            sprintf(  __( 'Revisions: %s' ), '<b>' . number_format_i18n( $args['args']['revisions_count'] ) . '</b>' ),
                            array( 'b' => array() )
                        );
                    ?>
                    <a class="hide-if-no-js" href="<?php echo esc_url( get_edit_post_link( $args['args']['revision_id'] ) ); ?>"><span aria-hidden="true"><?php esc_html( _ex( 'Browse', 'revisions' ) ); ?></span> <span class="screen-reader-text"><?php esc_html_e( 'Browse revisions' ); ?></span></a>
                </div>
            <?php
            endif;

            if ( $can_publish ) : // Contributors don't get to choose the date of publish.
                ?>
                <div class="misc-pub-section curtime misc-pub-curtime">
                    <span id="timestamp">
                        <?php printf( $stamp, '<b>' . $date . '</b>' ); ?>
                    </span>
                </div>
            <?php
            endif;

            if ( 'draft' === $post->post_status && get_post_meta( $post_id, '_customize_changeset_uuid', true ) ) :
                ?>
                <div class="notice notice-info notice-alt inline">
                    <p>
                        <?php
                        echo wp_kses(
                                sprintf(
                                /* translators: %s: URL to the Customizer. */
                                    __( 'This draft comes from your <a href="%s">unpublished customization changes</a>. You can edit, but there&#8217;s no need to publish now. It will be published automatically with those changes.' ),
                                    esc_url(
                                        add_query_arg(
                                            'changeset_uuid',
                                            rawurlencode( get_post_meta( $post_id, '_customize_changeset_uuid', true ) ),
                                            admin_url( 'customize.php' )
                                        )
                                    )
                                ),
                                array('a' => array( 'href' => true ) )
                            );
                        ?>
                    </p>
                </div>
            <?php
            endif;

            /**
             * Fires after the post time/date setting in the Publish meta box.
             *
             * @since 2.9.0
             * @since 4.4.0 Added the `$post` parameter.
             *
             * @param WP_Post $post WP_Post object for the current post.
             */
            do_action( 'post_submitbox_misc_actions', $post );
            ?>
        </div>
        <div class="clear"></div>
        </div>

        <div id="major-publishing-actions">
            <?php
            /**
             * Fires at the beginning of the publishing actions section of the Publish meta box.
             *
             * @since 2.7.0
             * @since 4.9.0 Added the `$post` parameter.
             *
             * @param WP_Post|null $post WP_Post object for the current post on Edit Post screen,
             *                           null on Edit Link screen.
             */
            do_action( 'post_submitbox_start', $post );
            ?>
            <?php
                if ( defined('SFS_FILTERS_PRO') && SFS_FILTERS_PRO ) {
                    if ($post->post_type === SFS_FILTERS_SET_POST_TYPE) {
                    if ( current_user_can( 'delete_post', $post_id ) ) {
                        $url = wp_nonce_url(admin_url('admin.php?action=sfs_duplicate_filter_set&post=' . $post->ID), 'sfs_duplicate_filter_set'); ?>
                        <div class="duplicate-sfs-set">
                            <a href="<?php echo esc_url($url); ?>"><?php echo esc_html__('Duplicate SFS Set', 'searchfiltersort'); ?></a>
                        </div>
                    <?php }
                }
            }?>
            <div id="delete-action">
                <?php
                if ( current_user_can( 'delete_post', $post_id ) ) {
                    if ( ! EMPTY_TRASH_DAYS ) {
                        $delete_text = esc_html__( 'Delete permanently' );
                    } else {
                        $delete_text = esc_html__( 'Move to Trash' );
                    }
                    ?>
                    <a class="submitdelete deletion" href="<?php echo get_delete_post_link( $post_id ); ?>"><?php echo esc_html( $delete_text ); ?></a>
                    <?php
                }
                ?>
            </div>

            <div id="publishing-action">
                <span class="spinner"></span>
                <?php
                if ( ! in_array( $post->post_status, array( 'publish', 'future', 'private' ), true ) || 0 === $post_id ) {
                    if ( $can_publish ) :
                        if ( ! empty( $post->post_date_gmt ) && time() < strtotime( $post->post_date_gmt . ' +0000' ) ) :
                            ?>
                            <input name="original_publish" type="hidden" id="original_publish" value="<?php echo esc_attr_x( 'Schedule', 'post action/button label' ); ?>" />
                            <?php submit_button( _x( 'Schedule', 'post action/button label' ), 'primary large', 'publish', false ); ?>
                        <?php
                        else :
                            ?>
                            <input name="original_publish" type="hidden" id="original_publish" value="<?php esc_attr_e( 'Publish' ); ?>" />
                            <?php submit_button( esc_html__( 'Publish' ), 'primary large', 'publish', false ); ?>
                        <?php
                        endif;
                    else :
                        ?>
                        <input name="original_publish" type="hidden" id="original_publish" value="<?php esc_attr_e( 'Submit for Review' ); ?>" />
                        <?php submit_button( esc_html__( 'Submit for Review' ), 'primary large', 'publish', false ); ?>
                    <?php
                    endif;
                } else {
                    ?>
                    <input name="original_publish" type="hidden" id="original_publish" value="<?php esc_attr_e( 'Update' ); ?>" />
                    <?php submit_button( esc_html__( 'Update' ), 'primary large', 'save', false, array( 'id' => 'publish' ) ); ?>
                    <?php
                }
                ?>
            </div>
            <div class="clear"></div>
        </div>

        </div>
        <?php
    }
}

new MetaBoxes();