<?php


namespace SearchFilterSort\Filter;

if ( ! defined('ABSPATH') ) {
    exit;
}

class Admin
{
    public $tabRenderer;

    public function __construct()
    {
        add_action( 'admin_menu', array($this, 'adminMenu'), 9);
        $this->tabRenderer = Container::instance()->getTabRenderer();
        $filterSet = Container::instance()->getSFSSetService();

        add_action( 'pre_post_update', [$filterSet, 'preSaveSet'], 10, 2 );
        add_action( 'save_post', array( $filterSet, 'saveSet' ), 10, 2 );

        add_action( 'init', array( $this, 'initTabs' ), 11 );

        add_action( 'admin_init', array( $this, 'init' ) );

        add_filter( 'sfswp_general_filters_settings', [$this, 'generalSFSSettings'] );
    }

    public function init()
    {
        $filterFields = Container::instance()->getSFSFieldsService();
        $filterFields->registerHooks();

        // Check permissions before to show these screens
        add_action( 'load-post.php', [ $this, 'checkPermissions' ] );
        add_action( 'load-edit.php', [ $this, 'checkPermissions' ] );
        add_action( 'load-post-new.php', [ $this, 'checkPermissions' ] );

    }

    public function adminMenu()
    {
        $page = 'edit.php?post_type=' . SFS_FILTERS_SET_POST_TYPE;

        add_menu_page( esc_html__('SearchFilterSort', 'searchfiltersort'), esc_html__('SearchFilterSort', 'searchfiltersort'), 'manage_options', $page, false,  SFS_PLUGIN_DIR_URL . 'assets/img/dashicons-sfs1.svg', '85');

        add_submenu_page( $page, esc_html__('SFS Sets', 'searchfiltersort'), esc_html__('SFS Sets', 'searchfiltersort'), 'manage_options', $page);
        add_submenu_page( $page, esc_html__('Add New', 'searchfiltersort'), esc_html__('Add New', 'searchfiltersort'), 'manage_options', 'post-new.php?post_type=' . SFS_FILTERS_SET_POST_TYPE);

        do_action('sfswp_add_submenu_pages');

        add_submenu_page( $page, esc_html__('Settings', 'searchfiltersort'), esc_html__('Settings', 'searchfiltersort'), 'manage_options', 'sfs-settings', array($this, 'filterSettingsPageTabs'));

        do_action('sfswp_after_add_submenu_pages');
    }

    public function filterSettingsPage()
    {
        $this->tabRenderer->render();
    }
    public function filterSettingsPageTabs()
    {
        $this->tabRenderer->render_tabs();
    }

    public function initTabs()
    {
        $this->tabRenderer->register(new SettingsTab());
        $this->tabRenderer->register(new PermalinksTab());


        do_action( 'sfswp_setttings_tabs_register', $this->tabRenderer );
        $this->tabRenderer->register(new ExperimentalTab());
        $this->tabRenderer->init();
    }

    public function get_icon_svg()
    {
        return sfs_get_icon_svg();
    }

    public function checkPermissions()
    {
        $screen     = get_current_screen();
        $post_types = [ SFS_FILTERS_SET_POST_TYPE, SFS_FILTERS_POST_TYPE ];

        if( defined('SFS_FILTERS_PRO') && SFS_FILTERS_PRO ){
            $post_types[] = SFS_SEO_RULES_POST_TYPE;
        }

        if( ! is_null( $screen ) && property_exists( $screen, 'post_type' ) && in_array( $screen->post_type, $post_types, true ) ){
            if( ! current_user_can( sfs_plugin_user_caps() ) ) {
                wp_die( esc_html__( 'Sorry, you are not allowed to access this page.' ) );
            }
        }
    }

    public function generalSFSSettings( $settings )
    {
        $result_terms   = [];

        // Chips hooks
        $maybe_saved_terms  = sfs_get_option('show_terms_in_content', []);
        $theme_dependencies = sfs_get_theme_dependencies();

        $current_terms = isset($settings['common_settings']['fields']['show_terms_in_content']['options']) ? $settings['common_settings']['fields']['show_terms_in_content']['options'] : array();

        if( sfs_is_woocommerce() ){
            $woocommerce_terms = array(
                'woocommerce_archive_description' => esc_html__('WooCommerce archive description', 'searchfiltersort' ),
                'woocommerce_no_products_found' => esc_html__('WooCommerce no products found', 'searchfiltersort' ),
                'woocommerce_before_shop_loop' => esc_html__('WooCommerce before Shop loop', 'searchfiltersort' ),
                'woocommerce_before_main_content' => esc_html__('WooCommerce before main content', 'searchfiltersort' )
            );

            $result_terms = array_merge( $current_terms, $woocommerce_terms );
        }

        if( $maybe_saved_terms && is_array( $maybe_saved_terms )){
            foreach ($maybe_saved_terms as $hook ){
                if( ! in_array( $hook, array_keys( $result_terms ) ) ){
                    $result_terms[$hook] = $hook;
                }
            }
        }

        if( isset( $theme_dependencies['chips_hook'] ) && ! empty( $theme_dependencies['chips_hook'] )){
            foreach ($theme_dependencies['chips_hook'] as $hook ){
                if( ! in_array( $hook, array_keys( $result_terms ) ) ){
                    $result_terms[$hook] = $hook;
                }
            }
        }

        $settings['common_settings']['fields']['show_terms_in_content']['options'] = $result_terms;

        return $settings;
    }
}