<?php
/**
 * Plugin Name: SearchFilterSort
 * Description: Powerful AJAX search, filtering, and sorting for posts, custom post types, and WooCommerce products. Fully customizable and easy to use.
 * Version:     1.1.2
 * Author: Creative Werk Designs
 * Author URI: https://www.creativewerkdesigns.com/
 * Text Domain: searchfiltersort
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package searchfiltersort
 */

// If this file is called directly, abort.
if ( ! defined('ABSPATH') ) {
    exit;
}

if( ! class_exists( 'SearchFilterSort' ) ):

    class SearchFilterSort{

        public function init()
        {
            global $sfs_sets, $sfswp_not_fired, $sfs_chips_count;

            $sfs_chips_count   = 0;
            $sfswp_not_fired = true;
            $sfs_sets     = [];

            $this->define( 'SFS_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
            $this->define( 'SFS_PLUGIN_DIR_URL', plugin_dir_url( __FILE__ ) );
            $this->define( 'SFS_PLUGIN_BASENAME', plugin_basename(__FILE__) );
            $this->define( 'SFS_PLUGIN_SLUG', 'searchfiltersort' );
            $this->define( 'SFS_PLUGIN_VER', '1.1.2' );
            $this->define( 'SFS_PLUGIN_URL', 'https://www.searchfiltersort.com' );
            $this->define( 'SFS_PLUGIN_TESTED_TO', '6.9' );
            $this->define( 'SFS_PLUGIN_DEBUG', false );
            $this->define( 'SFS_TEMPLATES_DIR_NAME', 'filters' );

            $this->define( 'SFS_FILTERS_SET_POST_TYPE', 'sfs-set' );
            $this->define( 'SFS_FILTERS_POST_TYPE', 'sfs-field' );
            $this->define( 'SFS_PREFIX_SEPARATOR', '-' );
            $this->define( 'SFS_QUERY_TERMS_SEPARATOR', ';' );
            $this->define( 'SFS_DATE_TIME_SEPARATOR', 't' );
            $this->define( 'SFS_FOLDING_COOKIE_NAME', 'sfswpContainersStatus' );
            $this->define( 'SFS_MORELESS_COOKIE_NAME', 'sfswpMoreLessStatus' );
            $this->define( 'SFS_HIERARCHY_LIST_COOKIE_NAME', 'sfswpHierarchyListStatus' );
            $this->define( 'SFS_OPEN_CLOSE_BUTTON_COOKIE_NAME', 'sfswpWidgetStatus' );
            $this->define( 'SFS_APPLY_BUTTON_META_KEY', 'sfswp_filter_set_apply_button_post_name' );
            $this->define( 'SFS_TRANSIENT_PERIOD_HOURS', 12 );
            $this->define( 'SFS_BEAVER_BUILDER_VAR', 'fl_builder' );
            $this->define( 'SFS_LICENSE_KEY', 'sfswp_filter_license' );
            $this->define( 'SFS_BUY_PRO_VERSION_URL', 'https://www.searchfiltersort.com/pricing/' );
            

            require_once SFS_PLUGIN_DIR_PATH . 'src/sfswp-helpers.php';

            sfs_include('src/sfswp-compat.php');
            sfs_include('src/sfswp-default-hooks.php');
            sfs_include('src/sfswp-third-party.php');

            sfs_include('src/Plugin.php');
            sfs_include('src/PostTypes.php');
            sfs_include('src/Settings/TabInterface.php');
            sfs_include('src/Settings/BaseSettings.php');
            sfs_include('src/Settings/TabRenderer.php');
            sfs_include('src/Settings/Container.php');

            sfs_include('src/Entities/Entity.php');

            sfs_include('src/Entities/TaxonomyEntity.php');
            sfs_include('src/Entities/PostMetaEntity.php');
            sfs_include('src/Entities/PostMetaNumEntity.php');
            sfs_include('src/Entities/AuthorEntity.php');
            sfs_include('src/Entities/PostDateEntity.php');

            // Include PRO
//            sfs_include('pro/filters-pro.php');

            sfs_include('src/Entities/DefaultEntity.php');
            sfs_include('src/Entities/EntityManager.php');
            sfs_include('src/Settings/Tabs/PermalinksTab.php');
            sfs_include('src/Settings/Tabs/SettingsTab.php');
            sfs_include('src/Settings/Tabs/ExperimentalTab.php');
            sfs_include('src/Settings/Filter.php');

            sfs_include('src/RequestParser.php');
            sfs_include('src/UrlManager.php');
            sfs_include('src/Chips.php');
            sfs_include('src/Sorting.php');
            sfs_include('src/Swatches.php');

            sfs_include('src/Walkers/WalkerCheckbox.php');

            sfs_include('src/TemplateManager.php');
            sfs_include('src/WpManager.php');

            sfs_include('src/Admin/SFSSet.php');
            sfs_include('src/Admin/SFSFields.php');
            sfs_include('src/Admin/Admin.php');
            sfs_include('src/Admin/AdminHooks.php');
            sfs_include('src/Admin/MetaBoxes.php');
            sfs_include('src/Admin/Widgets/FiltersWidget.php');
            sfs_include('src/Admin/Widgets/ChipsWidget.php');
            sfs_include('src/Admin/Widgets/SortingWidget.php');
            sfs_include('src/Admin/Widgets.php');
            sfs_include('src/Admin/Shortcodes.php');
            sfs_include('src/Admin/Validator.php');
            sfs_include('src/Admin/DuplicateSFSSet.php');

            sfs_include('src/FormFields/Input.php');
            sfs_include('src/sfswp-api.php');

            $this->registerHooks();

            $this->initSettings();

            sfs_check_update_mobile_settings();

            if( sfs_get_experimental_option( 'disable_woo_orderby' ) === 'on' ) {
                if( ! function_exists('woocommerce_catalog_ordering') ){
                    function woocommerce_catalog_ordering()
                    {
                        return false;
                    }
                }
            }
        }

        public function registerHooks()
        {
            // Backward compatibility. From v1.3.2
            add_action( 'init', [ $this, 'convertShowChipsInContent' ], -1 );

            add_action( 'init', [ $this, 'oneTwoThreeGo' ] );

            add_action( 'init', [ $this, 'loadTextdomain' ], 0 );

            add_action( 'after_setup_theme', [$this, 'afterSetupTheme'] );

            register_activation_hook(__FILE__, ['SearchFilterSort\Filter\Plugin', 'activate']);

            register_uninstall_hook(__FILE__, ['SearchFilterSort\Filter\Plugin', 'uninstall']);

            add_action('after_switch_theme', ['SearchFilterSort\Filter\Plugin', 'switchTheme'] );
        }

        public function convertShowChipsInContent()
        {
            // Backward compatibility. From v1.3.2
            $filter_settings = get_option('sfswp_filter_settings');

            if ( isset( $filter_settings['show_terms_in_content'] ) && $filter_settings['show_terms_in_content'] === 'on' ) {
                $new_chips_hooks = [];
                $theme_dependencies = sfs_get_theme_dependencies();

                if ( sfs_is_woocommerce() ) {
                    $new_chips_hooks[] = 'woocommerce_no_products_found';
                    $new_chips_hooks[] = 'woocommerce_archive_description';
                }

                if ( isset( $theme_dependencies['chips_hook'] ) && is_array($theme_dependencies['chips_hook'] ) ) {
                    foreach ( $theme_dependencies['chips_hook'] as $compat_chips_hook ) {
                        $new_chips_hooks[] = $compat_chips_hook;
                    }
                }

                $filter_settings['show_terms_in_content'] = $new_chips_hooks;
                update_option('sfswp_filter_settings', $filter_settings );
            }
        }

        public function loadTextdomain()
        {
            load_plugin_textdomain( 'searchfiltersort', false, dirname(SFS_PLUGIN_BASENAME) . '/lang' );
        }

        public function oneTwoThreeGo()
        {
            global $sfs_plugin;
            $sfs_plugin = new \SearchFilterSort\Filter\Plugin();
        }

        /**
         * @since 1.6.1
         */
        public function afterSetupTheme()
        {
            $this->define( 'SFS_ALLOW_PLL_TRANSLATIONS', true );
        }

        private function initSettings(){
            $container = \SearchFilterSort\Filter\Container::instance();

            $settings['php_to_js_date_formats'] = array(
                'Y' => 'yy',
                'y' => 'y',
                'm' => 'mm',
                'n' => 'm',
                'F' => 'MM',
                'M' => 'M',
                'l' => 'DD',
                'D' => 'D',
                'd' => 'dd',
                'j' => 'd',
                'S' => '',
            );

            $settings['php_to_js_time_formats'] = array(
                'a' => 'tt',
                'A' => 'TT',
                'h' => 'hh',
                'g' => 'h',
                'H' => 'HH',
                'G' => 'H',
                'i' => 'mm',
                's' => 'ss',
            );

            foreach ( $settings as $key => $value ) {
                $container->storeParam( $key, $value );
            }
        }

        public function define( $name, $value = true )
        {
            if( ! defined( $name ) ) {
                define( $name, $value );
            }
        }

    }

    function sfs_filter()
    {
        global $sfswpFilter;

        if( ! isset( $sfswpFilter ) ) {
            $sfswpFilter = new SearchFilterSort();
            $sfswpFilter->init();
        }

        return $sfswpFilter;

    }

    sfs_filter();

endif;