/*!
 * SearchFilterSort header admin
 */
(function($) {
    "use strict";

    jQuery(document).ready(function () {
        $(document).on(
            'click',
            '.sfs-header-section .whatsNew-toggle, .sfs-header-section .close-block',
            function () {
                $('.sfs-header-section .sfs-header-right').toggleClass('active');
                $('.sfs-header-section .whatsNew-toggle').toggleClass('active');
            }
        );

        // Video Tutorial Js
        $(document).on(
            'click',
            '.play-icon',
            function(e){
            e.preventDefault();
            var videoId = $(this).data('video-id');
            var videoURL = 'https://www.youtube.com/embed/' + videoId + '?autoplay=1';
            $('#youtube-video').attr('src', videoURL);

            // Add flex display before fadeIn
            $('#video-popup').css('display', 'flex').hide().fadeIn();
        });

        $(document).on(
            'click',
            '.close, #video-popup',
            function(){
            $('#youtube-video').attr('src', '');
            $('#video-popup').fadeOut(function(){
                $(this).css('display', 'none'); // optional cleanup
            });
        });

       $(document).on(
            'click',
            '.popup-content',
            function(e){
            e.stopPropagation();
        });

        //Install and Active Woocommerce Plugin button
        $('#wpsswinstallactivebtn').on('click', function () {
            var wpnonce = jQuery( '#wpssw_api_dashboard' ).val();
            var plugin_slug = 'wpsyncsheets-woocommerce'; // Replace with your plugin slug
            $('#wpsswinstallactivebtn').html('Installing...');
            jQuery.ajax(
                {
                    url: admin_ajax_object.ajaxurl,
                    type: "post",
                    data: "action=install_and_activate_plugin&plugin_slug="+ plugin_slug +"&_wpnonce=" + wpnonce,
                    success: function (response) {
                        $('#wpsswinstallactivebtn').html('Activated');
                        $('#wpsswinstallactivebtn').toggleClass('activated underline');
                        $('#wpsswinstallactivebtn').attr('id', '');
                    },
                    error: function (s) {
                        alert( "Error" );
                    },
                }
            );
        });

        // Active Woocommerce Plugin button
        $('#wpsswactivebtn').on('click', function () {
            var wpnonce = jQuery( '#wpssw_api_dashboard' ).val();
            var plugin_slug = 'wpsyncsheets-woocommerce'; // Replace with your plugin slug
            $('#wpsswactivebtn').html('Activating...');
            jQuery.ajax(
                {
                    url: admin_ajax_object.ajaxurl,
                    type: "post",
                    data: "action=install_and_activate_plugin&plugin_active=true&plugin_slug="+ plugin_slug +"&_wpnonce=" + wpnonce,
                    success: function (response) {
                        $('#wpsswactivebtn').html('Activated');
                        $('#wpsswactivebtn').toggleClass('activated underline');
                        $('#wpsswactivebtn').attr('id', '');
                    },
                    error: function (s) {
                        alert( "Error" );
                    },
                }
            );
        });

        //Install and Active Elementor Plugin button
        $('#wpsseinstallactivebtn').on('click', function () {
            var wpnonce = jQuery( '#wpsse_api_dashboard' ).val();
            var plugin_slug = 'wpsyncsheets-elementor'; // Replace with your plugin slug
            $('#wpsseinstallactivebtn').html('Installing...');
            jQuery.ajax(
                {
                    url: admin_ajax_object.ajaxurl,
                    type: "post",
                    data: "action=install_and_activate_plugin&plugin_slug="+ plugin_slug +"&_wpnonce=" + wpnonce,
                    success: function (response) {
                        $('#wpsseinstallactivebtn').html('Activated');
                        $('#wpsseinstallactivebtn').toggleClass('activated underline');
                        $('#wpsseinstallactivebtn').attr('id', '');
                    },
                    error: function (s) {
                        alert( "Error" );
                    },
                }
            );
        });

        // Active Elementor Plugin button
        $('#wpsseactivebtn').on('click', function () {
            var wpnonce = jQuery( '#wpsse_api_dashboard' ).val();
            var plugin_slug = 'wpsyncsheets-elementor'; // Replace with your plugin slug
            $('#wpsseactivebtn').html('Activating...');
            jQuery.ajax(
                {
                    url: admin_ajax_object.ajaxurl,
                    type: "post",
                    data: "action=install_and_activate_plugin&plugin_active=true&plugin_slug="+ plugin_slug +"&_wpnonce=" + wpnonce,
                    success: function (response) {
                        $('#wpsseactivebtn').html('Activated');
                        $('#wpsseactivebtn').toggleClass('activated underline');
                        $('#wpsseactivebtn').attr('id', '');
                    },
                    error: function (s) {
                        alert( "Error" );
                    },
                }
            );
        });

        //Install and Active Contact Form Plugin button
        $('#wpsscinstallactivebtn').on('click', function () {
            var wpnonce = jQuery( '#wpssc_api_dashboard' ).val();
            var plugin_slug = 'contactsheets-lite'; // Replace with your plugin slug
            $('#wpsscinstallactivebtn').html('Installing...');
            jQuery.ajax(
                {
                    url: admin_ajax_object.ajaxurl,
                    type: "post",
                    data: "action=install_and_activate_plugin&plugin_slug="+ plugin_slug +"&_wpnonce=" + wpnonce,
                    success: function (response) {
                        $('#wpsscinstallactivebtn').html('Activated');
                        $('#wpsscinstallactivebtn').toggleClass('activated underline');
                        $('#wpsscinstallactivebtn').attr('id', '');
                    },
                    error: function (s) {
                        alert( "Error" );
                    },
                }
            );
        });

        // Active Contact Form Plugin button
        $('#wpsscactivebtn').on('click', function () {
            var wpnonce = jQuery( '#wpssc_api_dashboard' ).val();
            var plugin_slug = 'contactsheets-lite'; // Replace with your plugin slug
            $('#wpsscactivebtn').html('Activating...');
            jQuery.ajax(
                {
                    url: admin_ajax_object.ajaxurl,
                    type: "post",
                    data: "action=install_and_activate_plugin&plugin_active=true&plugin_slug="+ plugin_slug +"&_wpnonce=" + wpnonce,
                    success: function (response) {
                        $('#wpsscactivebtn').html('Activated');
                        $('#wpsscactivebtn').toggleClass('activated underline');
                        $('#wpsscactivebtn').attr('id', '');
                    },
                    error: function (s) {
                        alert( "Error" );
                    },
                }
            );
        });

        //Install and Active Gravity Forms Plugin button
        $('#wpssginstallactivebtn').on('click', function () {
            var wpnonce = jQuery( '#wpssg_api_dashboard' ).val();
            var plugin_slug = 'wpsyncsheets-gravity-forms'; // Replace with your plugin slug
            $('#wpssginstallactivebtn').html('Installing...');
            jQuery.ajax(
                {
                    url: admin_ajax_object.ajaxurl,
                    type: "post",
                    data: "action=install_and_activate_plugin&plugin_slug="+ plugin_slug +"&_wpnonce=" + wpnonce,
                    success: function (response) {
                        $('#wpssginstallactivebtn').html('Activated');
                        $('#wpssginstallactivebtn').toggleClass('activated underline');
                        $('#wpssginstallactivebtn').attr('id', '');
                    },
                    error: function (s) {
                        alert( "Error" );
                    },
                }
            );

        });

        // Active Gravity Forms Plugin button
        $('#wpssgactivebtn').on('click', function () {
            var wpnonce = jQuery( '#wpssg_api_dashboard' ).val();
            var plugin_slug = 'wpsyncsheets-gravity-forms'; // Replace with your plugin slug
            $('#wpssgactivebtn').html('Activating...');
            jQuery.ajax(
                {
                    url: admin_ajax_object.ajaxurl,
                    type: "post",
                    data: "action=install_and_activate_plugin&plugin_active=true&plugin_slug="+ plugin_slug +"&_wpnonce=" + wpnonce,
                    success: function (response) {
                        $('#wpssgactivebtn').html('Activated');
                        $('#wpssgactivebtn').toggleClass('activated underline');
                        $('#wpssgactivebtn').attr('id', '');
                    },
                    error: function (s) {
                        alert( "Error" );
                    },
                }
            );
        });

    });


	

})(jQuery);

function sfsNavTabLetsBegin(evt, tabName) {
    "use strict";
    var i, tabContent, tabLinks;
    tabContent           = document.getElementsByClassName( "navtabcontent" );
    var tabContentlength = tabContent.length;
    for (i = 0; i < tabContentlength; i++) {
        tabContent[i].style.display = "none";
    }
    tabLinks      = document.getElementsByClassName( "navtablinks" );
    var tablength = tabLinks.length;
    for (i = 0; i < tablength; i++) {
        tabLinks[i].className = tabLinks[i].className.replace( " active", "" );
        if(tabLinks[i].className == 'navtablinks sfs-nav-sets')
        {
            tabLinks[i].className += " active";
        }
    }
    document.getElementById( tabName ).style.display = "block";
    var type = typeof evt;
    if (type !== "undefined") {
        evt.currentTarget.className += " active";
    }
    window.scrollTo({
        top: 0,
        behavior: 'smooth' // Optional for smooth animation
    });
}


function sfsNavTab(evt, tabName) {
    "use strict";
    var i, tabContent, tabLinks;
    tabContent           = document.getElementsByClassName( "navtabcontent" );
    var tabContentlength = tabContent.length;
    for (i = 0; i < tabContentlength; i++) {
        tabContent[i].style.display = "none";
    }
    tabLinks      = document.getElementsByClassName( "navtablinks" );
    var tablength = tabLinks.length;
    for (i = 0; i < tablength; i++) {
        tabLinks[i].className = tabLinks[i].className.replace( " active", "" );
    }
    const tabEl = document.getElementById(tabName);
    tabEl.style.display = "block";
    if (tabEl) {
        const wrapper = tabEl.closest('.sfs-tabs-main');
        const bodywrapper = tabEl.closest('#wpcontent');
        wrapper.className += " active";
        bodywrapper.className += " sfs-tab-active active";
    }

    var type = typeof event;
    if (type !== "undefined") {
        evt.currentTarget.className += " active";
    }
}

function sfsTab(evt, tabName) {
    "use strict";

    evt.preventDefault();

    // Get the parent container
    var container = evt.currentTarget.closest('.sfs-nav-settings-content');

    // Safety check
    if (!container) {
        return;
    }

    // Only tab contents inside this container
    var tabContent = container.getElementsByClassName("tabcontent");
    var tabLinks   = container.getElementsByClassName("tablinks");

    var i;

    for (i = 0; i < tabContent.length; i++) {
        tabContent[i].style.display = "none";
    }

    for (i = 0; i < tabLinks.length; i++) {
        tabLinks[i].className = tabLinks[i].className.replace(" active", "");
    }

    var activeTab = container.querySelector('#' + tabName);
    if (activeTab) {
        activeTab.style.display = "block";
    }
    evt.currentTarget.className += " active";
}
