/*!
 * SearchFilterSort common admin 1.9.1
 */
(function($) {
    "use strict";

    $(document).ready(function (){
        let sfswpUserAgent = navigator.userAgent.toLowerCase();
        let sfswpIsAndroid = sfswpUserAgent.indexOf("android") > -1;
        let sfswpAllowSearchField = 0;
        if(sfswpIsAndroid) {
            sfswpAllowSearchField = Infinity;
        }

        // Common JS code
        $(document).on('change', '#mobile_filter_settings', function (e){
            if($(this).val() === 'show_bottom_widget'){
                $('#show_open_close_button').parent('label').addClass('sfswp-inactive-settings-field');
                $('.sfswp-bottom-widget-compatibility').addClass('sfswp-opened');
            }else{
                $('#show_open_close_button').parent('label').removeClass('sfswp-inactive-settings-field');
                $('.sfswp-bottom-widget-compatibility').removeClass('sfswp-opened');
            }
        });

        $(document).on('click', '#use_color_swatches', function (e){
            if ( $(this).is(':checked') ) {
                $('.sfswp-color-swatches-taxonomies').addClass('sfswp-opened');
            } else {
                $('.sfswp-color-swatches-taxonomies').removeClass('sfswp-opened');
            }
        });

        $('#sfswp_primary_color').wpColorPicker({
            defaultColor: '',
            palettes: [ '#0570e2', '#f44336', '#E91E63', '#007cba', '#65BC7B', '#FFEB3B', '#FFC107', '#FF9800', '#607D8B'],
        });

        $('#sfswp_term_color').wpColorPicker({
            defaultColor: '',
            palettes: [ '#0000FF', '#808080', '#008000', '#FF0000', '#FFFF00', '#FFA500', '#00bfff', '#7F00FF', '#FFFFFF'],
        });

        $('.sfswp-help-tip').tipTip({
            'attribute': 'data-tip',
            'fadeIn':    50,
            'fadeOut':   50,
            'delay':     200,
            'keepAlive': true,
            'maxWidth': "220px",
        });

        $( '.sfswp-sortable-table' ).sortable({
            items: "tr.pro-version.sfswp-sortable-row",
            delay: 150,
            placeholder: "sfswp-sfs-field-shadow",
            refreshPositions: true,
            cursor: 'move',
            handle: ".sfswp-order-sortable-handle-icon",
            axis: 'y',
            update: function( event, ui ) {
                renderTableOrder();
            },

        });

        $(document).on( 'click', '.free-version .sfswp-field-sortable-handle', function (){
            alert( sfswpFiltersAdminCommon.prefixesOrderAvailableInPro );
        });

        $("#show_terms_in_content").select2({
            width: '80%',
            placeholder: sfswpFiltersAdminCommon.chipsPlaceholder,
            minimumResultsForSearch: sfswpAllowSearchField,
            tags: true
        });

        $("#color_swatches_taxonomies").select2({
            width: '80%',
            placeholder: sfswpFiltersAdminCommon.colorSwatchesPlaceholder,
            minimumResultsForSearch: sfswpAllowSearchField,
            tags: false,
        });

        $('body').on('click', '.sfswp-notice-dismiss', function (e){
            e.preventDefault();

            let requestParams      = {};
            requestParams._wpnonce = $(this).data('nonce');
            let dismissAction      = $(this).data('action');

            wp.ajax.post( dismissAction, requestParams )
                .always( function( response ) {
                    // $spinner.removeClass( 'is-active' );
                    var $el = $( '.license-notice' );
                    $el.fadeTo( 100, 0, function() {
                        $el.slideUp( 100, function() {
                            $el.remove();
                        });
                    });
                })
        });

        // on upload button click
        $( document ).on( 'click', '.sfswp-upload', function( event ){

            event.preventDefault(); // prevent default link click and page refresh

            const button = $(this)
            const imageId = button.next().next().val();

            const customUploader = wp.media({
                title: 'Insert image', // modal window title
                library : {
                    // uploadedTo : wp.media.view.settings.post.id, // attach to the current post?
                    type : 'image'
                },
                button: {
                    text: 'Use this image' // button label text
                },
                multiple: false
            }).on( 'select', function() { // it also has "open" and "close" events
                const attachment = customUploader.state().get( 'selection' ).first().toJSON();
                button.removeClass( 'button' ).html( '<img src="' + attachment.url + '">'); // add image instead of "Upload Image"
                button.next().show(); // show "Remove image" link
                button.next().next().val( attachment.id ); // Populate the hidden field with image ID
            })

            // already selected images
            customUploader.on( 'open', function() {

                if( imageId ) {
                    const selection = customUploader.state().get( 'selection' )
                    let attachment = wp.media.attachment( imageId );
                    attachment.fetch();
                    selection.add( attachment ? [attachment] : [] );
                }

            })

            customUploader.open()
        });

        // on remove button click
        $( document ).on( 'click', '.sfswp-remove', function( event ){
            sfswpHideTheRemoveButton( $(this) );
        });

        $( document ).ajaxSuccess( function(e, request, settings) {
            let params = new URLSearchParams( settings.data );
            let action = params.get('action');

            if( action === 'add-tag' ){
                // clear form
                $("#sfswp_term_img, #sfswp_term_color").val('');
                $(".sfswp-remove").hide();
                sfswpHideTheRemoveButton( $("a.sfswp-remove") );

                $(".sfswp-color-picker .wp-picker-clear").trigger('click');
            }
            // else {
            //     console.log( settings.data );
            // }
        });


    }); // End $(document).ready();

    $(document).on('click', '.sfswp-error.is-dismissible > .notice-dismiss', function (e){
            e.preventDefault();

            let $button = $( this );
            let $el = $button.parent('.sfswp-error');

            $el.fadeTo( 100, 0, function() {
                $el.slideUp( 100, function() {
                    $el.remove();
                });
            });
            $el.append( $button );
    });

    function renderTableOrder()
    {
        let num = 0;
        $("tr.sfswp-sortable-row").each( function ( index, element ) {
            num = (index + 1);
            $(element).find('.sfswp-order-td').text(num);
        });
    }

    function sfswpHideTheRemoveButton( element ){
        // event.preventDefault();
        const button = element; //$(this);
        button.next().val( '' ); // emptying the hidden field
        button.hide().prev().addClass( 'button' ).html( 'Upload image' ); // replace the image with text
    }
    

})(jQuery);