<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}
?>
<div class="wrap">
    <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
    <form action="<?php echo esc_url( admin_url( 'admin.php?page=searchable-parent-dropdowns' ) ); ?>" method="post">
        <?php wp_nonce_field( 'wpapps_sf_save_settings', 'wpapps_sf_settings_nonce' ); ?>
        <div class="card">
            <h2 class="title"><?php esc_html_e( 'Enabled Fields', 'searchable-parent-dropdowns' ); ?></h2>
            <p>
                <?php esc_html_e( 'Select which fields should be converted to searchable dropdowns:', 'searchable-parent-dropdowns' ); ?>
            </p>
            <table class="form-table">
                <tbody>
                    <?php
                    // Get the saved enabled fields
                    $enabled_for = get_option('wpapps_sf_enabled_for', '');
                    $enabled_fields = !empty($enabled_for) ? explode(', ', $enabled_for) : array();
                    
                    // Debug output
                    error_log('Enabled fields from DB: ' . print_r($enabled_fields, true));
                    error_log('Plugin options: ' . print_r(array_column(Searchable_Parent_Dropdowns::$plugin_options, 'selector'), true));
                    
                    foreach (Searchable_Parent_Dropdowns::$plugin_options as $option) :
                        // Check if the current option's selector is in the enabled fields
                        $is_checked = in_array($option['selector'], $enabled_fields);
                        error_log(sprintf(
                            'Checking %s: %s (looking for %s in %s)',
                            $option['id'],
                            $is_checked ? 'checked' : 'not checked',
                            $option['selector'],
                            implode(', ', $enabled_fields)
                        ));
                        $checked = $is_checked ? 'checked="checked"' : '';
                        ?>
                        <tr>
                            <th scope="row">
                                <label for="<?php echo esc_attr( $option['id'] ); ?>">
                                    <?php echo esc_html( $option['label'] ); ?>
                                </label>
                            </th>
                            <td>
                                <input 
                                    type="checkbox" 
                                    name="wpapps_sf_enabled_fields[]" 
                                    id="<?php echo esc_attr( $option['id'] ); ?>" 
                                    value="<?php echo esc_attr( $option['selector'] ); ?>" 
                                    <?php echo esc_attr( $checked ); ?> 
                                />
                                <p class="description">
                                    <?php printf( 
                                        /* translators: %s: CSS selector */
                                        esc_html__( 'Applies to: %s', 'searchable-parent-dropdowns' ), 
                                        '<code>' . esc_html( $option['selector'] ) . '</code>'
                                    ); ?>
                                </p>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php submit_button( esc_attr__( 'Save Settings', 'searchable-parent-dropdowns' ) ); ?>
        </div>
    </form>
</div>