<?php
/**
 * Plugin Name: Searchable Parent Dropdowns
 * Plugin URI: https://wordpress.org/plugins/searchable-parent-dropdowns
 * Description: Transform standard WordPress parent dropdowns into searchable select fields, making it easy to find and select parent pages and categories.
 * Version: 1.0.0
 * Author: WPApps
 * Author URI: https://wpapps.net
 * License: GPL-2.0+
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: searchable-parent-dropdowns
 * Domain Path: /languages
 * Requires at least: 5.0
 * Tested up to: 6.6.2
 * Requires PHP: 7.2
 * Tags: searchable, dropdown, admin, pages, categories, hierarchical, content management
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Define plugin constants
if (!defined('WPAPPS_SF_PLUGIN_DIR')) {
    define('WPAPPS_SF_PLUGIN_DIR', plugin_dir_path(__FILE__));
}

if (!defined('WPAPPS_SF_PLUGIN_URL')) {
    define('WPAPPS_SF_PLUGIN_URL', plugin_dir_url(__FILE__));
}

// Initialize the plugin
add_action('plugins_loaded', 'wpapps_searchable_fields_init');

/**
 * Initialize the plugin
 */
function wpapps_searchable_fields_init() {
    // Load textdomain for translations
    load_plugin_textdomain(
        'searchable-parent-dropdowns',
        false,
        dirname(plugin_basename(__FILE__)) . '/languages/'
    );

    // Initialize the main plugin class
    if (is_admin()) {
        require_once WPAPPS_SF_PLUGIN_DIR . 'includes/class-searchable-parent-dropdowns.php';
        new Searchable_Parent_Dropdowns();
    }
}

// Activation and deactivation hooks
register_activation_hook(__FILE__, 'wpapps_searchable_fields_activate');
register_deactivation_hook(__FILE__, 'wpapps_searchable_fields_deactivate');

/**
 * Plugin activation
 */
function wpapps_searchable_fields_activate() {
    $activated = get_option('wpapps_sf_activated');
    if ($activated != 1) {
        update_option('wpapps_sf_activated', 1);
        $selectors = array();
        
        $default_options = array(
            array(
                'selector' => '#parent_id, #inspector-select-control-1, #post_parent',
                'label'    => esc_html__('Parent Page', 'searchable-parent-dropdowns'),
                'id'       => 'parent_page'
            ),
            array(
                'selector' => '#addtag #parent, #edittag #parent',
                'label'    => esc_html__('Parent Category', 'searchable-parent-dropdowns'),
                'id'       => 'parent_category'
            ),
        );
        
        foreach ($default_options as $option) {
            $selectors[] = $option['selector'];
        }
        
        if (!empty($selectors)) {
            $enabled_for = implode(', ', $selectors);
            update_option('wpapps_sf_enabled_for', $enabled_for);
        }
    }
}

/**
 * Plugin deactivation
 */
function wpapps_searchable_fields_deactivate() {
    // Clean up any scheduled events if needed
}

// Add settings link to plugins page
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'wpapps_searchable_fields_settings_link');

/**
 * Add settings link to plugin actions
 *
 * @param array $links Plugin action links
 * @return array Modified plugin action links
 */
function wpapps_searchable_fields_settings_link($links) {
    $settings_link = sprintf(
        '<a href="%s">%s</a>',
        esc_url(admin_url('admin.php?page=searchable-parent-dropdowns')),
        esc_html__('Settings', 'searchable-parent-dropdowns')
    );
    array_unshift($links, $settings_link);
    return $links;
}


