/**
 * Searchable Fields Admin JavaScript
 */
(function($) {
    'use strict';

    // Wait for the document to be ready
    $(document).ready(function() {
        // Initialize searchable fields after a short delay to ensure all elements are loaded
        setTimeout(initSearchableFields, 100);

        // Re-initialize when quick edit is used
        $(document).on('click', '.editinline', function() {
            setTimeout(initSearchableFields, 300);
        });
    });

    /**
     * Initialize searchable fields
     */
    function initSearchableFields() {
        // Check if settings exist
        if (typeof wpappsSfSettings === 'undefined' || !wpappsSfSettings.selectors) {
            return;
        }

        try {
            // Convert the comma-separated string of selectors to an array
            const selectors = wpappsSfSettings.selectors.split(',').map(s => s.trim());
            
            // Initialize each selector
            selectors.forEach(selector => {
                if (!selector) return;
                
                // Find all matching elements
                const $elements = $(selector);
                
                if ($elements.length) {
                    $elements.each(function() {
                        const $select = $(this);
                        
                        // Only initialize if not already a Select2 instance
                        if (!$select.hasClass('select2-hidden-accessible')) {
                            $select.select2({
                                width: '100%',
                                placeholder: wpappsSfSettings.i18n.searchPlaceholder || 'Search...',
                                allowClear: true,
                                language: {
                                    noResults: function() {
                                        return wpappsSfSettings.i18n.noResults || 'No results found';
                                    }
                                },
                                dropdownParent: $select.parent()
                            });

                            // Add a small delay to ensure proper rendering in modals/dialogs
                            if ($select.closest('.media-modal, .thickbox-loading').length) {
                                $(window).on('thickbox:loaded', function() {
                                    $select.select2('close');
                                    $select.select2('open');
                                });
                            }
                        }
                    });
                }
            });
        } catch (error) {
            console.error('Searchable Fields Error:', error);
        }
    }

    // Re-initialize when Gutenberg editor is ready
    if (typeof wp !== 'undefined' && wp.data && wp.data.subscribe) {
        let isEditorReady = false;
        
        wp.data.subscribe(function() {
            if (!isEditorReady && wp.data.select('core/editor')) {
                isEditorReady = true;
                setTimeout(initSearchableFields, 1000);
            }
        });
    }

    // Handle AJAX-loaded content (e.g., in customizer, meta boxes, etc.)
    $(document).ajaxComplete(function() {
        setTimeout(initSearchableFields, 100);
    });

})(jQuery);
