<?php
/**
 * Handle admin actions for Search Anything Anywhere plugin.
 */

class Search_Anything_Anywhere_Actions {

	/**
	 * Register hooks.
	 */
	public static function register() {
		add_action( 'wp_ajax_search_anything_anywhere_clear_term_cache', array( __CLASS__, 'handle_clear_term_cache_ajax' ) );
		add_action( 'admin_post_search_anything_anywhere_clear_term_cache', array( __CLASS__, 'handle_clear_term_cache' ) );
	}

	/**
	 * Handle AJAX request to clear term counts cache.
	 */
	public static function handle_clear_term_cache_ajax() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_send_json_error( array( 'message' => __( 'Permission denied.', 'search-anything-anywhere' ) ) );
		}

		if ( ! check_ajax_referer( 'search_anything_anywhere_clear_term_cache', 'nonce', false ) ) {
			wp_send_json_error( array( 'message' => __( 'Nonce verification failed.', 'search-anything-anywhere' ) ) );
		}

		( new Search_Anything_Anywhere_Cache() )->clear_term_counts_transients();
		Search_Anything_Anywhere::debug_log( 'term_counts', 'Manual cache clear via AJAX' );

		wp_send_json_success( array( 'message' => __( 'Term counts cache cleared successfully.', 'search-anything-anywhere' ) ) );
	}

	/**
	 * Handle admin post request to clear term counts cache (fallback).
	 */
	public static function handle_clear_term_cache() {
		if ( ! current_user_can( 'manage_options' ) ) {
			wp_die( esc_html__( 'You do not have sufficient permissions to perform this action.', 'search-anything-anywhere' ) );
		}

		if ( isset( $_POST['submit'] ) && check_admin_referer( 'search_anything_anywhere_clear_term_cache', 'search_anything_anywhere_clear_term_cache_nonce' ) ) {
			( new Search_Anything_Anywhere_Cache() )->clear_term_counts_transients();
			Search_Anything_Anywhere::debug_log( 'term_counts', 'Manual cache clear via admin post' );
			add_settings_error(
				'search_anything_anywhere_general_options',
				'cache_cleared',
				__( 'Term counts cache cleared successfully.', 'search-anything-anywhere' ),
				'success'
			);
		} else {
			add_settings_error(
				'search_anything_anywhere_general_options',
				'nonce_failed',
				__( 'Nonce verification failed.', 'search-anything-anywhere' ),
				'error'
			);
		}

		$redirect_url = add_query_arg(
			array(
				'page'             => 'search_anything_anywhere_general',
				'settings-updated' => 'true',
			),
			admin_url( 'options-general.php' )
		);
		wp_safe_redirect( $redirect_url );
		exit;
	}
}
