jQuery(document).ready(function ($) {
  const $priorityList = $('#taxonomy-priority-list');
  const $priorityField = $('#taxonomy-priority-field');

  if (
    typeof window.searchAnythingAnywhereTaxonomies === 'undefined' ||
    !window.searchAnythingAnywhereTaxonomies.ajax_url
  ) {
    return;
  }

  /**
   * Debug logging function
   * @param {string} level - Log level: 'log', 'info', 'warn'
   * This function checks if debug mode is enabled and logs messages to the console
   * with a prefix. It supports different log levels for better categorization.
   * If debug mode is not enabled, it does nothing.
   * @param {...any} args
   */
  function debugLog(level, ...args) {
    if (!window.searchAnythingAnywhereTaxonomies.debug) return;
    const prefix = 'Search Anything Anywhere: ';
    switch (level) {
      case 'warn':
        // eslint-disable-next-line no-console
        console.warn(prefix, ...args);
        break;
      case 'info':
        // eslint-disable-next-line no-console
        console.info(prefix, ...args);
        break;
      case 'log':
      default:
        // eslint-disable-next-line no-console
        console.log(prefix, ...args);
    }
  }

  if ($priorityList.length) {
    $priorityList
      .sortable({
        update: function () {
          const order = $(this).sortable('toArray', {
            attribute: 'data-taxonomy'
          });
          $priorityField.val(JSON.stringify(order));
          debugLog('log', 'Updated taxonomy_priority:', order);
        }
      })
      .disableSelection();

    // Reorder list based on saved priority
    const savedPriority = $priorityField.val();
    debugLog('log', 'Saved priority on load:', savedPriority);
    if (savedPriority) {
      try {
        const priorityOrder = JSON.parse(savedPriority);
        debugLog('log', 'Parsed priority order:', priorityOrder);
        if (Array.isArray(priorityOrder) && priorityOrder.length > 0) {
          const $items = $priorityList.children('li').get();
          debugLog(
            'log',
            'Items before reorder:',
            $items.map((item) => $(item).data('taxonomy'))
          );
          $priorityList.empty();
          priorityOrder.forEach((taxonomy) => {
            const $item = $items.find(
              (item) => $(item).data('taxonomy') === taxonomy
            );
            if ($item) {
              $priorityList.append($item);
              debugLog('log', 'Appended to list:', taxonomy);
            } else {
              debugLog('warn', 'Taxonomy not found in list:', taxonomy);
            }
          });
          $items.forEach((item) => {
            const $item = $(item);
            if (!priorityOrder.includes($item.data('taxonomy'))) {
              $priorityList.append($item);
              debugLog('log', 'Appended remaining:', $item.data('taxonomy'));
            }
          });
        } else {
          debugLog('log', 'No priority order to apply');
        }
      } catch (e) {
        debugLog('warn', 'Failed to parse saved priority:', e);
      }
    } else {
      debugLog('log', 'No saved priority value found');
    }

    $('form').on('submit', function () {
      const order = $priorityList.sortable('toArray', {
        attribute: 'data-taxonomy'
      });
      $priorityField.val(JSON.stringify(order));
      debugLog('log', 'Form submitted with taxonomy_priority:', order);
    });
  } else {
    debugLog('log', 'Taxonomy priority list not found');
  }
});
