/* eslint-disable no-console */
jQuery(document).ready(function ($) {
  $('#search-anything-anywhere-clear-term-cache').on('click', function (e) {
    e.preventDefault();
    const button = $(this);
    const nonce = button.data('nonce');
    const status = $('#search-anything-anywhere-clear-term-cache-status');

    button.prop('disabled', true);
    status.text('Clearing cache...');

    if (
      typeof window.searchAnythingAnywhereOptions === 'undefined' ||
      !window.searchAnythingAnywhereOptions.ajax_url
    ) {
      return;
    }

    $.ajax({
      url: window.searchAnythingAnywhereOptions.ajax_url,
      type: 'POST',
      data: {
        action: 'search_anything_anywhere_clear_term_cache',
        nonce: nonce
      },
      success: function (response) {
        if (response.success) {
          status.text(response.data.message).css('color', 'green');
          if (window.searchAnythingAnywhereOptions.debug) {
            console.log('Cache cleared successfully:', response.data);
          }
        } else {
          status.text(response.data.message).css('color', 'red');
          if (window.searchAnythingAnywhereOptions.debug) {
            console.error('Error clearing cache:', response.data);
          }
        }
      },
      error: function () {
        status.text('Error clearing cache.').css('color', 'red');
        if (window.searchAnythingAnywhereOptions.debug) {
          console.error('AJAX request failed to clear cache.');
        }
      },
      complete: function () {
        button.prop('disabled', false);
        if (window.searchAnythingAnywhereOptions.debug) {
          console.log('Clear cache button re-enabled.');
        }
      }
    });
  });
});
