/* eslint-disable no-console */
jQuery(document).ready(function ($) {
  // Handle activation notice dismissal
  $('#search-anything-anywhere-activation-notice').on(
    'click',
    '.notice-dismiss',
    function () {
      $.ajax({
        url: window.searchAnythingAnywhereNotice.ajax_url,
        type: 'POST',
        data: {
          action: 'search_anything_anywhere_dismiss_activation_notice',
          nonce: window.searchAnythingAnywhereNotice.activation_nonce
        },
        success: function () {
          if (window.searchAnythingAnywhereNotice.debug) {
            console.log(
              'Search Anything Anywhere [admin]: Activation notice dismissed'
            );
          }
        },
        error: function (xhr) {
          if (window.searchAnythingAnywhereNotice.debug) {
            console.log(
              'Search Anything Anywhere [admin]: Error dismissing activation notice',
              xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'
            );
          }
        }
      });
    }
  );

  // Handle permalink notice dismissal
  $('#search-anything-anywhere-permalink-notice').on(
    'click',
    '.notice-dismiss',
    function () {
      $.ajax({
        url: window.searchAnythingAnywhereNotice.ajax_url,
        type: 'POST',
        data: {
          action: 'search_anything_anywhere_dismiss_permalink_notice',
          nonce: window.searchAnythingAnywhereNotice.permalink_nonce
        },
        success: function (response) {
          // Check if the response indicates an error
          if (response && response.success === false) {
            if (window.searchAnythingAnywhereNotice.debug) {
              console.log(
                'Search Anything Anywhere [admin]: Error dismissing permalink notice',
                response.data && response.data.message
                  ? response.data.message
                  : 'Unknown error'
              );
            }
            alert(
              'Error: ' +
                (response.data && response.data.message
                  ? response.data.message
                  : 'Unknown error. Please check your .htaccess file and try again.')
            );
          } else {
            if (window.searchAnythingAnywhereNotice.debug) {
              console.log(
                'Search Anything Anywhere [admin]: Permalink notice dismissed'
              );
            }
          }
        },
        error: function (xhr) {
          if (window.searchAnythingAnywhereNotice.debug) {
            console.log(
              'Search Anything Anywhere [admin]: Error dismissing permalink notice',
              xhr.responseJSON ? xhr.responseJSON.message : 'Unknown error'
            );
          }
          alert(
            'Error: ' +
              (xhr.responseJSON
                ? xhr.responseJSON.message
                : 'Unknown error. Please check your .htaccess file and try again.')
          );
        }
      });
    }
  );
});
