<?php

/**
 * Extend WordPress search to include taxonomies
 *
 * @package Search_Anything_Anywhere
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Search_Anything_Anywhere_Taxonomy_Search {

	/**
	 * Constructor.
	 */
	public function __construct() {
		/** @var array<string,bool> */
		$general_options = get_option(
			'search_anything_anywhere_general_options',
			( new Search_Anything_Anywhere_General() )->get_default_options()
		);
		if ( ! empty( $general_options['search_taxonomies'] ) ) {
			add_filter( 'posts_search', array( $this, 'taxonomy_search' ), 500, 2 );
		}
	}

	/**
	 * Modify the search query to include taxonomy terms.
	 *
	 * @param string $search The search SQL.
	 * @param WP_Query $wp_query The WP_Query instance.
	 * @return string Modified search SQL.
	 */
	public function taxonomy_search( $search, $wp_query ) {
		global $wpdb;

		if ( empty( $search ) || ! is_search() || ! is_main_query() ) {
			return $search;
		}

		$terms    = $wp_query->query_vars['s'];
		$exploded = explode( ' ', $terms );
		if ( empty( $exploded ) ) {
			$exploded = array( $terms );
		}

		$search = '';
		foreach ( $exploded as $tag ) {
			$tag     = $wpdb->esc_like( $tag );
			$search .= " AND (
                ({$wpdb->posts}.post_title LIKE '%{$tag}%')
                OR ({$wpdb->posts}.post_content LIKE '%{$tag}%')
                OR EXISTS (
                    SELECT 1
                    FROM {$wpdb->term_relationships}
                    LEFT JOIN {$wpdb->terms}
                    ON {$wpdb->term_relationships}.term_taxonomy_id = {$wpdb->terms}.term_id
                    WHERE {$wpdb->terms}.name LIKE '%{$tag}%'
                    AND {$wpdb->term_relationships}.object_id = {$wpdb->posts}.ID
                )
            )";
		}

		return $search;
	}
}
