<?php

/**
 * Filter search results to hide posts without featured images
 *
 * @package Search_Anything_Anywhere
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Search_Anything_Anywhere_Results_Filter {

	/**
	 * Constructor.
	 */
	public function __construct() {
		/** @var array<string,bool> */
		$general_options = get_option(
			'search_anything_anywhere_general_options',
			( new Search_Anything_Anywhere_General() )->get_default_options()
		);

		if ( ! empty( $general_options['exclude_no_featured_image'] ) ) {
			add_action( 'pre_get_posts', array( $this, 'filter_search_results' ) );
		}
	}

	/**
	 * Filter search results to exclude posts without featured images.
	 *
	 * @param WP_Query $query The current query object.
	 */
	public function filter_search_results( $query ) {
		// Only modify public-facing queries that are main query
		if ( is_admin() || ! $query->is_main_query() ) {
			return;
		}

		// Apply filter to search results
		if ( $query->is_search() ) {
			$query->set(
				'meta_query',
				array(
					array(
						'key'     => '_thumbnail_id',
						'compare' => 'EXISTS',
					),
				)
			);
		}
	}
}
