<?php

/**
 * Enqueue assets for Search Anything Anywhere
 *
 * @package Search_Anything_Anywhere
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Search_Anything_Anywhere_Assets {

	/**
	 * Enqueue assets for the plugin.
	 */
	public function enqueue() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_assets' ) );
	}

	/**
	 * Enqueue styles and scripts for the plugin.
	 */
	public function enqueue_assets() {
		// Enqueue styles
		wp_enqueue_style(
			'search-anything-anywhere-style',
			SEARCH_ANYTHING_ANYWHERE_URI . 'assets/css/style.css',
			array(),
			SEARCH_ANYTHING_ANYWHERE_VERSION
		);

		// Enqueue scripts
		wp_enqueue_script(
			'search-anything-anywhere-script',
			plugins_url( 'build/search-anything-anywhere.js', dirname( __DIR__, 1 ) ),
			array( 'jquery', 'select2' ),
			SEARCH_ANYTHING_ANYWHERE_VERSION,
			true
		);

		// Localize settings
		wp_localize_script(
			'search-anything-anywhere-script',
			'searchAnythingAnywhereAjax',
			array(
				'home_url'             => home_url( '/' ),
				'enable_friendly_urls' => ! empty( get_option( 'search_anything_anywhere_general_options', array( 'enable_friendly_urls' => false ) )['enable_friendly_urls'] ),
			)
		);

		// Enqueue Select2 CSS
		wp_enqueue_style(
			'select2',
			SEARCH_ANYTHING_ANYWHERE_URI . 'assets/css/select2.min.css',
			array(),
			SEARCH_ANYTHING_ANYWHERE_VERSION
		);

		// Enqueue Select2 JS
		wp_enqueue_script(
			'select2',
			SEARCH_ANYTHING_ANYWHERE_URI . 'assets/js/select2.min.js',
			array( 'jquery' ),
			SEARCH_ANYTHING_ANYWHERE_VERSION,
			true
		);
	}
}
