<?php

/**
 * Extend WordPress search to include custom fields
 *
 * https://adambalee.com/search-wordpress-by-custom-fields-without-a-plugin/
 *
 * @package Search_Anything_Anywhere
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Search_Anything_Anywhere_ACF_Search {

	/**
	 * Constructor.
	 */
	public function __construct() {
		/** @var array<string,bool> */
		$general_options = get_option(
			'search_anything_anywhere_general_options',
			( new Search_Anything_Anywhere_General() )->get_default_options()
		);

		if ( ! empty( $general_options['search_acf'] ) ) {
			add_filter( 'posts_join', array( $this, 'search_join' ), 10, 2 );
			add_filter( 'posts_where', array( $this, 'search_where' ), 10, 2 );
			add_filter( 'posts_distinct', array( $this, 'search_distinct' ), 10 );
		}
	}

	/**
	 * Join posts and postmeta tables
	 */
	public function search_join( $join ) {
		global $wpdb;

		if ( is_search() && is_main_query() ) {
			$join .= ' LEFT JOIN ' . $wpdb->postmeta . ' ADDITIONAL_META ON ' . $wpdb->posts . '.ID = ADDITIONAL_META.post_id ';
		}

		return $join;
	}

	/**
	 * Modify the search query with posts_where
	 */
	public function search_where( $where ) {
		global $wpdb;

		if ( is_search() && is_main_query() ) {
			$where = preg_replace(
				'/\(\s*' . $wpdb->posts . ".post_title\s+LIKE\s*(\'[^\']+\')\s*\)/",
				'(' . $wpdb->posts . '.post_title LIKE $1) OR (ADDITIONAL_META.meta_value LIKE $1)',
				$where
			);
		}

		return $where;
	}

	/**
	 * Prevent duplicates
	 */
	public function search_distinct( $where ) {
		if ( is_search() && is_main_query() ) {
			return 'DISTINCT';
		}

		return $where;
	}
}
