<?php
/**
 * Main Search Anything Anywhere plugin class.
 */
class Search_Anything_Anywhere {
	/**
	 * Log a debug message if debug logging is enabled.
	 *
	 * @param string $scope   The scope or context of the log (e.g., 'init', 'render').
	 * @param string $message The debug message to log.
	 * @return void
	 */
	public static function debug_log( string $scope, string $message ): void {
		$miscellaneous_options = get_option( 'search_anything_anywhere_miscellaneous_options', array() );
        // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_error_log -- Debug logging is conditionally enabled and safe for production.
		if ( ! empty( $miscellaneous_options['enable_debug_logging'] ) && defined( 'WP_DEBUG' ) && WP_DEBUG && defined( 'WP_DEBUG_LOG' ) && WP_DEBUG_LOG ) {
			error_log( "Search Anything Anywhere [$scope]: $message" );
		}
	}
}
