<?php
/**
 * CLI commands for Search Anything Anywhere plugin.
 *
 * @package Search_Anything_Anywhere
 */
if ( defined( 'WP_CLI' ) && WP_CLI ) {
	class Search_Anything_Anywhere_CLI extends WP_CLI_Command {
		/**
		 * Clears the Search Anything Anywhere term counts cache.
		 *
		 * ## EXAMPLES
		 *
		 *     wp search-anything-anywhere clear-term-cache
		 *
		 * @when after_wp_load
		 */
		public function clear_term_cache() {
			( new Search_Anything_Anywhere_Cache() )->clear_term_counts_transients();
			WP_CLI::success( 'Search Anything Anywhere term counts cache cleared successfully.' );
		}
	}

	WP_CLI::add_command( 'search_anything_anywhere', 'Search_Anything_Anywhere_CLI' );
}
