<?php
/**
 * Template for the Search Anything Anywhere search block
 *
 * @package Search_Anything_Anywhere
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

Search_Anything_Anywhere::debug_log( 'render', 'Rendering search block template' );
?>
<div class="search-anything-anywhere-search-form">
	<form role="search" method="get" action="<?php echo esc_url( $form_action ); ?>" class="search-anything-anywhere-search">
		<input type="search" name="s" placeholder="<?php echo esc_attr( $placeholder ); ?>" value="<?php echo get_search_query() !== 'any' ? esc_attr( get_search_query() ) : ''; ?>" />
		<?php if ( 1 === count( $current_post_types ) && 'any' !== $current_post_types[0] ) : ?>
			<input type="hidden" name="post_type" value="<?php echo esc_attr( $current_post_types[0] ); ?>" />
		<?php endif; ?>
		<?php if ( ! empty( $general_options['show_taxonomy_filters'] ) && ! empty( $allowed_taxonomies ) ) : ?>
			<?php foreach ( $allowed_taxonomies as $taxonomy => $enabled ) : ?>
				<?php
				if ( $enabled && ! empty( $term_counts[ $taxonomy ] ) ) :
					$taxonomy_obj = get_taxonomy( $taxonomy );
					// Fetch only terms with non-zero counts
					$terms = get_terms(
						array(
							'taxonomy'   => $taxonomy,
							'hide_empty' => true,
							'slug'       => array_keys( $term_counts[ $taxonomy ] ),
							'orderby'    => $display_options['taxonomy_filter_sort'],
							'order'      => 'count' === $display_options['taxonomy_filter_sort'] ? 'DESC' : 'ASC',
						)
					);
					if ( is_wp_error( $terms ) ) :
						Search_Anything_Anywhere::debug_log( 'render', "Error fetching terms for taxonomy '$taxonomy': " . $terms->get_error_message() );
						continue;
					endif;
					// phpcs:disable
					?>
					<select name="taxonomy_<?php echo esc_attr( $taxonomy ); ?>[]" multiple class="search-anything-anywhere-select2"
						data-placeholder="<?php
						// translators: %s is the taxonomy singular name
						echo esc_attr( sprintf( __( 'Search %s', 'search-anything-anywhere' ), $taxonomy_obj->labels->singular_name ) );
						?>">
						<option value=""><?php echo esc_html( sprintf( 'Select %s', $taxonomy_obj->labels->singular_name ) ); ?></option>
						<?php
						// phpcs:enable
						$selected_terms_list   = array();
						$unselected_terms_list = array();
						foreach ( $terms as $term ) {
							$is_selected = false;
							if ( ! empty( $general_options['enable_friendly_urls'] ) && isset( $selected_terms[ $taxonomy ] ) && in_array( $term->slug, $selected_terms[ $taxonomy ], true ) ) {
								$is_selected = true;
							// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only check for pre-selecting form filters.
							} elseif ( isset( $_GET[ 'taxonomy_' . $taxonomy ] ) && in_array( $term->slug, (array) $_GET[ 'taxonomy_' . $taxonomy ], true ) ) {
								$is_selected = true;
							} elseif ( $current_taxonomy === $taxonomy && $current_term && $current_term->slug === $term->slug ) {
								$is_selected = true;
							}
							if ( $is_selected ) {
								$selected_terms_list[] = array(
									'term'        => $term,
									'is_selected' => true,
								);
							} else {
								$unselected_terms_list[] = array(
									'term'        => $term,
									'is_selected' => false,
								);
							}
						}
						$ordered_terms = array_merge( $selected_terms_list, $unselected_terms_list );
						foreach ( $ordered_terms as $item ) :
							$term        = $item['term'];
							$is_selected = $item['is_selected'];
							?>
							<option value="<?php echo esc_attr( $term->slug ); ?>" <?php selected( $is_selected ); ?>>
								<?php
								$term_label = esc_html( $term->name );
								if ( ! empty( $display_options['show_term_counts'] ) && isset( $term_counts[ $taxonomy ][ $term->slug ] ) ) {
									$term_label .= ' (' . $term_counts[ $taxonomy ][ $term->slug ] . ')';
								}
								echo wp_kses_post( $term_label );
								?>
							</option>
						<?php endforeach; ?>
					</select>
					<?php
					Search_Anything_Anywhere::debug_log( 'render', "Rendered taxonomy dropdown for '$taxonomy'" );
					?>
				<?php else : ?>
					<?php
					Search_Anything_Anywhere::debug_log( 'render', "Skipped taxonomy '$taxonomy': no non-empty terms" );
					?>
				<?php endif; ?>
			<?php endforeach; ?>
		<?php endif; ?>
		<button type="submit"><?php esc_html_e( 'Search', 'search-anything-anywhere' ); ?></button>
		<button type="button" class="search-anything-anywhere-reset"><?php esc_html_e( 'Reset', 'search-anything-anywhere' ); ?></button>
	</form>
</div>
