jQuery(function ($) {
  /**
   * Initialize Select2 for Search Anything Anywhere filters.
   * This function applies Select2 to all elements with the class 'search-anything-anywhere-select2'.
   * It sets a placeholder from the data attribute, prevents dropdown from opening on unselect,
   * and handles the opening event to block it if triggered by an unselect action.
   */
  function initSelect2() {
    $('.search-anything-anywhere-select2').each(function () {
      $(this)
        .select2({
          placeholder: $(this).data('placeholder'),
          allowClear: false,
          width: '10%'
        })
        .on('select2:unselecting', function () {
          // Prevent dropdown from opening on clear
          $(this).data('unselecting', true);
        })
        .on('select2:open', function (e) {
          // Block open if triggered by unselect
          if ($(this).data('unselecting')) {
            e.preventDefault();
            $(this).data('unselecting', false);
            $(this).select2('close');
          }
        });
    });
  }
  initSelect2();

  // Handle reset button
  $('.search-anything-anywhere-reset').on('click', function () {
    const $form = $(this).closest('form');
    $form.find('input[name="s"]').val('');
    $form.find('.search-anything-anywhere-select2').val(null).trigger('change');

    if (
      typeof window.searchAnythingAnywhereAjax === 'undefined' ||
      !window.searchAnythingAnywhereAjax.home_url
    ) {
      return;
    }

    // Redirect to base URL
    let baseUrl = window.location.pathname;
    const postType = $form.find('input[name="post_type"]').val() || 'any';
    if (baseUrl.match(/\/search\/.*/)) {
      if (postType === 'post' || postType === 'any') {
        baseUrl = window.searchAnythingAnywhereAjax.home_url;
      } else {
        baseUrl = window.searchAnythingAnywhereAjax.home_url + postType + '/';
      }
    }
    window.location.assign(baseUrl);
  });

  // Handle form submission for friendly URLs
  $(
    '.search-anything-anywhere-search-form form.search-anything-anywhere-search'
  ).on('submit', function (e) {
    if (
      typeof window.searchAnythingAnywhereAjax === 'undefined' ||
      !window.searchAnythingAnywhereAjax.home_url
    ) {
      return;
    }

    if (window.searchAnythingAnywhereAjax.enable_friendly_urls) {
      e.preventDefault();
      const $form = $(this);
      const searchTerm = $form.find('input[name="s"]').val().trim() || 'any';
      let taxonomies = [];
      $form.find('.search-anything-anywhere-select2').each(function () {
        const $select = $(this);
        const values = $select.val() || [];
        taxonomies = taxonomies.concat(values);
      });
      const taxUrl = taxonomies.length ? '/' + taxonomies.join('+') : '';
      const postType = $form.find('input[name="post_type"]').val() || 'any';
      const newUrl =
        window.searchAnythingAnywhereAjax.home_url +
        'search/' +
        encodeURIComponent(searchTerm) +
        '/' +
        encodeURIComponent(postType) +
        taxUrl;
      window.location.assign(newUrl);
    }
  });
});
