/* eslint-disable no-unused-vars */
import { __ } from '@wordpress/i18n';
import { addFilter } from '@wordpress/hooks';
import { registerBlockType, createBlock } from '@wordpress/blocks';
import { TextControl, Button, Notice } from '@wordpress/components';

const { replaceCoreSearch } = window.searchAnythingAnywhereSettings || {
  replaceCoreSearch: false
};

if (replaceCoreSearch) {
  // Add transformation from core/search to search-anything-anywhere/search-form
  addFilter(
    'blocks.registerBlockType',
    'search-anything-anywhere/replace-core-search',
    (settings, name) => {
      if (name !== 'core/search') {
        return settings;
      }

      return {
        ...settings,
        transforms: {
          ...settings.transforms,
          to: [
            ...(settings.transforms?.to || []),
            {
              type: 'block',
              blocks: ['search-anything-anywhere/search-form'],
              transform: (attributes) => {
                return createBlock('search-anything-anywhere/search-form', {
                  placeholder: attributes.placeholder || '',
                  align: attributes.align || undefined
                });
              }
            }
          ]
        }
      };
    }
  );

  // Automatically transform core/search to search-anything-anywhere/search-form on insert
  wp.domReady(() => {
    wp.blocks.registerBlockVariation('core/search', {
      name: 'search-anything-anywhere-search-replacement',
      title: __('Search Anything Anywhere', 'search_anything_anywhere'),
      isDefault: true,
      attributes: {},
      isActive: () => true,
      scope: ['inserter', 'block', 'transform'],
      transforms: {
        to: [
          {
            type: 'block',
            blocks: ['search-anything-anywhere/search-form'],
            transform: (attributes) => {
              return createBlock('search-anything-anywhere/search-form', {
                placeholder: attributes.placeholder || '',
                align: attributes.align || undefined
              });
            }
          }
        ]
      }
    });
  });
}

registerBlockType('search-anything-anywhere/search-form', {
  title: __('Search Anything Anywhere', 'search_anything_anywhere'),
  description: __(
    'A search form block with optional taxonomy filters.',
    'search_anything_anywhere'
  ),
  category: 'widgets',
  icon: 'search',
  attributes: {
    placeholder: {
      type: 'string',
      default: 'Search...'
    }
  },
  edit: ({ attributes, setAttributes }) => {
    return (
      <div
        className="search-anything-anywhere-search-form"
        style={{
          display: 'flex',
          flexDirection: 'column',
          gap: '10px',
          alignItems: 'center',
          margin: '0 auto',
          flexWrap: 'wrap'
        }}
      >
        <Notice status="info" isDismissible={false}>
          {__(
            'Form rendered on front end with Search Anything Anywhere settings (e.g., taxonomy filters).',
            'search_anything_anywhere'
          )}
        </Notice>
        <div
          style={{
            display: 'flex',
            gap: '10px',
            alignItems: 'center'
          }}
        >
          <TextControl
            value={attributes.placeholder}
            onChange={(value) => setAttributes({ placeholder: value })}
            placeholder={__(
              'Enter placeholder text...',
              'search_anything_anywhere'
            )}
          />
          <Button
            style={{
              border: '1px solid #767676'
            }}
          >
            {__('Search', 'search_anything_anywhere')}
          </Button>
          <Button
            style={{
              border: '1px solid #767676'
            }}
          >
            {__('Reset', 'search_anything_anywhere')}
          </Button>
        </div>
      </div>
    );
  },
  save: () => {
    // Rendered on the server via PHP
    return null;
  }
});
