<?php

/**
 * Helper class to check and create tabs.
 * copyright Simple Direct Plugins - support@simpledirectplugins.com
 *
 * @author 			Simple Direct Plugins
 * @link			https://simpledirectplugins.com/
 * @since			1.0.0
 * @package			SMATWoo
 *
 */

if (!class_exists ('SMAT_Tab')) :

	Class SMAT_Tab {

        public $id;

		public static function create ($tab, $title, $order) {

            $instance     = new self();
            $instance->id = $instance->check_or_create_tab($tab, $title, $order);

            return $instance;
            }

        protected function check_or_create_tab ($tab, $title, $order) {

            $tab_id = false;

			$args = [
				'post_title'	=> $title,
				'post_type'		=> SMAT_CPT::CPT,
				'post_content'	=> '',
				'post_status'	=> 'publish',
				'post_name'		=> 'smat-core-' . $tab,
				'menu_order'	=> $order,
				'meta_input'	=> [
					'smat_active' 			=> 1,
					'smat_is_core' 			=> 1,
					'smat_core_endpoint'	=> $tab],
				];

			// Si existe pero no está publicada, la publicamos.
			if ($tab_id = $this->tab_exists('smat-core-' . $tab)) {

				$post = get_post ($tab_id);

				if ($post && 'publish' !== $post->post_status)
					wp_update_post (
						[
							'ID'			=> $tab_id,
							'post_status'	=> 'publish',
							]
						);
				}

            if (!$tab_id) {

                // Si está en la papelera, la sacamos de ahí y la republicamos.
                $args_trashed = [
                    'name'				=> 'smat-core-' . $tab . '__trashed',
                    'post_type'			=> SMAT_CPT::CPT,
                    'post_status'		=> 'trash',
                    'posts_per_page'	=> 1,
                    ];

                if ($trashed_posts = get_posts ($args_trashed)) {

                    $trashed_id = $trashed_posts[0]->ID;
                    wp_untrash_post ($trashed_id);
                    wp_update_post (
                        [
                            'ID' 			=> $trashed_id,
                            'post_status'	=> 'publish',
                            ]
                        );
                        
                    $tab_id = $trashed_id;
                    }
                }

			// Si no existe, la creamos.
            $tab_id or $tab_id = is_int ($new_tab_id = wp_insert_post ($args, false)) ? $new_tab_id : false;
            $tab_id and $this->save_tab_id($tab_id);

			return $tab_id;
			}

		protected function tab_exists ($slug) {

			$tab = null;

			if ($posts = get_posts (
				[
					'name'				=> $slug,
					'post_type'			=> SMAT_CPT::CPT,
					'post_status'		=> array_keys (get_post_stati()),
					'posts_per_page'	=> 1,
					]
				)) $tab = $posts[0];

			return is_null ($tab) ? false : $tab->ID;
			}

        protected function save_tab_id ($tab_id) {

            $core = get_option ('smat_core_tabs') ?: [];

            if (in_array ($tab_id, $core, true))
                return;

            else
                $core[] = $tab_id;
            
            // Eliminamos las que hayan quedado de alguna activación anterior si ya no existen.
			$core = array_filter ($core, function ($id) {
				return get_post_status ($id) !== false;
				});

			count ($core = array_unique ($core)) and
				update_option ('smat_core_tabs', $core);
            }

		}

endif;