<?php

/**
 * Custom fields.
 * copyright Simple Direct Plugins - support@simpledirectplugins.com
 *
 * @author 					Simple Direct Plugins
 * @link					https://simpledirectplugins.com/
 * @since					1.0.0
 * @package					SMATWoo
 *
 */

defined ('ABSPATH') or exit;

if (!class_exists ('SMAT_Fields')) :

	Class SMAT_Fields {

		public function __construct () {

			//Si no se puede cargar ACF da error y sale
			if (!function_exists ('acf_add_local_field_group') && !function_exists ('register_field_group')) {

				add_action ('admin_notices', [$this, 'error_acf'], 10);
				return;
				}

			$this->inserta_campos();

			add_filter ('acf/settings/remove_wp_meta_box', '__return_false');
			}

		public function error_acf () {

			echo '<div class="notice notice-error is-dismissible"><p>';
			/* translators: the name of the plugin */
			$error = printf (esc_html__('%s couldn\'t retrieve the list of custom fields. Please contact support.', 'sdp-my-account-tabs-for-woocommerce'), '<i>SDP My Account Tabs for WooCommerce</i>');
			echo '</p></div>';
			}

		public function inserta_campos () {

			$fields = array_merge (
				$this->campos_tab_global(),
				$this->campos_tab_conditions(),
				$this->campos_tab_advanced(),
				);

			$campos = [
				'key'                   => 'group_sdp_my_account_tabs',
				'title'                 => esc_html__('Tab Settings', 'sdp-my-account-tabs-for-woocommerce'),
				'fields'                => $fields,
				'location'              => [
					[
						[
							'param'     => 'post_type',
							'operator'  => '==',
							'value'     => SMAT_CPT::CPT,
							],
						],
					],
				'menu_order'            => 0,
				'position'              => 'normal',
				'style'                 => 'default',
				'label_placement'       => 'top',
				'instruction_placement' => 'label',
				'hide_on_screen'        => [
					0  => 'permalink',
					1  => 'excerpt',
					2  => 'custom_fields',
					3  => 'discussion',
					4  => 'comments',
					5  => 'revisions',
					6  => 'slug',
					7  => 'author',
					8  => 'format',
					9  => 'page_attributes',
					10 => 'featured_image',
					11 => 'categories',
					12 => 'tags',
					13 => 'send-trackbacks',
					],
				'active'                => 1,
				'description'           => '',
				'show_in_rest' 			=> 0,
				'display_title'			=> '',
				];

			function_exists ('acf_add_local_field_group') ? acf_add_local_field_group ($campos) : register_field_group ($campos);
			}

		private function campos_tab_global () {

			// phpcs:ignore WordPress.Security.NonceVerification.Recommended
			$tab_id = isset ($_GET['post']) ? absint ($_GET['post']) : false;
			$dl_tab = ('downloads' === get_post_meta ($tab_id, 'smat_core_endpoint', true));

			$fields = [
				[// Tab Global.
					'key' 				=> 'field_smat_tab_global',
					'label' 			=> esc_html__('Global', 'sdp-my-account-tabs-for-woocommerce'),
					'name' 				=> '',
					'aria-label' 		=> '',
					'type' 				=> 'tab',
					'instructions' 		=> '',
					'required' 			=> 0,
					'conditional_logic' => 0,
					'wrapper' 			=> [
						'width' => '',
						'class' => '',
						'id' 	=> '',
						],
					'placement' => 'top',
					'endpoint' => 0,
					'selected' => 0,
					],
					
				[// Enable tab.
					'key' 					=> 'field_smat_active',
					'label' 				=> esc_html__('Enable tab', 'sdp-my-account-tabs-for-woocommerce'),
					'name' 					=> 'smat_active',
					'aria-label' 			=> '',
					'type' 					=> 'true_false',
					'instructions' 			=> '',
					'required' 				=> 0,
					'conditional_logic' 	=> 0,
					'wrapper' 				=> [
						'width' => '',
						'class' => '',
						'id' 	=> '',
						],
					'message' 				=> '',
					'default_value' 		=> 0,
					'allow_in_bindings' 	=> 0,
					'ui_on_text' 			=> '',
					'ui_off_text' 			=> '',
					'ui' 					=> 1,
					],
				]; 

			$dl_tab and $fields[] = [// Hide if no downloads.
				'key' 					=> 'field_smat_hide_dl',
				'label' 				=> esc_html__('Hide tab if user has no downloads (PRO)', 'sdp-my-account-tabs-for-woocommerce'),
				'name' 					=> 'smat_hide_dl',
				'aria-label' 			=> '',
				'type' 					=> 'true_false',
				'instructions' 			=> '',
				'required' 				=> 0,
				'conditional_logic' 	=> 0,
				'wrapper' 				=> [
					'width' => '',
					'class' => 'smat-disabled-field',
					'id' 	=> '',
					],
				'message' 				=> '',
				'default_value' 		=> 0,
				'allow_in_bindings' 	=> 0,
				'ui_on_text' 			=> '',
				'ui_off_text' 			=> '',
				'ui' 					=> 1,
				];

			$fields[] = [// Description.
				'key' 					=> 'field_smat_description',
				'label' 				=> esc_html__('Description', 'default'),
				'name' 					=> 'smat_description',
				'aria-label' 			=> '',
				'type' 					=> 'textarea',
				'instructions' 			=> esc_html__('Not visible to users. Use this field to leave internal comments or reminders.', 'sdp-my-account-tabs-for-woocommerce'),
				'required' 				=> 0,
				'conditional_logic' 	=> 0,
				'wrapper' 				=> [
					'width' => '',
					'class' => '',
					'id' 	=> '',
					],
				'default_value' 		=> '',
				'maxlength' 			=> '',
				'allow_in_bindings' 	=> 0,
				'rows' 					=> 4,
				'placeholder' 			=> '',
				'new_lines' 			=> 'br',
				];
				
			return $fields;
			}

		private function campos_tab_conditions () {

			return [
				[// Tab Visibility Conditions.
					'key' 					=> 'field_smat_tab_visibility',
					'label' 				=> esc_html__('Visibility Conditions', 'sdp-my-account-tabs-for-woocommerce') . ' <span class="smat-pro">pro</span>',
					'name' 					=> '',
					'aria-label'			=> '',
					'type' 					=> 'tab',
					'instructions' 			=> '',
					'required' 				=> 0,
					'conditional_logic' 	=> 0,
					'wrapper' 				=> [
						'width' => '',
						'class' => '',
						'id' 	=> '',
						],
					'placement' 			=> 'top',
					'endpoint' 				=> 0,
					'selected' 				=> 0,
					],

				[// Pro message.
					'key' 				=> 'field_smat_visibility_message',
					'label' 			=> '',
					'name' 				=> '',
					'type' 				=> 'message',
					'instructions' 		=> '',
					'required' 			=> 0,
					'conditional_logic' => 0,
					'wrapper' 			=> [
						'width' => '',
						'class' => 'smat-pro-message',
						'id' 	=> '',
						],
					/* translators: link to pro version */
					'message'		 	=> 'ℹ️ ' . sprintf (esc_html__('These are PRO features. Check out %1$sSDP My Account Tabs Pro%2$s to unlock them.', 'sdp-my-account-tabs-for-woocommerce'), '<a target="_blank" href="' . SMAT_PRO_LINK . '">', '</a>'),
					'new_lines'			=> 'wpautop',
					'esc_html'			=> 0,
					],

				[ // Specific users.
					'key' 					=> 'field_smat_users',
					'label' 				=> esc_html__('Specific Users', 'sdp-my-account-tabs-for-woocommerce'),
					'name' 					=> 'smat_users',
					'aria-label' 			=> '',
					'type' 					=> 'user',
					'instructions' 			=> esc_html__('Enter the usernames of users who should have access.', 'sdp-my-account-tabs-for-woocommerce'),
					'required' 				=> 0,
					'conditional_logic' 	=> 0,
					'wrapper' 				=> [
						'width' => '50',
						'class' => 'smat-disabled-field',
						'id' 	=> '',
						],
					'role' 					=> '',
					'return_format' 		=> 'id',
					'multiple' 				=> 1,
					'allow_null' 			=> 0,
					'allow_in_bindings' 	=> 0,
					'bidirectional' 		=> 0,
					'bidirectional_target' 	=> [],
					],

				[// User role.
					'key' 					=> 'field_smat_user_role',
					'label' 				=> esc_html__('User role', 'sdp-my-account-tabs-for-woocommerce'),
					'name' 					=> 'smat_user_role',
					'aria-label' 			=> '',
					'type' 					=> 'select',
					'instructions' 			=> esc_html__('Show this tab only to users with selected roles.', 'sdp-my-account-tabs-for-woocommerce'),
					'required' 				=> 0,
					'conditional_logic' 	=> 0,
					'wrapper' 				=> [
						'width' => '50',
						'class' => 'smat-disabled-field',
						'id' 	=> '',
						],
					'choices' 				=> [], //Deliberately empty.
					'default_value' 		=> [],
					'return_format' 		=> 'value',
					'multiple' 				=> 1,
					'allow_null' 			=> 0,
					'allow_in_bindings' 	=> 0,
					'ui' 					=> 1,
					'ajax' 					=> 1,
					'create_options' 		=> 0,
					'placeholder' 			=> '',
					'save_options' 			=> 0,
					],

				[// Purchased product.
					'key' 					=> 'field_smat_products',
					'label' 				=> esc_html__('Purchased Product', 'sdp-my-account-tabs-for-woocommerce'),
					'name' 					=> 'smat_products',
					'aria-label' 			=> '',
					'type' 					=> 'post_object',
					'instructions' 			=> esc_html__('Display this tab only to users who have purchased any of the selected products.', 'sdp-my-account-tabs-for-woocommerce'),
					'required' 				=> 0,
					'conditional_logic' 	=> 0,
					'wrapper' 				=> [
						'width' => '50',
						'class' => 'smat-disabled-field',
						'id' 	=> '',
						],
					'post_type' 			=> [0 => 'product'],
					'post_status' 			=> '',
					'taxonomy' 				=> '',
					'return_format' 		=> 'id',
					'multiple' 				=> 1,
					'allow_null' 			=> 0,
					'allow_in_bindings' 	=> 0,
					'bidirectional' 		=> 0,
					'ui' 					=> 1,
					'bidirectional_target' => [],
					],

				[// Memberships.
					'key' 					=> 'field_smat_membership',
					'label' 				=> esc_html__('Active Membership', 'sdp-my-account-tabs-for-woocommerce'),
					'name' 					=> 'smat_membership',
					'aria-label' 			=> '',
					'type' 					=> 'select',
					'instructions' 			=> esc_html__('Show this tab only to users with an active membership.', 'sdp-my-account-tabs-for-woocommerce'),
					'required' 				=> 0,
					'conditional_logic' 	=> 0,
					'wrapper' 				=> [
						'width' => '50',
						'class' => 'smat-disabled-field',
						'id' 	=> '',
						],
					'choices' 				=> [], //Deliverately empty.
					'default_value' 		=> [],
					'return_format' 		=> 'value',
					'multiple' 				=> 1,
					'allow_null' 			=> 0,
					'allow_in_bindings' 	=> 0,
					'ui' 					=> 1,
					'ajax' 					=> 1,
					'create_options' 		=> 0,
					'placeholder' 			=> '',
					'save_options' 			=> 0,
					],
				];
			}

		private function campos_tab_advanced () {

			return [
				[// Tab Advanced.
					'key' 				=> 'field_smat_tab_advanced',
					'label' 			=> esc_html__('Advanced', 'sdp-my-account-tabs-for-woocommerce') . ' <span class="smat-pro">pro</span>',
					'name' 				=> '',
					'aria-label' 		=> '',
					'type' 				=> 'tab',
					'instructions' 		=> '',
					'required' 			=> 0,
					'conditional_logic' => 0,
					'wrapper' 			=> [
						'width' => '',
						'class' => '',
						'id' 	=> '',
						],
					'placement' 		=> 'top',
					'endpoint' 			=> 0,
					'selected' 			=> 0,
					],

				[// Pro message.
					'key' 				=> 'field_smat_advanced_message',
					'label' 			=> '',
					'name' 				=> '',
					'type' 				=> 'message',
					'instructions' 		=> '',
					'required' 			=> 0,
					'conditional_logic' => 0,
					'wrapper' 			=> [
						'width' => '',
						'class' => 'smat-pro-message',
						'id' 	=> '',
						],
					/* translators: link to pro version */
					'message'		 	=> 'ℹ️ ' . sprintf (esc_html__('These are PRO features. Check out %1$sSDP My Account Tabs Pro%2$s to unlock them.', 'sdp-my-account-tabs-for-woocommerce'), '<a target="_blank" href="' . SMAT_PRO_LINK . '">', '</a>'),
					'new_lines'			=> 'wpautop',
					'esc_html'			=> 0,
					],

				[// CSS class.
					'key' 				=> 'field_smat_css_class',
					'label' 			=> esc_html__('Custom CSS Class', 'sdp-my-account-tabs-for-woocommerce'),
					'name' 				=> 'smat_css_class',
					'aria-label' 		=> '',
					'type' 				=> 'text',
					'instructions' 		=> esc_html__('Enter any CSS class names you want to apply to this tab (separated by commas).', 'sdp-my-account-tabs-for-woocommerce'),
					'required' 			=> 0,
					'conditional_logic' => 0,
					'wrapper' 			=> [
						'width' => '',
						'class' => 'smat-disabled-field',
						'id' 	=> '',
						],
					'default_value' 	=> '',
					'maxlength' 		=> '',
					'allow_in_bindings' => 0,
					'placeholder' 		=> '',
					'prepend' 			=> '',
					'append' 			=> '',
					],
				];
			}

		}

endif;