<?php

/**
 * Add SMAT Shortcode buton.
 * copyright Simple Direct Plugins - support@simpledirectplugins.com
 * https://www.sitepoint.com/adding-a-media-button-to-the-content-editor/
 *
 * @author 					Simple Direct Plugins
 * @link					https://simpledirectplugins.com/
 * @since					1.0.0
 * @package					SMATWoo
 *
 */

defined ('ABSPATH') or exit;

if (!class_exists ('SMAT_Editor')) :

	Class SMAT_Editor {

		public function __construct () {

            add_action ('media_buttons', [$this, 'add_smat_shortcode_button']);
			add_action ('wp_enqueue_media', [$this, 'add_smat_shortcode_js'], 10);
			}

        public function add_smat_shortcode_button () {

            if (SMAT_CPT::CPT !== get_post_type())
                return;

            printf ('<button type="button" id="smat-button" class="button"><span class="dashicons dashicons-shortcode" style="vertical-align:middle"></span> %s</button>', esc_html__('Add SMAT Shortcode', 'sdp-my-account-tabs-for-woocommerce'));
            }

        public function add_smat_shortcode_js () {

			if (SMAT_CPT::CPT === get_post_type()) {

                wp_enqueue_style ('smat-jquery-ui', esc_url (SMAT_ASSETS . 'css/jquery-ui.min.css'), [], '1.14.2');

				wp_enqueue_script ('smat-button', esc_url (SMAT_ASSETS . 'js/button.min.js'), ['jquery', 'jquery-ui-dialog', 'jquery-ui-tabs'], '1.1', true);

                if (class_exists ('SMAT_Shortcodes'))
                    wp_localize_script ('smat-button', 'smatData', SMAT_Shortcodes::get_all_shortcodes());
                }
            }

		}

endif;