<?php

/**
 *
 * Plugin Name: 			SDP My Account Tabs for WooCommerce
 * Description: 			Adds custom tabs to WooCommerce "My Account" page, allowing dynamic, user-specific content.
 * Author: 					Simple Direct Plugins
 * Author URI: 				https://simpledirectplugins.com/
 * Version: 				1.0.0
 * Text Domain: 			sdp-my-account-tabs-for-woocommerce
 * Domain Path: 			/lang/
 * Requires at least:		6.0
 * Tested up to:			7.0
 * Requires PHP: 			7.3
 * WC requires at least:	9.0
 * WC tested up to: 		10.5
 * Requires Plugins:    	woocommerce
 * License:             	GPLv2 or later
 * License URI:           	http://www.gnu.org/licenses/gpl-2.0.html
 *
 * @author 					Simple Direct Plugins
 * @link					https://simpledirectplugins.com/
 * @since					1.0.0
 * @package					SMATWoo
 *
 */

defined ('ABSPATH') or exit;
define  ('SMAT_ASSETS', plugins_url ('assets/', __FILE__));
define  ('SMAT_PRO_LINK', 'https://simpledirectplugins.com/');

if (!class_exists ('SMAT_Init')) :

	#[AllowDynamicProperties]

	Class SMAT_Init {

		private static $instance;

		private function __construct () {
			
			$this->name     = 'SDP My Account Tabs for WooCommerce';
			$this->domain   = 'sdp-my-account-tabs-for-woocommerce';
			$this->files    = ['cpt', 'tab', 'core', 'fields', 'shortcodes', 'editor'];
			$this->classes  = ['SMAT_CPT', 'SMAT_Core', 'SMAT_Fields', 'SMAT_Shortcodes', 'SMAT_Editor'];
			$this->dirname  = dirname (__FILE__);
			$this->basename = plugin_basename ( __FILE__ );

			$this->carga_archivos();

			$this->gestor = 'edit.php?post_type=' . SMAT_CPT::CPT;

			register_activation_hook (__FILE__, function () {
				set_transient ('smat-activado', true, 60);
				}, 10);

			add_action ('init', [$this, 'arranca_plugin'], 10);
			add_action ('admin_notices' , [$this, 'aviso_ayuda'], 10);
			add_action ('before_woocommerce_init', [$this, 'compatibilidad_hpos'], 10);

			add_filter ('plugin_action_links', [$this, 'enlaces_accion'], 10, 2);
			add_filter ('plugin_row_meta', [$this, 'enlaces_meta'], 10, 2);
			}

		public function __clone () {

			/* translators: this class */
			_doing_it_wrong (__FUNCTION__, sprintf (esc_html__('You cannot clone instances of %s.', 'sdp-my-account-tabs-for-woocommerce'), esc_attr (get_class ($this))), '1.0.0');
			}

		public function carga_archivos () {

			foreach ($this->files as $file)
				require (sprintf ('%s/src/%s.php', $this->dirname, $file));

			if (!class_exists ('acf')) {

				/**
				 * To disable the ACF_LITE constant:
				 *
				 * add_filter ('sdp_acf_lite', '__return_false');
				 * 
				 */
				if (!defined ('ACF_LITE'))
					add_action ('after_setup_theme', function () {
						define ('ACF_LITE', apply_filters ('sdp_acf_lite', true)); //phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedConstantFound WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound
						}, 10);

				require ($this->dirname . '/vendor/acf/acf.php');
				}
			}

		public function arranca_plugin () {

			foreach ($this->classes as $class)
				new $class;
			}

		/**
		 * HPOS compatibility declaration.
		 *
		 * @since 	1.0.0
		 *
		 */
		public function compatibilidad_hpos () {

			if (class_exists (\Automattic\WooCommerce\Utilities\FeaturesUtil::class))
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
			}

		public function aviso_ayuda () {

			if (get_transient ('smat-activado')) {

				echo '<div class="updated notice is-dismissible woocommerce-message"><p>';
				/* translators: the name of the plugin */
				printf (esc_html__('Thanks for using %s! You can now manage My Account tabs.', 'sdp-my-account-tabs-for-woocommerce'), '<i>' . esc_html ($this->name) . '</i>' );
				printf ('</p><p><a href="%s" class="button button-primary">%s</a>', esc_url ($this->gestor), esc_html__('Manage tabs', 'sdp-my-account-tabs-for-woocommerce'));
				echo '</p></div>';

				delete_transient ('smat-activado');
				}
			}

		public function enlaces_accion ($links, $plugin) {

			if ($plugin === $this->basename) {

				$sdp   = [];
				$sdp[] = sprintf ('<b><a target="_blank" href="%s">%s</a></b>', SMAT_PRO_LINK, esc_html__('Go Pro', 'sdp-my-account-tabs-for-woocommerce'));

				post_type_exists (SMAT_CPT::CPT) and
					$sdp[] = '<a href="' . esc_url ($this->gestor) . '">' . esc_html__('Manage tabs', 'sdp-my-account-tabs-for-woocommerce') . '</a>';

				$sdp[] = sprintf ('<a target="_blank" href="https://simpledirectplugins.com/docs/sdp-my-account-tabs-documentation/">%s</a>', esc_html__('User guide', 'sdp-my-account-tabs-for-woocommerce'));

				$links = array_merge ($sdp, $links);
				}
			
			return $links;
			}

		public function enlaces_meta ($links, $plugin) {

			if ($plugin === $this->basename) {

				$links[] = sprintf ('<a target="_blank" href="https://wordpress.org/support/plugin/sdp-my-account-tabs-for-woocommerce/"><i class="fa fa-solid fa-life-ring"></i> %s</a>', esc_html__('Need Help?', 'sdp-my-account-tabs-for-woocommerce'));
				$links[] = sprintf ('<a target="_blank" href="https://wordpress.org/support/plugin/sdp-my-account-tabs-for-woocommerce/reviews/#new-post">%s <span>★★★★★</span></a>', esc_html__('Rate Us', 'sdp-my-account-tabs-for-woocommerce'));
				}

			return $links;
			}

		public static function instance () {

			if (null === self::$instance)
				self::$instance = new self();

			return self::$instance;
			}

		}

endif;

SMAT_Init::instance();