<?php
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/*
 * Plugin Name: Scriptriz Smart Chat
 * Plugin URI: https://scriptriz.com/scriptriz-smart-chat
 * Description: Adds a floating WhatsApp/Telegram chat button to your website with user-selectable options.
 * Version: 1.0
 * Author: Scriptriz
 * Author URI: https://scriptriz.com
 * License: GPL2
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: scriptriz-smart-chat
 * Domain Path: /languages
 */

// Load styles
add_action('wp_enqueue_scripts', function() {
    wp_enqueue_style(
        'scriptrizsc-style',
        plugin_dir_url(__FILE__) . 'assets/style.css',
        [],
        filemtime(plugin_dir_path(__FILE__) . 'assets/style.css')
    );
});

// Display chat buttons
add_action('wp_footer', function() {
    $show_whatsapp = get_option('scriptrizsc_show_whatsapp', '1');
    $show_telegram = get_option('scriptrizsc_show_telegram', '1');
    $whatsapp      = esc_attr(get_option('scriptrizsc_whatsapp_number', '1234567890'));
    $telegram      = esc_attr(get_option('scriptrizsc_telegram_username', 'yourusername'));

    if (!$show_whatsapp && !$show_telegram) return;

    $whatsapp_icon_url = plugin_dir_url(__FILE__) . 'assets/whatsapp.png';
    $telegram_icon_url = plugin_dir_url(__FILE__) . 'assets/telegram.png';

    echo '<div class="scriptrizsc-chat-button" style="position: fixed; bottom: 20px; right: 20px; z-index: 9999;">';

    if ($show_whatsapp && $whatsapp) {
        echo '<a href="https://wa.me/' . esc_attr($whatsapp) . '?text=Hi%20there!" target="_blank" aria-label="WhatsApp Chat" rel="noopener noreferrer">
                <img src="' . esc_url($whatsapp_icon_url) . '" alt="WhatsApp" />
              </a>';
    }

    if ($show_telegram && $telegram) {
        echo '<a href="https://t.me/' . esc_attr($telegram) . '" target="_blank" aria-label="Telegram Chat" rel="noopener noreferrer">
                <img src="' . esc_url($telegram_icon_url) . '" alt="Telegram" />
              </a>';
    }

    echo '</div>';
});

// Admin menu
add_action('admin_menu', function() {
    add_menu_page(
        'Scriptriz Smart Chat',
        'Smart Chat',
        'manage_options',
        'scriptriz-smart-chat',
        'scriptrizsc_settings_page',
        '', // you can add dashicons if needed
        null
    );
});

// Register plugin settings
add_action('admin_init', function() {
    register_setting('scriptrizsc_settings_group', 'scriptrizsc_whatsapp_number', 'sanitize_text_field');
    register_setting('scriptrizsc_settings_group', 'scriptrizsc_telegram_username', 'sanitize_text_field');
    register_setting('scriptrizsc_settings_group', 'scriptrizsc_show_whatsapp', 'absint');
    register_setting('scriptrizsc_settings_group', 'scriptrizsc_show_telegram', 'absint');
});

// Settings page
function scriptrizsc_settings_page() {
    $icon_url = plugin_dir_url(__FILE__) . 'assets/icon-128x128.png';
    ?>
    <div class="wrap">
        <h1 style="display:flex; align-items:center;">
            <img src="<?php echo esc_url($icon_url); ?>" alt="Plugin Icon" width="40" height="40" style="margin-right: 10px;" />
            Scriptriz Smart Chat
        </h1>
        <form method="post" action="options.php">
            <?php settings_fields('scriptrizsc_settings_group'); ?>
            <?php do_settings_sections('scriptrizsc_settings_group'); ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Enable WhatsApp Button</th>
                    <td><input type="checkbox" name="scriptrizsc_show_whatsapp" value="1" <?php checked(1, get_option('scriptrizsc_show_whatsapp', 1)); ?> /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">WhatsApp Number (e.g. 1234567890)</th>
                    <td><input type="text" name="scriptrizsc_whatsapp_number" value="<?php echo esc_attr(get_option('scriptrizsc_whatsapp_number')); ?>" class="regular-text" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Enable Telegram Button</th>
                    <td><input type="checkbox" name="scriptrizsc_show_telegram" value="1" <?php checked(1, get_option('scriptrizsc_show_telegram', 1)); ?> /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Telegram Username (e.g. yourusername)</th>
                    <td><input type="text" name="scriptrizsc_telegram_username" value="<?php echo esc_attr(get_option('scriptrizsc_telegram_username')); ?>" class="regular-text" /></td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}
