<?php
/**
 * Template for displaying search results
 *
 * @package SCHOQASE_Search
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

// Get search options
$search = new SCHOQASE_Search_Engine();
$options = $search->get_options();

// Verify nonce if processing POST data
if ( isset( $_POST['query'] ) ) {
    // Check if this is a valid request with proper nonce
    if ( ! isset( $_POST['schoqase_search_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['schoqase_search_nonce'] ) ), 'schoqase-search-form' ) ) {
        wp_die( esc_html__( 'Security check failed', 'scholarships-qa-search' ) );
    }
    $query = sanitize_text_field( wp_unslash( $_POST['query'] ) );
} else {
    $query = '';
}

// Set up variables
$results_heading = $options['results_heading'];
$no_results_text = $options['no_results_text'];
$footer_text = $options['footer_text'];
$base_url = $search->get_base_url();
?>

<div class="schoqase-results-container">
    <?php if ( !empty( $results_heading ) ) : ?>
        <h3 class="schoqase-results-heading"><?php echo esc_html( $results_heading ); ?></h3>
    <?php endif; ?>

    <?php if ( !empty( $results ) && is_array( $results ) ) : ?>
        <ul class="schoqase-result-list">
            <?php foreach ( $results as $result ) : ?>
                <li class="schoqase-result-item">
                    <div class="schoqase-result-title">
                        <a href="<?php echo esc_url( $result['url'] ); ?>" class="schoqase-result-link" target="_blank" rel="noopener">
                            <?php echo esc_html( $result['title'] ); ?>
                        </a>
                    </div>
                    
                    <?php if ( !empty( $result['excerpt'] ) ) : ?>
                        <div class="schoqase-result-excerpt">
                            <?php echo wp_kses_post($result['excerpt']); ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="schoqase-result-url">
                        <?php echo esc_url( $result['url'] ); ?>
                    </div>
                </li>
            <?php endforeach; ?>
        </ul>
        
    <?php else : ?>
        <div class="schoqase-no-results">
            <?php echo esc_html( $no_results_text ); ?>
        </div>
    <?php endif; ?>
    
    <!-- Footer moved to search-form.php -->
</div>
