<?php
/**
 * Template for displaying search form
 *
 * @package SCHOQASE_Search
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

// Check if this is being used within shortcode or widget
$is_shortcode = isset( $atts );

// Set up variables based on context
if ( $is_shortcode ) {
    $title = isset( $atts['title'] ) ? $atts['title'] : '';
    $placeholder = isset( $atts['placeholder'] ) ? $atts['placeholder'] : '';
    $button_text = isset( $atts['button_text'] ) ? $atts['button_text'] : '';
    $results_num = isset( $atts['results_num'] ) ? absint( $atts['results_num'] ) : 5;
    $container_id = 'schoqase-container-' . uniqid();
} else {
    // Widget context
    $title = isset( $title ) ? $title : '';
    $placeholder = isset( $placeholder ) ? $placeholder : '';
    $button_text = isset( $button_text ) ? $button_text : '';
    $results_num = isset( $results_num ) ? absint( $results_num ) : 5;
    $container_id = isset( $widget_id ) ? 'schoqase-container-' . $widget_id : 'schoqase-container-' . uniqid();
}

// Get defaults from options if needed
$search = new SCHOQASE_Search_Engine();
$options = $search->get_options();

if ( empty( $placeholder ) ) {
    $placeholder = $options['placeholder'];
}

if ( empty( $button_text ) ) {
    $button_text = $options['button_text'];
}

// Generate IDs for form elements
$form_id = 'schoqase-form-' . substr( $container_id, strrpos( $container_id, '-' ) + 1 );
$results_id = 'schoqase-results-' . substr( $container_id, strrpos( $container_id, '-' ) + 1 );
?>

<div id="<?php echo esc_attr( $container_id ); ?>" class="schoqase-search-container">
    <?php if ( !empty( $options['footer_text'] ) ) : ?>
        <div class="schoqase-search-attribution">
            <a href="<?php echo esc_url( $options['base_url'] ); ?>" target="_blank" rel="noopener">
                <?php echo esc_html( $options['footer_text'] ); ?>
            </a>
        </div>
    <?php endif; ?>
    
    <form id="<?php echo esc_attr( $form_id ); ?>" class="schoqase-search-form" data-results-num="<?php echo esc_attr( $results_num ); ?>">
        <input type="text" 
               class="schoqase-search-input" 
               placeholder="<?php echo esc_attr( $placeholder ); ?>"
               aria-label="<?php esc_attr_e( 'Search scholarships', 'scholarships-qa-search' ); ?>"
               required>
        <?php wp_nonce_field( 'schoqase-search-form', 'schoqase_search_nonce' ); ?>
        <button type="submit" class="schoqase-search-button">
            <?php echo esc_html( $button_text ); ?>
        </button>
    </form>
    
    <div id="<?php echo esc_attr( $results_id ); ?>" class="schoqase-search-results"></div>
</div>
