<?php
/**
 * The widget functionality of the plugin.
 *
 * @package SQandA_Search
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
    die;
}

/**
 * Widget class.
 */
class SCHOQASE_Widget extends WP_Widget {

    /**
     * Initialize the widget.
     */
    public function __construct() {
        parent::__construct(
            'schoqase_search_widget',
            __( 'Scholarships Q&A Search', 'scholarships-qa-search' ),
            array(
                'description' => __( 'Adds a search box to search ScholarshipsQandA.com content', 'scholarships-qa-search' ),
                'classname'   => 'schoqase-search-widget',
            )
        );
    }

    /**
     * Widget frontend display.
     *
     * @param array $args     Widget arguments.
     * @param array $instance Saved values from database.
     */
    public function widget( $args, $instance ) {
        $search = new SCHOQASE_Search_Engine();
        $options = $search->get_options();
        
        $title = ! empty( $instance['title'] ) ? $instance['title'] : $options['title'];
        $placeholder = ! empty( $instance['placeholder'] ) ? $instance['placeholder'] : $options['placeholder'];
        $button_text = ! empty( $instance['button_text'] ) ? $instance['button_text'] : $options['button_text'];
        $results_num = ! empty( $instance['results_num'] ) ? absint( $instance['results_num'] ) : $options['results_num'];
        
        // Before widget
        echo wp_kses_post( $args['before_widget'] );
        
        // Title
        if ( ! empty( $title ) ) {
            echo wp_kses_post( $args['before_title'] ) . wp_kses_post( apply_filters( 'widget_title', $title ) ) . wp_kses_post( $args['after_title'] );
        }
        
        // Widget content
        $widget_id = $this->id ? $this->id : 'schoqase-widget-' . uniqid();
        $atts = array(
            'title'        => $title,
            'placeholder'  => $placeholder,
            'button_text'  => $button_text,
            'results_num'  => $results_num,
            'widget_id'    => $widget_id,
        );
        
        include SCHOQASE_PLUGIN_DIR . 'templates/search-form.php';
        
        // After widget
        echo wp_kses_post( $args['after_widget'] );
    }

    /**
     * Widget Backend form.
     *
     * @param array $instance Previously saved values from database.
     */
    public function form( $instance ) {
        $search = new SCHOQASE_Search_Engine();
        $options = $search->get_options();
        
        $title = ! empty( $instance['title'] ) ? $instance['title'] : $options['title'];
        $placeholder = ! empty( $instance['placeholder'] ) ? $instance['placeholder'] : $options['placeholder'];
        $button_text = ! empty( $instance['button_text'] ) ? $instance['button_text'] : $options['button_text'];
        $results_num = ! empty( $instance['results_num'] ) ? absint( $instance['results_num'] ) : $options['results_num'];
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_html_e( 'Title:', 'scholarships-qa-search' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'placeholder' ) ); ?>"><?php esc_html_e( 'Placeholder:', 'scholarships-qa-search' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'placeholder' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'placeholder' ) ); ?>" type="text" value="<?php echo esc_attr( $placeholder ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'button_text' ) ); ?>"><?php esc_html_e( 'Button Text:', 'scholarships-qa-search' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'button_text' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'button_text' ) ); ?>" type="text" value="<?php echo esc_attr( $button_text ); ?>">
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'results_num' ) ); ?>"><?php esc_html_e( 'Number of Results:', 'scholarships-qa-search' ); ?></label>
            <input class="tiny-text" id="<?php echo esc_attr( $this->get_field_id( 'results_num' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'results_num' ) ); ?>" type="number" min="1" max="20" value="<?php echo esc_attr( $results_num ); ?>">
        </p>
        <?php
    }

    /**
     * Sanitize widget form values as they are saved.
     *
     * @param array $new_instance Values just sent to be saved.
     * @param array $old_instance Previously saved values from database.
     * @return array Updated safe values to be saved.
     */
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ! empty( $new_instance['title'] ) ? sanitize_text_field( $new_instance['title'] ) : '';
        $instance['placeholder'] = ! empty( $new_instance['placeholder'] ) ? sanitize_text_field( $new_instance['placeholder'] ) : '';
        $instance['button_text'] = ! empty( $new_instance['button_text'] ) ? sanitize_text_field( $new_instance['button_text'] ) : '';
        $instance['results_num'] = ! empty( $new_instance['results_num'] ) ? absint( $new_instance['results_num'] ) : 5;
        
        return $instance;
    }
}
