<?php
/**
 * Uninstall script.
 *
 * Runs when the plugin is uninstalled (deleted) from WordPress.
 * Cleans up all plugin data: options, transients, and user meta.
 *
 * @package Scheduled_Posts_Showcase
 */

// Prevent direct access.
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

global $wpdb;

// Delete plugin options.
delete_option( 'spscase_settings' );

// Delete all transients created by the plugin.
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Bulk transient cleanup on uninstall.
$wpdb->query(
	$wpdb->prepare(
		"DELETE FROM {$wpdb->options} WHERE option_name LIKE %s OR option_name LIKE %s",
		'_transient_spscase_posts_%',
		'_transient_timeout_spscase_posts_%'
	)
);

// Delete user meta for notice dismissals.
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Bulk user meta cleanup on uninstall.
$wpdb->query(
	$wpdb->prepare(
		"DELETE FROM {$wpdb->usermeta} WHERE meta_key = %s",
		'spscase_activation_notice_dismissed'
	)
);

// Clear any cached data in object cache.
if ( function_exists( 'wp_cache_flush' ) ) {
	wp_cache_flush();
}
