<?php
/**
 * Scheduled Posts Showcase Promotional Banner
 *
 * Promotional banner for Scheduled Posts Showcase plugin.
 * Follows AyudaWP promo banner guide.
 *
 * @package Scheduled_Posts_Showcase
 */

// Prevent direct access.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * SPSCASE_Promo_Banner class.
 *
 * Displays promotional content for AyudaWP plugins and services.
 * Uses vertical (sidebar) layout.
 */
class SPSCASE_Promo_Banner {

	/**
	 * Current plugin slug to exclude from recommendations.
	 *
	 * @var string
	 */
	private static $current_plugin_slug = 'scheduled-posts-showcase';

	/**
	 * Get plugins catalog.
	 *
	 * @return array
	 */
	private static function get_plugins_catalog() {
		return array(
			'vigilante'                            => array(
				'icon'        => 'dashicons-shield',
				'title'       => __( 'Complete WordPress security', 'scheduled-posts-showcase' ),
				'description' => __( 'All-in-one security plugin: firewall, login protection, security headers, 2FA, file integrity monitoring, and activity logging.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Vigilante', 'scheduled-posts-showcase' ),
			),
			'gozer'                                => array(
				'icon'        => 'dashicons-admin-network',
				'title'       => __( 'Restrict site access', 'scheduled-posts-showcase' ),
				'description' => __( 'Force visitors to log in before accessing your site with extensive exception controls for pages, posts, and user roles.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Gozer', 'scheduled-posts-showcase' ),
			),
			'vigia'                                => array(
				'icon'        => 'dashicons-visibility',
				'title'       => __( 'Monitor AI crawler activity', 'scheduled-posts-showcase' ),
				'description' => __( 'Track which AI bots visit your site, analyze their behavior, and take control with blocking rules and robots.txt management.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install VigIA', 'scheduled-posts-showcase' ),
			),
			'ai-share-summarize'                   => array(
				'icon'        => 'dashicons-share',
				'title'       => __( 'Boost your AI presence', 'scheduled-posts-showcase' ),
				'description' => __( 'Add social sharing and AI summarize buttons. Help visitors share your content and let AIs learn from your site while getting backlinks.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install AI Share & Summarize', 'scheduled-posts-showcase' ),
			),
			'ai-content-signals'                   => array(
				'icon'        => 'dashicons-flag',
				'title'       => __( 'Control AI content usage', 'scheduled-posts-showcase' ),
				'description' => __( 'Cloudflare-endorsed plugin to define how AI systems can use your content: for training, search results, or both.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install AI Content Signals', 'scheduled-posts-showcase' ),
			),
			'wpo-tweaks'                           => array(
				'icon'        => 'dashicons-performance',
				'title'       => __( 'Speed up your WordPress', 'scheduled-posts-showcase' ),
				'description' => __( 'Comprehensive performance optimizations: critical CSS, lazy loading, cache rules, and 30+ tweaks with zero configuration.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Zero Config Performance', 'scheduled-posts-showcase' ),
			),
			'no-gutenberg'                         => array(
				'icon'        => 'dashicons-edit-page',
				'title'       => __( 'Back to Classic Editor', 'scheduled-posts-showcase' ),
				'description' => __( 'Completely remove Gutenberg, FSE styles, and block widgets. Restore the classic editing experience with better performance.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install No Gutenberg', 'scheduled-posts-showcase' ),
			),
			'anticache'                            => array(
				'icon'        => 'dashicons-hammer',
				'title'       => __( 'Development toolkit', 'scheduled-posts-showcase' ),
				'description' => __( 'Bypass all caching during development. Auto-detects cache plugins, enables debug mode, and includes maintenance screen.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Anti-Cache Kit', 'scheduled-posts-showcase' ),
			),
			'auto-capitalize-names-ayudawp'        => array(
				'icon'        => 'dashicons-editor-textcolor',
				'title'       => __( 'Fix customer names', 'scheduled-posts-showcase' ),
				'description' => __( 'Auto-capitalize names and addresses in WordPress and WooCommerce. Keep invoices and reports professionally formatted.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Auto Capitalize', 'scheduled-posts-showcase' ),
			),
			'easy-actions-scheduler-cleaner-ayudawp' => array(
				'icon'        => 'dashicons-database-remove',
				'title'       => __( 'Clean Action Scheduler', 'scheduled-posts-showcase' ),
				'description' => __( 'Remove millions of completed, failed, and old actions from WooCommerce Action Scheduler. Reduce database size instantly.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Scheduler Cleaner', 'scheduled-posts-showcase' ),
			),
			'native-sitemap-customizer'            => array(
				'icon'        => 'dashicons-networking',
				'title'       => __( 'Customize your sitemap', 'scheduled-posts-showcase' ),
				'description' => __( 'Control WordPress native sitemap: exclude post types, taxonomies, specific posts, and authors. No bloat, just options.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Sitemap Customizer', 'scheduled-posts-showcase' ),
			),
			'post-visibility-control'              => array(
				'icon'        => 'dashicons-hidden',
				'title'       => __( 'Control post visibility', 'scheduled-posts-showcase' ),
				'description' => __( 'Hide posts from homepage, archives, feeds, or REST API while keeping them accessible via direct URL.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Post Visibility', 'scheduled-posts-showcase' ),
			),
			'widget-visibility-control'            => array(
				'icon'        => 'dashicons-welcome-widgets-menus',
				'title'       => __( 'Smart widget display', 'scheduled-posts-showcase' ),
				'description' => __( 'Show or hide widgets based on pages, post types, categories, user roles, and more. Works with any theme.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Widget Visibility', 'scheduled-posts-showcase' ),
			),
			'search-replace-text-blocks'           => array(
				'icon'        => 'dashicons-search',
				'title'       => __( 'Search & replace in blocks', 'scheduled-posts-showcase' ),
				'description' => __( 'Find and replace text across all your Gutenberg blocks. Bulk edit content without touching the database directly.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Search Replace Blocks', 'scheduled-posts-showcase' ),
			),
			'seo-read-more-buttons-ayudawp'        => array(
				'icon'        => 'dashicons-admin-links',
				'title'       => __( 'Better read more links', 'scheduled-posts-showcase' ),
				'description' => __( 'Customize excerpt "read more" links with buttons, custom text, and nofollow option. Improve CTR and SEO.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install SEO Read More', 'scheduled-posts-showcase' ),
			),
			'show-only-lowest-prices-in-woocommerce-variable-products' => array(
				'icon'        => 'dashicons-tag',
				'title'       => __( 'Cleaner variable prices', 'scheduled-posts-showcase' ),
				'description' => __( 'Display only the lowest price for WooCommerce variable products instead of confusing price ranges.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Lowest Price', 'scheduled-posts-showcase' ),
			),
			'multiple-sale-prices-scheduler'       => array(
				'icon'        => 'dashicons-calendar-alt',
				'title'       => __( 'Schedule sale prices', 'scheduled-posts-showcase' ),
				'description' => __( 'Set multiple future sale prices for WooCommerce products. Plan promotions in advance with start and end dates.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Sale Scheduler', 'scheduled-posts-showcase' ),
			),
			'easy-store-management-ayudawp'        => array(
				'icon'        => 'dashicons-store',
				'title'       => __( 'Simplify store management', 'scheduled-posts-showcase' ),
				'description' => __( 'Clean up WordPress admin for Store Managers. Hide unnecessary menus, keep only orders, products, and customers, plus quick access shortcuts.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Easy Store', 'scheduled-posts-showcase' ),
			),
			'lightbox-images-for-divi'             => array(
				'icon'        => 'dashicons-format-gallery',
				'title'       => __( 'Lightbox for Divi', 'scheduled-posts-showcase' ),
				'description' => __( 'Add native lightbox functionality to Divi theme images. No jQuery, fast loading, fully customizable.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Install Divi Lightbox', 'scheduled-posts-showcase' ),
			),
		);
	}

	/**
	 * Get services catalog.
	 *
	 * @return array
	 */
	private static function get_services_catalog() {
		return array(
			'maintenance' => array(
				'icon'        => 'dashicons-admin-tools',
				'title'       => __( 'Need help with your website?', 'scheduled-posts-showcase' ),
				'description' => __( 'Professional WordPress maintenance: security monitoring, regular backups, performance optimization, and priority support.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Learn more', 'scheduled-posts-showcase' ),
				'url'         => 'https://mantenimiento.ayudawp.com',
			),
			'consultancy' => array(
				'icon'        => 'dashicons-businessman',
				'title'       => __( 'WordPress consultancy', 'scheduled-posts-showcase' ),
				'description' => __( 'One-on-one online sessions to solve your WordPress doubts, get expert advice, and make better decisions for your project.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Book a session', 'scheduled-posts-showcase' ),
				'url'         => 'https://servicios.ayudawp.com/producto/consultoria-online-wordpress/',
			),
			'hacked'      => array(
				'icon'        => 'dashicons-sos',
				'title'       => __( 'Hacked website?', 'scheduled-posts-showcase' ),
				'description' => __( 'Fast recovery service for compromised WordPress sites. We clean malware, fix vulnerabilities, and restore your site security.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Get help now', 'scheduled-posts-showcase' ),
				'url'         => 'https://servicios.ayudawp.com/producto/wordpress-hackeado/',
			),
			'development' => array(
				'icon'        => 'dashicons-editor-code',
				'title'       => __( 'Custom development', 'scheduled-posts-showcase' ),
				'description' => __( 'Need a custom plugin, theme modifications, or specific functionality? We build tailored WordPress solutions for your needs.', 'scheduled-posts-showcase' ),
				'button'      => __( 'Request a quote', 'scheduled-posts-showcase' ),
				'url'         => 'https://servicios.ayudawp.com/producto/desarrollo-wordpress/',
			),
		);
	}

	/**
	 * Get random plugins excluding current.
	 *
	 * @param int $count Number of plugins to return.
	 * @return array
	 */
	private static function get_random_plugins( $count = 2 ) {
		$plugins = self::get_plugins_catalog();

		// Remove current plugin.
		unset( $plugins[ self::$current_plugin_slug ] );

		// Get random keys.
		$random_keys = array_rand( $plugins, min( $count, count( $plugins ) ) );

		if ( ! is_array( $random_keys ) ) {
			$random_keys = array( $random_keys );
		}

		$result = array();
		foreach ( $random_keys as $key ) {
			$result[ $key ] = $plugins[ $key ];
		}

		return $result;
	}

	/**
	 * Get random service.
	 *
	 * @return array
	 */
	private static function get_random_service() {
		$services   = self::get_services_catalog();
		$random_key = array_rand( $services );

		return $services[ $random_key ];
	}

	/**
	 * Render the promotional banner (vertical/sidebar layout).
	 *
	 * @return void
	 */
	public static function render() {
		$plugins = self::get_random_plugins( 2 );
		$service = self::get_random_service();

		// Render plugin widgets.
		foreach ( $plugins as $slug => $plugin ) :
			?>
			<div class="sps-sidebar-widget sps-promo-widget">
				<span class="dashicons <?php echo esc_attr( $plugin['icon'] ); ?>"></span>
				<h3><?php echo esc_html( $plugin['title'] ); ?></h3>
				<p><?php echo esc_html( $plugin['description'] ); ?></p>
				<a href="<?php echo esc_url( admin_url( 'plugin-install.php?tab=plugin-information&plugin=' . $slug . '&TB_iframe=true&width=772&height=618' ) ); ?>" class="button thickbox">
					<?php echo esc_html( $plugin['button'] ); ?>
				</a>
			</div>
			<?php
		endforeach;

		// Render service widget.
		?>
		<div class="sps-sidebar-widget sps-promo-widget">
			<span class="dashicons <?php echo esc_attr( $service['icon'] ); ?>"></span>
			<h3><?php echo esc_html( $service['title'] ); ?></h3>
			<p><?php echo esc_html( $service['description'] ); ?></p>
			<a href="<?php echo esc_url( $service['url'] ); ?>" target="_blank" rel="noopener noreferrer" class="button button-primary">
				<?php echo esc_html( $service['button'] ); ?>
			</a>
		</div>
		<?php
	}
}
