/**
 * Scheduled Posts Showcase - Admin JavaScript
 *
 * Handles:
 * - Conditional field visibility
 * - Color picker initialization
 * - Icon selector interactions
 *
 * @package Scheduled_Posts_Showcase
 */

( function( $ ) {
	'use strict';

	/**
	 * Initialize when document is ready.
	 */
	$( document ).ready( function() {
		initColorPicker();
		initConditionalFields();
		initIconSelector();
	} );

	/**
	 * Initialize WordPress color picker.
	 */
	function initColorPicker() {
		if ( $.fn.wpColorPicker ) {
			$( '.sps-color-picker' ).wpColorPicker();
		}
	}

	/**
	 * Initialize conditional field visibility.
	 *
	 * Hides/shows entire table rows based on parent field state.
	 */
	function initConditionalFields() {
		// Show excerpt -> Excerpt length row
		$( '#spscase_show_excerpt' ).on( 'change', function() {
			var $dependentRow = $( this ).closest( 'tr' ).next( 'tr' );
			if ( $dependentRow.find( '.sps-conditional-field' ).length ) {
				toggleRow( $dependentRow, $( this ).is( ':checked' ) );
			}
		} ).trigger( 'change' );

		// Show image -> Image size row
		$( '#spscase_show_image' ).on( 'change', function() {
			var $dependentRow = $( this ).closest( 'tr' ).next( 'tr' );
			if ( $dependentRow.find( '.sps-conditional-field' ).length ) {
				toggleRow( $dependentRow, $( this ).is( ':checked' ) );
			}
		} ).trigger( 'change' );

		// List style -> Icon row
		$( '#spscase_list_style' ).on( 'change', function() {
			var $dependentRow = $( this ).closest( 'tr' ).next( 'tr' );
			if ( $dependentRow.find( '.sps-conditional-field' ).length ) {
				toggleRow( $dependentRow, $( this ).val() === 'dashicon' );
			}
		} ).trigger( 'change' );
	}

	/**
	 * Toggle entire table row visibility.
	 *
	 * @param {jQuery} $row Table row element.
	 * @param {boolean} show Whether to show or hide.
	 */
	function toggleRow( $row, show ) {
		if ( show ) {
			$row.show();
		} else {
			$row.hide();
		}
	}

	/**
	 * Initialize icon selector interactions.
	 */
	function initIconSelector() {
		var $iconOptions = $( '.sps-icon-option' );

		if ( ! $iconOptions.length ) {
			return;
		}

		// Handle clicks on icon labels.
		$iconOptions.on( 'click', function() {
			var $container = $( this ).closest( '.sps-icon-selector' );
			$container.find( '.sps-icon-option' ).removeClass( 'selected' );
			$( this ).addClass( 'selected' );
		} );

		// Set initial state.
		$iconOptions.each( function() {
			var $input = $( this ).find( 'input[type="radio"]' );
			if ( $input.is( ':checked' ) ) {
				$( this ).addClass( 'selected' );
			}
		} );
	}

} )( jQuery );