<?php
/**
 * Plugin Name: Save & Summarize – AI Digest for Saved Articles
 * Description: Allow users to save posts for later and receive a weekly digest enhanced with optional AI-generated summaries. Lightweight, privacy-friendly, and compatible with any theme.
 * Version: 1.0.0
 * Author: Ashish Kumar
 * Author URI: https://github.com/ashishforgive
 * Text Domain: save-summarize-ai-digest-for-saved-articles
 * Domain Path: /languages
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * @package SaveAndSummarize
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'SAVEAMSU_PLUGIN_VERSION', '1.0.0' );
define( 'SAVEAMSU_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'SAVEAMSU_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'SAVEAMSU_SETTINGS_PAGE_SLUG', 'saveamsu-save-summarize-ai-digest' );
define( 'SAVEAMSU_CRON_RECURRENCE', 'saveamsu_weekly' );


// Autoload includes
require_once SAVEAMSU_PLUGIN_DIR . 'includes/class-ss-activator.php';
require_once SAVEAMSU_PLUGIN_DIR . 'includes/class-ss-bookmarks.php';
require_once SAVEAMSU_PLUGIN_DIR . 'includes/class-ss-digest.php';
require_once SAVEAMSU_PLUGIN_DIR . 'includes/class-ss-ai-client.php';
require_once SAVEAMSU_PLUGIN_DIR . 'includes/class-ss-settings.php';
require_once SAVEAMSU_PLUGIN_DIR . 'includes/class-ss-metabox.php';
require_once SAVEAMSU_PLUGIN_DIR . 'includes/ss-template-tags.php';


register_activation_hook( __FILE__, array( 'SAVEAMSU_Activator', 'activate' ) );
register_deactivation_hook( __FILE__, array( 'SAVEAMSU_Activator', 'deactivate' ) );

/**
 * Register a weekly cron schedule used by this plugin.
 */
function saveamsu_register_cron_schedules( $schedules ) {
    if ( ! isset( $schedules[ SAVEAMSU_CRON_RECURRENCE ] ) ) {
        $schedules[ SAVEAMSU_CRON_RECURRENCE ] = array(
            'interval' => 7 * DAY_IN_SECONDS,
            'display'  => __( 'Save & Summarize Weekly', 'save-summarize-ai-digest-for-saved-articles' ),
        );
    }

    return $schedules;
}
add_filter( 'cron_schedules', 'saveamsu_register_cron_schedules' );

function saveamsu_init_plugin() {
    // Init singletons or static boot methods if needed
    SAVEAMSU_Settings::init();
    SAVEAMSU_Bookmarks::init();
    SAVEAMSU_Digest::init();
    SAVEAMSU_Metabox::init();
}
add_action( 'plugins_loaded', 'saveamsu_init_plugin' );


/**
 * Add Settings link after Deactivate
 */
function saveamsu_plugin_action_links( $links ) {

    $settings_url = admin_url( 'options-general.php?page=' . SAVEAMSU_SETTINGS_PAGE_SLUG );

    $settings_link = '<a href="' . esc_url( $settings_url ) . '">' .
                        __( 'Settings', 'save-summarize-ai-digest-for-saved-articles' ) .
                     '</a>';

    // Add link at the END (after Deactivate)
    $links[] = $settings_link;

    return $links;
}
add_filter(
    'plugin_action_links_' . plugin_basename( __FILE__ ),
    'saveamsu_plugin_action_links'
);
