<?php

/**
 * Render Save Button with professional UI
 */
function saveamsu_render_save_button() {

    // Only for single posts or pages
    if ( ! is_singular( array( 'post', 'page' ) ) ) {
        return '';
    }

    global $post;

    // Check meta toggle
    $enabled = SAVEAMSU_Metabox::get_enable_meta( $post->ID );
    if ( $enabled !== '1' ) {
        return '';
    }

    // Not render button if it has saved list
    if (
        has_shortcode( $post->post_content, 'saveamsu_saved_posts' ) ||
        has_shortcode( $post->post_content, 'ss_saved_posts' )
    ) {
        return '';
    }

    $is_logged_in = is_user_logged_in();
    $is_saved     = false;

    if ( $is_logged_in ) {
        $is_saved = SAVEAMSU_Bookmarks::is_bookmarked( get_current_user_id(), $post->ID );
    }

    // Button state text – single line
    $main_label = $is_saved
        ? __( 'Saved for later', 'save-summarize-ai-digest-for-saved-articles' )
        : __( 'Save for later', 'save-summarize-ai-digest-for-saved-articles' );

    $btn_class = $is_saved ? 'ss-saved' : 'ss-not-saved';

    ob_start();
    ?>
    <button
        class="ss-save-button <?php echo esc_attr( $btn_class ); ?>"
        data-post-id="<?php echo esc_attr( $post->ID ); ?>"
        type="button"
    >
        <div class="ss-btn-inner">
            <svg class="ss-icon" width="20" height="20" viewBox="0 0 24 24" aria-hidden="true" focusable="false">
                <path d="M6 2a2 2 0 0 0-2 2v18l8-5 8 5V4a2 2 0 0 0-2-2H6z" fill="currentColor"/>
            </svg>
            <span class="ss-main-label"><?php echo esc_html( $main_label ); ?></span>
        </div>
    </button>
    <?php
    return ob_get_clean();
}
add_shortcode( 'saveamsu_save_button', 'saveamsu_render_save_button' );



/**
 * Insert Save Button below the title (right-aligned via CSS)
 */
function saveamsu_insert_button_below_title( $title, $post_id ) {

    if ( ! is_singular( array( 'post', 'page' ) ) ) {
        return $title;
    }

    if ( get_the_ID() !== $post_id ) {
        return $title;
    }

    // Require meta toggle ON
    $enabled = SAVEAMSU_Metabox::get_enable_meta( $post_id );
    if ( $enabled !== '1' ) {
        return $title;
    }

    $button = saveamsu_render_save_button();

    // Wrap neatly under title; CSS will right-align
    $button_html = '<div class="ss-under-title">' . $button . '</div>';

    return $title . $button_html;
}
add_filter( 'the_title', 'saveamsu_insert_button_below_title', 10, 2 );


function saveamsu_render_saved_posts_list( $atts ) {
    global $saveamsu_rendering_saved_list;
    $saveamsu_rendering_saved_list = true;

    if ( ! is_user_logged_in() ) {
        $saveamsu_rendering_saved_list = false;
        return '<p>' . esc_html__( 'Please log in to see your saved items.', 'save-summarize-ai-digest-for-saved-articles' ) . '</p>';
    }

    $user_id  = get_current_user_id();
    $post_ids = SAVEAMSU_Bookmarks::get_user_bookmarks( $user_id );

    if ( empty( $post_ids ) ) {
        $saveamsu_rendering_saved_list = false;
        return '<p>' . esc_html__( 'You have no saved items yet.', 'save-summarize-ai-digest-for-saved-articles' ) . '</p>';
    }

    $posts = get_posts( array(
        'post__in'            => $post_ids,
        'orderby'             => 'post__in',
        'posts_per_page'      => -1,
        'ignore_sticky_posts' => true,
        'post_type'           => array( 'post', 'page' ),
    ) );

    ob_start();
    ?>

    <div class="ss-saved-posts-list">
        <h2><?php esc_html_e( 'My Saved Articles', 'save-summarize-ai-digest-for-saved-articles' ); ?></h2>

        <ul class="ss-saved-list">
            <?php foreach ( $posts as $post ) : ?>
                <li class="ss-saved-item">
                    <a class="ss-saved-link" href="<?php echo esc_url( get_permalink($post->ID) ); ?>">
                        <svg class="ss-saved-icon" width="18" height="18" viewBox="0 0 24 24">
                            <path d="M6 2a2 2 0 0 0-2 2v18l8-5 8 5V4a2 2 0 0 0-2-2H6z"
                                fill="#1d72ff"/>
                        </svg>
                        <?php echo esc_html( get_the_title($post->ID) ); ?>
                    </a>
                    <span class="ss-date"><?php echo esc_html( get_the_date('', $post->ID) ); ?></span>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>

    <?php
    $saved_list = ob_get_clean();
    $saveamsu_rendering_saved_list = false;
    return $saved_list;
}
add_shortcode( 'saveamsu_saved_posts', 'saveamsu_render_saved_posts_list' );
