<?php

class SAVEAMSU_Digest {

    public static function init() {
        wp_clear_scheduled_hook( 'ss_weekly_digest_event' );
        add_action( 'saveamsu_weekly_digest_event', array( __CLASS__, 'run_weekly_digest' ) );
    }

    public static function run_weekly_digest() {
        $settings = SAVEAMSU_Settings::get_settings();

        if ( empty( $settings['enable_digest'] ) ) {
            return;
        }

        $users = get_users( array(
            'fields' => array( 'ID', 'user_email', 'display_name' ),
        ) );

        foreach ( $users as $user ) {
            self::send_user_digest( $user, $settings );
        }
    }

    protected static function send_user_digest( $user, $settings ) {
        $post_ids = SAVEAMSU_Bookmarks::get_user_bookmarks( $user->ID );

        if ( empty( $post_ids ) ) {
            return; // nothing to send
        }

        $posts = get_posts( array(
            'post__in'            => $post_ids,
            'orderby'             => 'post__in',
            'posts_per_page'      => -1,
            'ignore_sticky_posts' => true,
        ) );

        if ( empty( $posts ) ) {
            return;
        }

        $subject = $settings['email_subject'];
        $intro   = $settings['email_intro'];

        ob_start();
        ?>
            <div style="background:#f7f8fa;padding:40px 0;font-family:Arial,Helvetica,sans-serif;">
            <div style="max-width:600px;margin:0 auto;background:white;padding:32px 40px;border-radius:14px;border:1px solid #e6e8eb;">
                
                <h1 style="font-size:28px;margin:0 0 5px 0;color:#111;font-weight:700;text-align:center;">
                Your Weekly Digest
                </h1>

                <p style="text-align:center;margin-top:0;margin-bottom:30px;color:#555;font-size:15px;">
                <?php echo esc_html( gmdate( 'F j, Y' ) ); ?>
                </p>

                <hr style="border:0;border-top:1px solid #eee;margin:20px 0;"/>

                <p style="font-size:16px;color:#111;margin-bottom:20px;">
                Hello <?php echo esc_html( $user->display_name ); ?>,
                <br><br>
                Here are this week’s top article picks, just for you:
                </p>

                <?php foreach ( $posts as $post ) : ?>
                <div style="margin-bottom:22px;">
                    <p style="margin:0;font-size:16px;line-height:1.4;">
                    <span style="color:#1a73e8;font-size:18px;">🔖</span>
                    <a href="<?php echo esc_url( get_permalink($post) ); ?>" 
                        style="color:#1a73e8;text-decoration:none;font-weight:600;">
                        <?php echo esc_html( get_the_title($post) ); ?>
                    </a>
                    </p>

                    <p style="margin:6px 0 0 28px;font-size:14px;color:#555;">
                    <?php
                    $summary = SAVEAMSU_AI_Client::summarize_post( $post );
                    echo esc_html( $summary ? $summary : wp_trim_words( wp_strip_all_tags( $post->post_content ), 25 ) );
                    ?>
                    </p>
                </div>
                <?php endforeach; ?>

                <p style="margin-top:40px;font-size:15px;color:#444;">
                Best regards,<br>
                <strong style="color:#111;">Newsletter Inc.</strong>
                </p>

            </div>
            </div>
        <?php
        $message = ob_get_clean();

        $headers = array( 'Content-Type: text/html; charset=UTF-8' );

        wp_mail(
            $user->user_email,
            $subject,
            $message,
            $headers
        );
    }
}
