<?php

class SAVEAMSU_Activator {

    public static function activate() {
        global $wpdb;

        $table_name      = $wpdb->prefix . 'saveamsu_bookmarks';
        $legacy_table    = $wpdb->prefix . 'ss_bookmarks';
        $charset_collate = $wpdb->get_charset_collate();

        $sql = "CREATE TABLE {$table_name} (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            user_id BIGINT(20) UNSIGNED NOT NULL,
            post_id BIGINT(20) UNSIGNED NOT NULL,
            created_at DATETIME NOT NULL,
            PRIMARY KEY  (id),
            UNIQUE KEY user_post (user_id, post_id),
            KEY post_id (post_id)
        ) {$charset_collate};";

        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta( $sql );

        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $new_table_exists    = $wpdb->get_var( $wpdb->prepare( 'SHOW TABLES LIKE %s', $table_name ) );
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching
        $legacy_table_exists = $wpdb->get_var( $wpdb->prepare( 'SHOW TABLES LIKE %s', $legacy_table ) );

        if ( $new_table_exists === $table_name && $legacy_table_exists === $legacy_table ) {
            // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,PluginCheck.Security.DirectDB.UnescapedDBParameter
            $new_table_row_count = (int) $wpdb->get_var( "SELECT COUNT(*) FROM {$table_name}" );

            if ( 0 === $new_table_row_count ) {
                // phpcs:disable WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,PluginCheck.Security.DirectDB.UnescapedDBParameter
                $wpdb->query(
                    "INSERT IGNORE INTO {$table_name} (user_id, post_id, created_at)
                    SELECT user_id, post_id, created_at FROM {$legacy_table}"
                );
                // phpcs:enable WordPress.DB.PreparedSQL.InterpolatedNotPrepared,WordPress.DB.DirectDatabaseQuery.DirectQuery,WordPress.DB.DirectDatabaseQuery.NoCaching,PluginCheck.Security.DirectDB.UnescapedDBParameter
            }
        }

        wp_clear_scheduled_hook( 'ss_weekly_digest_event' );
        wp_clear_scheduled_hook( 'saveamsu_weekly_digest_event' );

        // Schedule weekly digest if not scheduled
        if ( ! wp_next_scheduled( 'saveamsu_weekly_digest_event' ) ) {
            // Schedule to run weekly starting now; you can refine to a fixed weekday/time
            wp_schedule_event( time(), SAVEAMSU_CRON_RECURRENCE, 'saveamsu_weekly_digest_event' );
        }
    }

    public static function deactivate() {
        // Unschedule cron (don't delete table/data on deactivate)
        $timestamp = wp_next_scheduled( 'saveamsu_weekly_digest_event' );
        if ( $timestamp ) {
            wp_unschedule_event( $timestamp, 'saveamsu_weekly_digest_event' );
        }

        wp_clear_scheduled_hook( 'ss_weekly_digest_event' );
    }
}
